/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.apresentacao.mantercontacorrentecliente.view;

import br.com.bb.plugins.gac.apresentacao.BasicInternalFrame;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.apresentacao.mantercontacorrentecliente.form.ManterContaCorrenteForm;
import br.com.bb.plugins.gac.factory.FacadeFactory;
import br.com.bb.plugins.gac.factory.FormFactory;
import br.com.bb.plugins.gac.negocio.facade.ManterContaCorrenteFacade;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ContaCorrenteClienteTODecorator;
import br.com.bb.plugins.gac.util.controller.view.ViewController;
import br.com.bb.plugins.gac.util.mascara.MascaraUtil;
import br.com.bb.plugins.gac.util.objecttablemodel.IObjectContaCorrente;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJPaginacao;
import br.com.bb.plugins.gac.util.swing.componente.BBJTable;
import br.com.bb.plugins.gac.util.swing.componente.BBJTextLabel;
import br.com.bb.plugins.gac.util.swing.menu.BBJMigalha;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewManterContaCorrente
extends BasicInternalFrame {
    private static final long serialVersionUID = 1L;
    private final String[] columnNames = new String[]{"Banco", "Ag\u00eancia", "Conta", "Descri\u00e7\u00e3o da conta", "Status"};
    private final int[] columnSizes = new int[]{180, 70, 70, 180, 50};
    private final int[] columnAligment = new int[]{2, 2, 2, 2, 2};
    private BBJTable<IObjectContaCorrente> tableModel;
    private JTable table;
    private JPanel panelBotoes;
    private JPanel panelTabelaPaginadorBotoes;
    private JPanel panelPrincipal;
    private JPanel panelPaginadorBotoes;
    private JPanel panelDadosBeneficiarios;
    private BBJButton botaoNovo;
    private BBJButton botaoExcluir;
    private BBJButton botaoVoltar;
    private BBJButton botaoDetalhar;
    private BBJTextLabel txtInscricao = null;
    private BBJTextLabel txtNome = null;
    private BBJLabel labelBeneficiario = null;
    private BBJLabel labelInscricao = null;
    private BBJPaginacao paginacao;
    private Map context = null;
    private PessoaTO pessoaTO;
    private BBJButton botaoEditar;

    public ViewManterContaCorrente() {
        super("Manter Contas Correntes - Lista", false, false);
        this.initialize();
    }

    private void initialize() {
        this.add(this.getPanelPrincipal());
    }

    @Override
    public void doShow(Map context) {
        if (context == null) {
            context = this.context;
        }
        this.setContext(context);
        if (this.getContext().get("pessoaTO") != null) {
            PessoaTO pessoaTO = (PessoaTO)this.getContext().get("pessoaTO");
            this.setPessoaTO(pessoaTO);
            this.getManterContaCorrenteForm().setCodigoPessoa(this.getPessoaTO().getCodigoPessoa());
            this.setaHeader();
        }
        this.getManterContaCorrenteForm().setPaginaAtual(1);
        this.getManterContaCorrenteForm().setLista(this.getFacade().listarContas(this.getPessoaTO()));
        this.getPaginacao().setValorMaximo(this.calculaQuantidadeDePaginas(this.getManterContaCorrenteForm()));
        this.getPaginacao().setValorPos(1);
        this.getPaginacao().atualiza();
        this.popularTabela();
        this.setVisible(true);
    }

    private int calculaQuantidadeDePaginas(ManterContaCorrenteForm manterContaCorrenteForm) {
        int qtdPaginas = 1;
        double qtdRegistros = manterContaCorrenteForm.getLista().size();
        qtdPaginas = Double.valueOf(Math.ceil(qtdRegistros / 10.0)).intValue();
        return qtdPaginas;
    }

    private void popularTabela() {
        this.getManterContaCorrenteForm().setPaginatorTO(this.getFacade().paginarListaConta(this.getManterContaCorrenteForm().getLista(), this.getManterContaCorrenteForm().getContaCorrenteClienteTODecorator()));
        this.atualizarTabela();
    }

    public void setaHeader() {
        this.getLabelBeneficiario().setText("Benefici\u00e1rio: " + this.getPessoaTO().getTextoNome());
        Set<IdentificacaoTO> set = this.getPessoaTO().getIdentificacaoTOs();
        Iterator<IdentificacaoTO> identificacao = set.iterator();
        if (identificacao.hasNext()) {
            IdentificacaoTO identificacaoTO = identificacao.next();
            this.getLabelInscricao().setText("Inscri\u00e7\u00e3o:" + MascaraUtil.mascaraInscricao(identificacaoTO.getId().getTextoIdentificacao()));
        }
    }

    public ManterContaCorrenteForm getManterContaCorrenteForm() {
        return (ManterContaCorrenteForm)this.getForm();
    }

    @Override
    protected PluginFormAbstrato novoForm() {
        return FormFactory.getInstancia().novoManterContaCorrenteForm();
    }

    public JPanel getPanelPrincipal() {
        if (this.panelPrincipal == null) {
            this.panelPrincipal = new JPanel();
            this.panelPrincipal.setLayout(new BorderLayout());
            this.panelPrincipal.setBackground(Color.WHITE);
            this.panelPrincipal.add((Component)this.getPanelDadosBeneficiarios(), "North");
            this.panelPrincipal.add((Component)this.getPanelTabelaPaginadorBotoes(), "Center");
        }
        return this.panelPrincipal;
    }

    protected JPanel getPanelDadosBeneficiarios() {
        if (this.panelDadosBeneficiarios == null) {
            this.panelDadosBeneficiarios = new JPanel();
            this.panelDadosBeneficiarios.setOpaque(false);
            this.panelDadosBeneficiarios.setLayout(new GridBagLayout());
            this.panelDadosBeneficiarios.setPreferredSize(new Dimension(0, 50));
            this.panelDadosBeneficiarios.setBorder(BBJBordaOval.createOvalBorder());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(4, 6, 4, 6);
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.weightx = 0.15;
            this.panelDadosBeneficiarios.add((Component)this.getLabelBeneficiario(), gbc);
            gbc.gridx = 2;
            gbc.weightx = 0.15;
            this.panelDadosBeneficiarios.add((Component)this.getLabelInscricao(), gbc);
        }
        return this.panelDadosBeneficiarios;
    }

    protected BBJLabel getLabelBeneficiario() {
        if (this.labelBeneficiario == null) {
            this.labelBeneficiario = new BBJLabel("Benefici\u00e1rio: ");
        }
        return this.labelBeneficiario;
    }

    protected BBJLabel getLabelInscricao() {
        if (this.labelInscricao == null) {
            this.labelInscricao = new BBJLabel("Inscri\u00e7\u00e3o: ");
        }
        return this.labelInscricao;
    }

    public JPanel getPanelTabelaPaginadorBotoes() {
        if (this.panelTabelaPaginadorBotoes == null) {
            this.panelTabelaPaginadorBotoes = new JPanel();
            this.panelTabelaPaginadorBotoes.setLayout(new BorderLayout());
            this.panelTabelaPaginadorBotoes.setOpaque(false);
            this.panelTabelaPaginadorBotoes.add((Component)this.getPainelTabela(), "North");
            this.panelTabelaPaginadorBotoes.add((Component)this.getPanelPaginadorBotoes(), "Center");
        }
        return this.panelTabelaPaginadorBotoes;
    }

    public JPanel getPanelPaginadorBotoes() {
        if (this.panelPaginadorBotoes == null) {
            this.panelPaginadorBotoes = new JPanel();
            this.panelPaginadorBotoes.setLayout(new BorderLayout());
            this.panelPaginadorBotoes.setOpaque(false);
            this.panelPaginadorBotoes.add((Component)this.getPaginacao(), "North");
            this.panelPaginadorBotoes.add((Component)this.getPainelBotoes(), "Center");
        }
        return this.panelPaginadorBotoes;
    }

    private JPanel getPainelBotoes() {
        this.panelBotoes = new JPanel();
        this.panelBotoes.setOpaque(false);
        FlowLayout flw = new FlowLayout();
        flw.setAlignment(2);
        this.panelBotoes.setLayout(flw);
        this.panelBotoes.add(this.getBotaoNovo());
        this.panelBotoes.add(this.getBotaoEditar());
        this.panelBotoes.add(this.getBotaoDetalhar());
        this.panelBotoes.add(this.getBotaoExcluir());
        this.panelBotoes.add(this.getBotaoVoltar());
        return this.panelBotoes;
    }

    private JPanel getPainelTabela() {
        JPanel pTabela = new JPanel();
        Dimension d = new Dimension(530, 207);
        pTabela.setBorder(BBJBordaOval.createOvalBorder(""));
        pTabela.setSize(d);
        pTabela.setPreferredSize(d);
        pTabela.setOpaque(false);
        this.tableModel = new BBJTable<IObjectContaCorrente>(this.columnNames, this.columnSizes, this.columnAligment, 5){

            @Override
            public void metodoInMouseClicked() {
                ViewManterContaCorrente.this.habilitaBotoes();
            }
        };
        this.tableModel.setNomeColunas(new String[]{"0", "1", "2", "3", "4"});
        this.tableModel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (arg0.getActionCommand().equalsIgnoreCase("EVENTO_ORDENACAO")) {
                    ViewManterContaCorrente.this.getManterContaCorrenteForm().getContaCorrenteClienteTODecorator().setNomeColunaOrdenada(ViewManterContaCorrente.this.tableModel.getNomeColunaOrdenada());
                    ViewManterContaCorrente.this.getManterContaCorrenteForm().getContaCorrenteClienteTODecorator().setTipoOrdenacao(ViewManterContaCorrente.this.tableModel.getTipoordenacao());
                    ViewManterContaCorrente.this.ordenarListaContaGrupoDecorator();
                    ViewManterContaCorrente.this.popularTabela();
                }
                ViewManterContaCorrente.this.habilitaBotoes();
            }
        });
        this.table = new JTable();
        this.table.setModel(this.tableModel);
        this.table.setOpaque(false);
        this.tableModel.setTableProps(this.table);
        this.tableModel.setOrdenacaoAutomatica(false);
        pTabela.setLayout(new BorderLayout());
        JPanel pnl = new JPanel();
        pnl.setOpaque(false);
        pnl.setLayout(new BorderLayout());
        pnl.add((Component)this.table.getTableHeader(), "North");
        pnl.add((Component)this.table, "Center");
        pTabela.add(pnl);
        return pTabela;
    }

    private void ordenarListaContaGrupoDecorator() {
        Collections.sort(this.getManterContaCorrenteForm().getLista(), new Comparator<ContaCorrenteClienteTO>(){

            @Override
            public int compare(ContaCorrenteClienteTO o1, ContaCorrenteClienteTO o2) {
                ContaCorrenteClienteTO comparado2;
                ContaCorrenteClienteTO comparado1;
                if (ViewManterContaCorrente.this.tableModel.getTipoordenacao().equalsIgnoreCase("ASC")) {
                    comparado1 = o1;
                    comparado2 = o2;
                } else {
                    comparado1 = o2;
                    comparado2 = o1;
                }
                switch (Integer.parseInt(ViewManterContaCorrente.this.tableModel.getNomeColunaOrdenada())) {
                    case 0: {
                        return comparado1.getAgenciaInstituicaoFinanceiraTO().getCodigoInstituicaoFinanceira().compareTo(comparado2.getAgenciaInstituicaoFinanceiraTO().getCodigoInstituicaoFinanceira());
                    }
                    case 1: {
                        return comparado1.getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia().compareTo(comparado2.getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia());
                    }
                    case 2: {
                        return comparado1.getId().getCodigoContaCorrente().compareTo(comparado2.getId().getCodigoContaCorrente());
                    }
                    case 3: {
                        return ViewManterContaCorrente.this.recuperaCampoPreenchidoOuVazio(comparado1.getTextoDescricaoContaCorrente()).compareTo(ViewManterContaCorrente.this.recuperaCampoPreenchidoOuVazio(comparado2.getTextoDescricaoContaCorrente()));
                    }
                    case 4: {
                        return ViewManterContaCorrente.this.recuperaCampoPreenchidoOuVazio(String.valueOf(comparado1.getIndicadorEstadoContaCorrente())).compareTo(ViewManterContaCorrente.this.recuperaCampoPreenchidoOuVazio(String.valueOf(comparado2.getIndicadorEstadoContaCorrente())));
                    }
                }
                return 0;
            }
        });
        this.atualizarTabela();
    }

    protected String recuperaCampoPreenchidoOuVazio(String campo) {
        return campo == null ? "" : campo;
    }

    public BBJPaginacao getPaginacao() {
        if (this.paginacao == null) {
            this.paginacao = new BBJPaginacao();
            this.paginacao.addPropertyChangeListener("paginacao", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    ViewManterContaCorrente.this.getManterContaCorrenteForm().getContaCorrenteClienteTODecorator().setPaginaAtual((Integer)evt.getNewValue());
                    ViewManterContaCorrente.this.popularTabela();
                }
            });
        }
        return this.paginacao;
    }

    public void atualizarTabela() {
        ManterContaCorrenteForm form = (ManterContaCorrenteForm)this.getForm();
        this.tableModel.setDataListTabela(this.conversorDataList(form.getPaginatorTO().getColecaoDeRegistros()));
        this.habilitaBotoes();
    }

    protected List<IObjectContaCorrente> conversorDataList(Collection<?> colecao) {
        ArrayList<ContaCorrenteClienteTODecorator> lista = new ArrayList<ContaCorrenteClienteTODecorator>();
        ArrayList<IObjectContaCorrente> listaContaCorrenteGrupo = new ArrayList<IObjectContaCorrente>();
        for (Object contaTO : colecao) {
            ContaCorrenteClienteTO contaCorrenteClienteTO = (ContaCorrenteClienteTO)contaTO;
            ContaCorrenteClienteTODecorator dec = new ContaCorrenteClienteTODecorator(contaCorrenteClienteTO);
            lista.add(dec);
        }
        int i = 0;
        while (i < lista.size()) {
            ContaCorrenteClienteTODecorator contaCorrenteClienteTODecorator = (ContaCorrenteClienteTODecorator)lista.get(i);
            IObjectContaCorrente iObjectContaCorrente = new IObjectContaCorrente(contaCorrenteClienteTODecorator);
            listaContaCorrenteGrupo.add(iObjectContaCorrente);
            ++i;
        }
        return listaContaCorrenteGrupo;
    }

    private void habilitaBotoes() {
        if (this.tableModel.getItensChecadosCheckBox().size() > 0) {
            this.getBotaoExcluir().setEnabled(true);
            this.getBotaoDetalhar().setEnabled(true);
            this.getBotaoEditar().setEnabled(true);
        } else {
            this.getBotaoExcluir().setEnabled(false);
            this.getBotaoDetalhar().setEnabled(false);
            this.getBotaoEditar().setEnabled(false);
        }
    }

    public BBJButton getBotaoNovo() {
        if (this.botaoNovo == null) {
            this.botaoNovo = new BBJButton("NOVO", true);
            this.botaoNovo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ViewManterContaCorrente.this.getContext().clear();
                    ViewManterContaCorrente.this.getManterContaCorrenteForm().setPessoaTO(ViewManterContaCorrente.this.getPessoaTO());
                    ViewManterContaCorrente.this.getManterContaCorrenteForm().setAcao(1);
                    ViewManterContaCorrente.this.getContext().put("form", ViewManterContaCorrente.this.getManterContaCorrenteForm());
                    ViewManterContaCorrente.this.getContext().put("permiteInclusaoIspb", (Boolean)ViewManterContaCorrente.this.getContext().get("permiteInclusaoIspb"));
                    ViewController.getInstance().goToView("GACMANTERCONTAPOPUP", ViewManterContaCorrente.this.getContext(), true);
                    BBJMigalha.getInstance().Empilhar("GACMANTERCONTAPOPUP", "Inlcuir Conta Corrente");
                }
            });
        }
        return this.botaoNovo;
    }

    public BBJButton getBotaoVoltar() {
        if (this.botaoVoltar == null) {
            this.botaoVoltar = this.getBotaoFactory().novoVoltar();
        }
        return this.botaoVoltar;
    }

    public BBJButton getBotaoEditar() {
        if (this.botaoEditar == null) {
            this.botaoEditar = new BBJButton("EDITAR", true);
            this.botaoEditar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ViewManterContaCorrente.this.getContext().clear();
                    ViewManterContaCorrente.this.getManterContaCorrenteForm().setPessoaTO(ViewManterContaCorrente.this.getPessoaTO());
                    ViewManterContaCorrente.this.getManterContaCorrenteForm().setAcao(2);
                    ViewManterContaCorrente.this.getContext().put("form", ViewManterContaCorrente.this.getManterContaCorrenteForm());
                    ViewManterContaCorrente.this.getContext().put("dados", ViewManterContaCorrente.this.getIObjectFromTable());
                    ViewController.getInstance().goToView("GACMANTERCONTAPOPUP", ViewManterContaCorrente.this.getContext(), true);
                    BBJMigalha.getInstance().Empilhar("GACMANTERCONTAPOPUP", "Editar Conta Corrente");
                }
            });
            this.botaoEditar.setEnabled(false);
        }
        return this.botaoEditar;
    }

    public BBJButton getBotaoDetalhar() {
        if (this.botaoDetalhar == null) {
            this.botaoDetalhar = new BBJButton("DETALHAR", true);
            this.botaoDetalhar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ViewManterContaCorrente.this.getContext().clear();
                    ViewManterContaCorrente.this.getManterContaCorrenteForm().setPessoaTO(ViewManterContaCorrente.this.getPessoaTO());
                    ViewManterContaCorrente.this.getManterContaCorrenteForm().setAcao(5);
                    ViewManterContaCorrente.this.getContext().put("form", ViewManterContaCorrente.this.getManterContaCorrenteForm());
                    ViewManterContaCorrente.this.getContext().put("dados", ViewManterContaCorrente.this.getIObjectFromTable());
                    ViewController.getInstance().goToView("GACMANTERCONTAPOPUP", ViewManterContaCorrente.this.getContext(), true);
                    BBJMigalha.getInstance().Empilhar("GACMANTERCONTAPOPUP", "Detalhar Conta Corrente");
                }
            });
            this.botaoDetalhar.setEnabled(false);
        }
        return this.botaoDetalhar;
    }

    public BBJButton getBotaoExcluir() {
        if (this.botaoExcluir == null) {
            this.botaoExcluir = new BBJButton("EXCLUIR", true);
            this.botaoExcluir.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ViewManterContaCorrente.this.getContext().clear();
                    ViewManterContaCorrente.this.getManterContaCorrenteForm().setPessoaTO(ViewManterContaCorrente.this.getPessoaTO());
                    ViewManterContaCorrente.this.getManterContaCorrenteForm().setAcao(3);
                    ViewManterContaCorrente.this.getContext().put("form", ViewManterContaCorrente.this.getManterContaCorrenteForm());
                    ViewManterContaCorrente.this.getContext().put("dados", ViewManterContaCorrente.this.getIObjectFromTable());
                    ViewController.getInstance().goToView("GACMANTERCONTAPOPUP", ViewManterContaCorrente.this.getContext(), true);
                    BBJMigalha.getInstance().Empilhar("GACMANTERCONTAPOPUP", "Excluir Conta Corrente");
                }
            });
            this.botaoExcluir.setEnabled(false);
        }
        return this.botaoExcluir;
    }

    public BBJTextLabel getTxtNome() {
        if (this.txtNome == null) {
            this.txtNome = new BBJTextLabel("Nome:", 60, false, 0, 250, 45);
            this.txtNome.setName("textoNome");
        }
        return this.txtNome;
    }

    public BBJTextLabel getTxtInscricao() {
        if (this.txtInscricao == null) {
            this.txtInscricao = new BBJTextLabel("Inscri\u00e7\u00e3o:", 20, false, 0, 250, 70);
            this.txtInscricao.setName("textoInscricao");
        }
        return this.txtInscricao;
    }

    private ManterContaCorrenteFacade getFacade() {
        return FacadeFactory.getInstancia().novoManterContaCorrenteFacade();
    }

    public Map getContext() {
        if (this.context == null) {
            this.context = new HashMap();
        }
        return this.context;
    }

    public void setContext(Map context) {
        this.context = context;
    }

    public void setPessoaTO(PessoaTO pessoaTO) {
        this.pessoaTO = pessoaTO;
    }

    public PessoaTO getPessoaTO() {
        return this.pessoaTO;
    }

    protected IObjectContaCorrente getIObjectFromTable() {
        List<IObjectContaCorrente> lista = this.tableModel.getItensChecadosCheckBox();
        IObjectContaCorrente obj = lista.get(0);
        return obj;
    }

    @Override
    public void posExecucaoFecharAction() {
        this.doClose(null);
    }

    public static void main(String[] args) {
        JFrame fra = new JFrame();
        Dimension d = new Dimension(750, 510);
        fra.setSize(new Dimension(d));
        fra.setPreferredSize(d);
        ViewManterContaCorrente view = new ViewManterContaCorrente();
        fra.getContentPane().add(view);
        view.show();
        fra.setDefaultCloseOperation(2);
        fra.setVisible(true);
    }
}

