/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.factory;

import br.com.bb.plugins.gac.integracao.dao.DAO;
import br.com.bb.plugins.gac.util.controller.view.ApplicationContextFactory;
import br.com.politec.generico.objeto.UtilObjeto;
import java.util.Map;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DAOFactory {
    private Map<String, String> mapaDeDAO;

    private DAOFactory() {
    }

    public static DAOFactory getInstancia() {
        String nome = UtilObjeto.getNomeSemPacote(DAOFactory.class);
        return (DAOFactory)DAOFactory.getApplicationContext().getBean(nome);
    }

    public Map<String, String> getMapaDeDAO() {
        return this.mapaDeDAO;
    }

    public void setMapaDeDAO(Map mapaDeDAO) {
        this.mapaDeDAO = mapaDeDAO;
    }

    private static ApplicationContext getApplicationContext() {
        return DAOFactory.getApplicationContextFactory().getApplicationContext();
    }

    private static ApplicationContextFactory getApplicationContextFactory() {
        return ApplicationContextFactory.getInstance();
    }

    public <T extends DAO> T getDAO(T ... t) {
        String nome = this.getNome(t.getClass().getComponentType());
        nome = this.getMapaDeDAO().get(nome);
        return (T)((DAO)DAOFactory.getApplicationContext().getBean(nome));
    }

    private String getNome(Class classe) {
        return UtilObjeto.getNomeSemPacote(classe);
    }
}

