/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.CamposLeiauteDAO;
import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.negocio.to.CamposLeiauteTO;
import br.com.bb.plugins.gac.negocio.to.CamposLeiauteTOId;
import br.com.bb.plugins.gac.negocio.to.TipoLeiauteTO;
import br.com.politec.generico.calculadores.UtilSomadoresDeNumero;
import br.com.politec.generico.colecao.UtilColecao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamposLeiauteDAOImpl
extends HibernateDAO<CamposLeiauteTO, CamposLeiauteTOId>
implements CamposLeiauteDAO {
    @Override
    protected Class<CamposLeiauteTO> novoTipoDeObjetoPersistente() {
        return CamposLeiauteTO.class;
    }

    @Override
    protected CamposLeiauteTOId getChavePrimaria(CamposLeiauteTO to) {
        return to.getId();
    }

    @Override
    public Collection<CamposLeiauteTO> consultarPorTipoDeLeiaute(TipoLeiauteTO tipo) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPorTipoDeLeiaute(query, tipo);
        return query.list();
    }

    @Override
    protected void incrementarChaveComposta(CamposLeiauteTOId chave) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("id.numeroLeiaute", chave.getNumeroLeiaute()));
        query.setProjection((Projection)Projections.max((String)"id.numeroCampoLeiaute"));
        List colecao = query.list();
        Integer max = (Integer)UtilColecao.getElementoDoIndice((Collection)colecao, 0);
        max = UtilSomadoresDeNumero.somar(max, 1);
        chave.setNumeroCampoLeiaute(max);
    }

    private void adicionarCriterioConsultarPorTipoDeLeiaute(Criteria query, TipoLeiauteTO tipoLeiauteTO) {
        Integer codigo = tipoLeiauteTO.getCodigoTipoLeiaute();
        if (!this.isZero(codigo)) {
            Criteria leiaute = this.getCriteria(query, "leiauteTO");
            Criteria tipo = this.getCriteria(leiaute, "tipoLeiauteTO");
            tipo.add(this.novoCriterioEQ("codigoTipoLeiaute", codigo));
            leiaute.add(Restrictions.isNull((String)"indicadorLeiauteModelo"));
        }
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public CamposLeiauteTO incluirSemIncrementoDeChave(CamposLeiauteTO object) {
        try {
            this.getSession().save((Object)object);
            return object;
        }
        catch (HibernateException e) {
            throw this.convertHibernateAccessException(e);
        }
    }

    @Override
    public List<CamposLeiauteTOId> listarChavesCompostasCamposLeiaute() {
        ArrayList<CamposLeiauteTOId> retorno = new ArrayList<CamposLeiauteTOId>();
        ArrayList<Integer> filtroTiposDeLayout = new ArrayList<Integer>();
        filtroTiposDeLayout.add(25);
        filtroTiposDeLayout.add(26);
        filtroTiposDeLayout.add(27);
        filtroTiposDeLayout.add(33);
        filtroTiposDeLayout.add(34);
        filtroTiposDeLayout.add(35);
        filtroTiposDeLayout.add(46);
        filtroTiposDeLayout.add(47);
        filtroTiposDeLayout.add(48);
        for (Integer numeroleiaute : filtroTiposDeLayout) {
            Criteria query = this.novaCriteria();
            query.add(this.novoCriterioEQ("id.numeroLeiaute", numeroleiaute));
            query.setProjection((Projection)Projections.max((String)"id.numeroCampoLeiaute"));
            ArrayList colecao = (ArrayList)query.list();
            CamposLeiauteTOId chaveCamposLeiaut = new CamposLeiauteTOId();
            chaveCamposLeiaut.setNumeroCampoLeiaute((Integer)UtilColecao.getElementoDoIndice((Collection)colecao, 0) + 1);
            chaveCamposLeiaut.setNumeroLeiaute(numeroleiaute);
            retorno.add(chaveCamposLeiaut);
        }
        return retorno;
    }
}

