/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.ContatoDAO;
import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.negocio.to.ContatoTO;
import br.com.bb.plugins.gac.negocio.to.ContatoTOId;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.politec.generico.calculadores.UtilSomadoresDeNumero;
import br.com.politec.generico.colecao.UtilColecao;
import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContatoDAOImpl
extends HibernateDAO<ContatoTO, ContatoTOId>
implements ContatoDAO {
    @Override
    protected Class<ContatoTO> novoTipoDeObjetoPersistente() {
        return ContatoTO.class;
    }

    @Override
    protected ContatoTOId getChavePrimaria(ContatoTO to) {
        return to.getId();
    }

    @Override
    public Collection<ContatoTO> consultarPelaPessoa(PessoaTO to) {
        Integer codigoPessoa = to.getCodigoPessoa();
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("pessoaTO.codigoPessoa", codigoPessoa));
        return query.list();
    }

    @Override
    protected void incrementarChaveComposta(ContatoTOId chave) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("id.codigoPessoa", chave.getCodigoPessoa()));
        query.add(this.novoCriterioEQ("id.codigoTipoContato", chave.getCodigoTipoContato()));
        query.setProjection((Projection)Projections.max((String)"id.numeroIdentificadorContato"));
        List colecao = query.list();
        Integer max = (Integer)UtilColecao.getElementoDoIndice((Collection)colecao, 0);
        max = UtilSomadoresDeNumero.somar(max, 1);
        chave.setNumeroIdentificadorContato(max);
    }
}

