/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.ConvenenteDAO;
import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PluginTODecoratorAbstrato;
import br.com.bb.plugins.gac.negocio.to.TipoDocumentoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenenteTODecorator;
import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvenenteDAOImpl
extends HibernateDAO<ConvenenteTO, Integer>
implements ConvenenteDAO {
    @Override
    protected Class<ConvenenteTO> novoTipoDeObjetoPersistente() {
        return ConvenenteTO.class;
    }

    @Override
    protected Integer getChavePrimaria(ConvenenteTO to) {
        return to.getCodigoPessoaConvenente();
    }

    @Override
    public PaginadorTO consultarPeloTipoDeDocumento(ConvenenteTODecorator decorator) {
        Criteria query = this.novaCriteria();
        Criteria pessoa = this.getCriteria(query, "pessoaTO");
        this.getCriteria(pessoa, "identificacaoTOs");
        if (decorator.getServico().getTextoIdentificadorServico() != null) {
            Criteria servicoConvenente = this.getCriteria(query, "servicoConvenenteTOs");
            servicoConvenente.add(this.novoCriterioEQ("id.textoIdentificadorServico", decorator.getServico().getTextoIdentificadorServico()));
        }
        this.adicionarCriterioConsultarPeloTipoDeDocumento(query, decorator);
        PaginadorTO paginadorTO = this.novoPaginadorTO(query, (PluginTODecoratorAbstrato)decorator);
        return paginadorTO;
    }

    @Override
    public boolean isExistePessoa(ConvenenteTO convenenteTO) {
        if (convenenteTO.getCodigoPessoaConvenente() != null) {
            StringBuilder sql = new StringBuilder();
            sql.append("select convenenteTO from ConvenenteTO convenenteTO ");
            sql.append("where convenenteTO.codigoPessoaConvenente   = :pcodigoPessoaConvenente");
            int numeroRegistros = this.getSession().createQuery(sql.toString()).setInteger("pcodigoPessoaConvenente", convenenteTO.getCodigoPessoaConvenente().intValue()).list().size();
            return numeroRegistros > 0;
        }
        return false;
    }

    private void adicionarCriterioPeloCodigoDoConvenente(Criteria query, ConvenenteTO convenenteTO) {
        Integer codigo = convenenteTO.getCodigoPessoaConvenente();
        query.add(this.novoCriterioEQ("codigoPessoaConvenente", codigo));
    }

    private void adicionarCriterioConsultarPeloTipoDeDocumento(Criteria query, ConvenenteTODecorator decorator) {
        Collection<TipoDocumentoTO> colecao = decorator.getColecaoTipoDocumento();
        if (!this.isVazio(colecao)) {
            Criterion criterion = this.novoCriterioIN("codigoTipoDocumento", colecao, "codigoTipoDocumento");
            Criteria pessoa = this.getCriteria(query, "pessoaTO");
            Criteria idfc = this.getCriteria(pessoa, "identificacaoTOs");
            Criteria tipoDocumento = this.getCriteria(idfc, "tipoDocumentoTO");
            tipoDocumento.add(criterion);
        }
    }

    @Override
    public void alterar(Integer tipoDoc, String txIdfr, ConvenenteTO convenente) {
        if (convenente != null) {
            StringBuffer hql = new StringBuffer();
            hql.append("UPDATE ConvenenteTO  set ");
            hql.append("identificadorTO.id.textoIdentificador=:textoIdentificador, ");
            hql.append("tipoDocumentoTO.codigoTipoDocumento=:codigoTipoDocumento");
            hql.append(" WHERE codigoPessoaConvenente=:codigoPessoaConvenente");
            Query queryConvenente = this.novaQuery(hql.toString());
            if (tipoDoc == null) {
                tipoDoc = 0;
            }
            queryConvenente.setInteger("codigoTipoDocumento", tipoDoc.intValue());
            queryConvenente.setText("textoIdentificador", txIdfr);
            queryConvenente.setInteger("codigoPessoaConvenente", convenente.getCodigoPessoaConvenente().intValue());
            int n = queryConvenente.executeUpdate();
        }
    }

    @Override
    public boolean isExisteConvenio(ConvenioTO convenioTO) {
        if (convenioTO == null) {
            return false;
        }
        if (convenioTO.getId() == null) {
            return false;
        }
        if (convenioTO.getId().getNumeroConvenio() != null && convenioTO.getId().getCodigoPessoaConvenente() != null && convenioTO.getId().getTextoIdentificadorServico() != null) {
            StringBuffer sql = new StringBuffer();
            sql.append("select to from ConvenioTO to ");
            sql.append("where to.id.numeroConvenio            = '" + convenioTO.getId().getNumeroConvenio() + "'");
            sql.append("  and to.id.codigoPessoaConvenente    = '" + convenioTO.getId().getCodigoPessoaConvenente() + "'");
            sql.append("  and to.id.textoIdentificadorServico = '" + convenioTO.getId().getTextoIdentificadorServico() + "'");
            int numeroRegistros = this.getSession().createQuery(sql.toString()).list().size();
            return numeroRegistros > 0;
        }
        return false;
    }

    @Override
    public void excluirConvenente(Integer codigoPessoaConvenente) {
        ConvenenteTO convenenteTO = null;
        Criteria criteria = this.novaCriteria();
        Criterion criterion = this.novoCriterioEQ("codigoPessoaConvenente", codigoPessoaConvenente);
        criteria.add(criterion);
        List resultado = criteria.list();
        String hql = "delete from RemessaTO  where convenioTO.id.codigoPessoaConvenente = :codigoPessoaConvenente";
        this.executarHQLExclusao(codigoPessoaConvenente, hql);
        if (this.isReferencia(resultado) && resultado.size() > 0 && (convenenteTO = (ConvenenteTO)resultado.get(0)).getIdentificadorTO() != null) {
            Query queryConvenente = this.novaQuery("delete from IdentificadorTO where id.textoIdentificador = :textoIdentificador and id.codigoTipoDocumento = :codigoTipoDocumento");
            queryConvenente.setString("textoIdentificador", convenenteTO.getIdentificadorTO().getId().getTextoIdentificador());
            queryConvenente.setInteger("codigoTipoDocumento", convenenteTO.getIdentificadorTO().getId().getCodigoTipoDocumento().intValue());
            queryConvenente.executeUpdate();
        }
    }

    private void executarHQLExclusao(Integer codigoPessoaConvenente, String hql) {
        Query queryConvenente = this.novaQuery(hql);
        queryConvenente.setInteger("codigoPessoaConvenente", codigoPessoaConvenente.intValue());
        int linhasAfetadas = queryConvenente.executeUpdate();
        System.out.println("Registros deletados: " + linhasAfetadas);
    }

    @Override
    public Collection<ConvenenteTO> consultarPorServico(String servico) {
        Criteria queryConvenenteServico = this.novaCriteria();
        queryConvenenteServico.setProjection(Projections.distinct((Projection)Projections.property((String)"codigoPessoaConvenente")));
        Criteria servicoConvenenteTOs = this.getCriteria(queryConvenenteServico, "servicoConvenenteTOs");
        Criteria servicoTO = this.getCriteria(servicoConvenenteTOs, "servicoTO");
        servicoTO.add(this.novoCriterioEQ("textoIdentificadorServico", servico));
        Criteria queryConvenente = this.novaCriteria();
        queryConvenente.add(this.novoCriterioIN("codigoPessoaConvenente", queryConvenenteServico.list(), null));
        return queryConvenente.list();
    }

    @Override
    public ConvenenteTO listarPorIdentificacao(String identificacao) {
        Criteria queryConvenente = this.novaCriteria();
        Criteria queryPessoa = this.getCriteria(queryConvenente, "pessoaTO");
        Criteria queryIdentificacao = this.getCriteria(queryPessoa, "identificacaoTOs");
        queryIdentificacao.add(this.novoCriterioEQ("id.textoIdentificacao", identificacao));
        List lista = queryConvenente.list();
        if (this.isReferencia(lista) && lista.size() > 0) {
            return (ConvenenteTO)lista.get(0);
        }
        return null;
    }

    @Override
    public boolean isExisteConvenio(ConvenenteTO convenente, String textoIdentificadorServico) {
        String hql = "select to from ConvenioTO to  where to.id.codigoPessoaConvenente = :codigoPessoaConvenente and  to.id.textoIdentificadorServico = :textoIdentificadorServico";
        Query queryConvenente = this.novaQuery(hql);
        queryConvenente.setInteger("codigoPessoaConvenente", convenente.getCodigoPessoaConvenente().intValue());
        queryConvenente.setString("textoIdentificadorServico", textoIdentificadorServico);
        List lista = queryConvenente.list();
        return lista == null ? false : lista.size() > 0;
    }
}

