/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.ConvenentePessoaDAO;
import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.integracao.dao.UtilRestricaoDAO;
import br.com.bb.plugins.gac.negocio.to.ConvenentePessoaTO;
import br.com.bb.plugins.gac.negocio.to.ConvenentePessoaTOId;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.GrupoClienteRecebimentoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PluginTODecoratorAbstrato;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenentePessoaTODecorator;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.objeto.UtilPrimitivo;
import br.com.politec.generico.string.UtilString;
import br.com.politec.generico.validador.UtilValidadorDeStringsIguais;
import java.util.ArrayList;
import java.util.Collection;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvenentePessoaDAOImpl
extends HibernateDAO<ConvenentePessoaTO, ConvenentePessoaTOId>
implements ConvenentePessoaDAO {
    @Override
    protected Class<ConvenentePessoaTO> novoTipoDeObjetoPersistente() {
        return ConvenentePessoaTO.class;
    }

    @Override
    protected ConvenentePessoaTOId getChavePrimaria(ConvenentePessoaTO to) {
        return to.getId();
    }

    @Override
    public PaginadorTO consultarPorFiltro(ConvenentePessoaTODecorator decorator) {
        Criteria query = this.getCriterioConsultarPorFiltro(decorator);
        return this.novoPaginadorTO(query, (PluginTODecoratorAbstrato)decorator);
    }

    @Override
    public Collection<ConvenentePessoaTO> consultarPorFiltroRetornandoColecao(ConvenentePessoaTODecorator decorator) {
        Criteria query = this.getCriterioConsultarPorFiltro(decorator);
        return query.list();
    }

    private void adicionarCriterioConsultarPorNome(Criteria query, ConvenentePessoaTODecorator decorator) {
        String nome = decorator.getTextoNome();
        if (!this.isVazio(nome)) {
            Criteria pessoa = this.getCriteria(query, "pessoaTO");
            pessoa.add(this.novoCriterioLike("textoNome", nome));
        }
    }

    private void adicionarCriterioConsultarPorIdentificacaoEIdentificador(Criteria query, ConvenentePessoaTODecorator decorator) {
        String sigla;
        Criteria pessoa = this.getCriteria(query, "pessoaTO");
        Criteria identificacao = this.getCriteria(pessoa, "identificacaoTOs", "identPessoa", 1);
        if (decorator.getDataInicial() != null || decorator.getDataFinal() != null) {
            identificacao.add(this.novoCriterioBetween("dataEmissao", decorator.getDataInicial(), decorator.getDataFinal()));
        }
        ArrayList<Integer> colecao = new ArrayList<Integer>();
        if (decorator.getIdentificacaoTO().getTipoDocumentoTO().getCodigoTipoDocumento() == null) {
            colecao.add(1);
            colecao.add(2);
            Criterion identcpfcnpj = this.novoCriterioIN("identPessoa.id.codigoTipoDocumento", colecao, null);
            Criterion identnull = Restrictions.isNull((String)"identPessoa.id.codigoTipoDocumento");
            identificacao.add((Criterion)Restrictions.or((Criterion)identnull, (Criterion)identcpfcnpj));
        } else {
            colecao.add(decorator.getIdentificacaoTO().getTipoDocumentoTO().getCodigoTipoDocumento());
            this.novoCriterioIN("identPessoa.id.codigoTipoDocumento", colecao, null);
        }
        String txIdentificacao = decorator.getIdentificacaoTO().getId().getTextoIdentificacao();
        txIdentificacao = UtilString.removerCaracteres(txIdentificacao);
        if (!this.isVazio(txIdentificacao)) {
            identificacao.add(this.novoCriterioEQ("identPessoa.id.textoIdentificacao", txIdentificacao.trim()));
        }
        if (!this.isVazio(sigla = decorator.getTextoSiglaNome())) {
            identificacao.add(this.novoCriterioEQ("identPessoa.id.textoIdentificacao", sigla.trim()));
        } else {
            query.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        }
    }

    private void adicionarCriterioConsultarPorIdentificacaoClienteDebito(Criteria query, ConvenentePessoaTODecorator decorator) {
        String identificadorProprio = decorator.getIdentificacaoParaDebito();
        if (!this.isVazio(identificadorProprio)) {
            Criteria pessoa = this.getCriteria(query, "pessoaTO");
            Criteria conta = this.getCriteria(pessoa, "contaCorrenteClienteTOs");
            Criteria debito = this.getCriteria(conta, "identificadorClienteDebitoTOs");
            debito.add(this.novoCriterioEQ("textoIdentificadorDebito", identificadorProprio));
        }
    }

    private void adicionarCriterioConsultarPorEstadoDaIdentificacaoDebito(Criteria query, ConvenentePessoaTODecorator decorator) {
        char situacao = decorator.getTextoSituacaoIdentificador();
        if (!UtilValidadorDeStringsIguais.validar(situacao, UtilPrimitivo.getValorDefaultChar())) {
            Criteria pessoa = this.getCriteria(query, "pessoaTO");
            Criteria conta = this.getCriteria(pessoa, "contaCorrenteClienteTOs");
            Criteria debito = this.getCriteria(conta, "identificadorClienteDebitoTOs");
            Criteria estado = this.getCriteria(debito, "situacaoIdentificadorDebitoTO");
            estado.add(this.novoCriterioEQ("textoSituacaoIdentificador", Character.valueOf(situacao)));
        }
    }

    private void adicionarCriterioConsultarPorConvenioEConvenente(Criteria query, ConvenentePessoaTODecorator decorator) {
        Integer numeroConvenio = decorator.getNumeroConvenio();
        Integer codigoPessoaConvenente = decorator.getConvenenteTO().getCodigoPessoaConvenente();
        Criteria convenente = this.getCriteria(query, "convenenteTO");
        if (codigoPessoaConvenente != null) {
            convenente.add(this.novoCriterioEQ("codigoPessoaConvenente", codigoPessoaConvenente));
        }
        if (numeroConvenio != null && !this.isZero(numeroConvenio)) {
            Criteria convenio = this.getCriteria(convenente, "convenioTOs");
            convenio.add(this.novoCriterioEQ("id.numeroConvenio", numeroConvenio));
        }
    }

    private void adicionarCriterioConsultarPorGrupoClienteRecebimento(Criteria query, GrupoClienteRecebimentoTO grupoClienteRecebimento) {
        if (grupoClienteRecebimento == null || this.isZero(grupoClienteRecebimento.getCodigoGrupoClienteRecebimento())) {
            return;
        }
        Integer codigo = grupoClienteRecebimento.getCodigoGrupoClienteRecebimento();
        Criteria pessoa = this.getCriteria(query, "pessoaTO");
        if (!this.isZero(codigo) && codigo != 9999) {
            UtilRestricaoDAO.adicionaRestricaoPessoaPertenceAoGrupoClienteDebito(codigo, pessoa);
        } else {
            UtilRestricaoDAO.adicionaRestricaoPessoaNaoPerteceAoMembroGrupoClienteRecebimento(pessoa);
        }
    }

    private Criteria getCriterioConsultarPorFiltro(ConvenentePessoaTODecorator decorator) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPorConvenioEConvenente(query, decorator);
        this.adicionarCriterioConsultarPorGrupoClienteRecebimento(query, decorator.getGrupoClienteRecebimentoTO());
        this.adicionarCriterioConsultarPorIdentificacaoEIdentificador(query, decorator);
        this.adicionarCriterioConsultarPorIdentificacaoClienteDebito(query, decorator);
        this.adicionarCriterioConsultarPorEstadoDaIdentificacaoDebito(query, decorator);
        this.adicionarCriterioConsultarPorNome(query, decorator);
        this.adicionarCriterioConsultarPorData(query, decorator);
        return query;
    }

    private void adicionarCriterioConsultarPorData(Criteria query, ConvenentePessoaTODecorator decorator) {
        if (decorator.getDataRemessa() != null) {
            Criteria pessoa = this.getCriteria(query, "pessoaTO");
            Criteria conta = this.getCriteria(pessoa, "contaCorrenteClienteTOs");
            Criteria debito = this.getCriteria(conta, "identificadorClienteDebitoTOs");
            Criteria recebimento = this.getCriteria(debito, "recebimentoDebitoTOs");
            recebimento.add(this.novoCriterioEQ("dataRecebimento", decorator.getDataRemessa()));
        }
    }

    @Override
    public Collection<ConvenentePessoaTO> consultarPorCodigoPessoaRetornandoColecao(Integer codigo) {
        Criteria query = this.novaCriteria();
        if (!this.isZero(codigo)) {
            Criterion pessoaCriterion = this.novoCriterioEQ("pessoaTO.codigoPessoa", codigo);
            Criterion convenenteCriterion = this.novoCriterioEQ("convenenteTO.codigoPessoaConvenente", codigo);
            query.add((Criterion)Restrictions.or((Criterion)pessoaCriterion, (Criterion)convenenteCriterion));
        }
        return query.list();
    }

    @Override
    public boolean isExistePessoaVinculadaConvenente(ConvenentePessoaTO to) {
        Criteria query = this.novaCriteria();
        Criteria pessoa = this.getCriteria(query, "pessoaTO");
        pessoa.add(this.novoCriterioEQ("codigoPessoa", to.getPessoaTO().getCodigoPessoa()));
        Criteria convenente = this.getCriteria(query, "convenenteTO");
        convenente.add(this.novoCriterioEQ("codigoPessoaConvenente", to.getConvenenteTO().getCodigoPessoaConvenente()));
        Criteria servico = this.getCriteria(query, "servicoTO");
        servico.add(this.novoCriterioEQ("textoIdentificadorServico", to.getServicoTO().getTextoIdentificadorServico()));
        return !UtilColecao.isVazio(query.list());
    }

    @Override
    public Collection<ConvenentePessoaTO> consultarPorConvenente(ConvenenteTO convenenteTO, GrupoClienteRecebimentoTO grupoClienteRecebimentoTO, String textoIdentificadorServico) {
        Integer codigoConvenente = convenenteTO.getCodigoPessoaConvenente();
        StringBuilder hql = new StringBuilder();
        Integer codigoGrupo = grupoClienteRecebimentoTO != null ? grupoClienteRecebimentoTO.getCodigoGrupoClienteRecebimento() : null;
        hql.append(" select convPess");
        hql.append(" from ConvenentePessoaTO convPess ");
        if (codigoGrupo != null && codigoGrupo != 9999) {
            hql.append(", MembroGrupoClienteRecebimentoTO membroGrupoClienteRecebimento, GrupoClienteRecebimentoTO grupoClienteRecebimento ");
        }
        hql.append(" join convPess.convenenteTO conv ");
        if (codigoGrupo != null) {
            hql.append(" join convPess.pessoaTO cliente ");
            this.montaWhereCodigoConvenenteTextoIdentificadorServico(codigoConvenente, hql, textoIdentificadorServico);
            if (codigoGrupo != 9999) {
                hql.append(" and membroGrupoClienteRecebimento.id.codigoPessoaCliente = cliente.codigoPessoa  and grupoClienteRecebimento.codigoGrupoClienteRecebimento = membroGrupoClienteRecebimento.id.codigoGrupoClienteRecebimento  ");
                hql.append(" and grupoClienteRecebimento.codigoGrupoClienteRecebimento ='" + codigoGrupo + "'");
            } else {
                hql.append("        and cliente.codigoPessoa not in            (select membroGrupo.id.codigoPessoaCliente            from MembroGrupoClienteRecebimentoTO membroGrupo)");
            }
        } else {
            this.montaWhereCodigoConvenenteTextoIdentificadorServico(codigoConvenente, hql, textoIdentificadorServico);
        }
        hql.append(" order by convPess.pessoaTO.textoNome");
        Query query = this.novaQuery(hql.toString());
        return query.list();
    }

    private void montaWhereCodigoConvenenteTextoIdentificadorServico(Integer codigoConvenente, StringBuilder hql, String textoIdentificadorServico) {
        hql.append(" where conv.codigoPessoaConvenente='" + codigoConvenente + "' and convPess.id.textoIdentificadorServico = '" + textoIdentificadorServico + "'");
    }

    @Override
    public ConvenentePessoaTO consultar(IdentificacaoTO idTO, ConvenenteTO convenenteTO, ServicoTO servicoTO) {
        Criteria query = this.getSession().createCriteria(ConvenentePessoaTO.class, "convenentePessoa").createCriteria("convenentePessoa.pessoaTO", "cliente").createCriteria("convenentePessoa.convenenteTO", "convenente").createCriteria("convenente.convenioTOs", "convenios").createCriteria("convenios.servicoTO", "servico").createCriteria("cliente.identificacaoTOs", "identificacao");
        if (convenenteTO != null) {
            query.add((Criterion)Restrictions.eq((String)"convenentePessoa.convenenteTO.codigoPessoaConvenente", (Object)convenenteTO.getCodigoPessoaConvenente()));
        }
        query.add((Criterion)Restrictions.eq((String)"servico.textoIdentificadorServico", (Object)servicoTO.getTextoIdentificadorServico())).add((Criterion)Restrictions.eq((String)"identificacao.id.textoIdentificador", (Object)idTO.getId().getTextoIdentificador())).add((Criterion)Restrictions.eq((String)"identificacao.id.textoIdentificacao", (Object)idTO.getId().getTextoIdentificacao())).add((Criterion)Restrictions.eq((String)"identificacao.id.codigoTipoDocumento", (Object)idTO.getId().getCodigoTipoDocumento()));
        return (ConvenentePessoaTO)query.uniqueResult();
    }

    @Override
    public Collection<ConvenentePessoaTO> consultarColecaoPorConvenente(Integer codigoConvenente) {
        Criteria query = this.novaCriteria();
        query.add((Criterion)Restrictions.eq((String)"id.codigoPessoaConvenente", (Object)codigoConvenente));
        return query.list();
    }

    @Override
    public void excluirPor(ConvenentePessoaTOId id) {
        String hqlDelete = "delete ConvenentePessoaTO cp where cp.id.codigoPessoaConvenente = :pCodigoPessoaConvenente and  cp.id.textoIdentificadorServico = :ptextoIdentificadorServico ";
        int deletedEntities = this.getSession().createQuery(hqlDelete).setInteger("pCodigoPessoaConvenente", id.getCodigoPessoaConvenente()).setString("ptextoIdentificadorServico", id.getTextoIdentificadorServico()).executeUpdate();
    }
}

