/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.ConvenioDAO;
import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTOId;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PluginTODecoratorAbstrato;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenioTODecorator;
import br.com.politec.generico.calculadores.UtilSomadoresDeNumero;
import br.com.politec.generico.colecao.UtilColecao;
import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvenioDAOImpl
extends HibernateDAO<ConvenioTO, ConvenioTOId>
implements ConvenioDAO {
    @Override
    protected ConvenioTOId getChavePrimaria(ConvenioTO to) {
        return to.getId();
    }

    @Override
    protected Class<ConvenioTO> novoTipoDeObjetoPersistente() {
        return ConvenioTO.class;
    }

    @Override
    public Collection<ConvenioTO> consultarPorConvenenteServicoAtivo(ConvenioTO convenioTO) {
        ConvenioTODecorator decorator = this.novoConvenioTODecorator(convenioTO);
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("convenenteTO.codigoPessoaConvenente", decorator.getCodigoPessoaConvenente()));
        query.add(this.novoCriterioEQ("servicoTO.textoIdentificadorServico", decorator.getTextoIdentificadorServico()));
        query.add(this.novoCriterioEQ("indicadorEstado", "1"));
        return query.list();
    }

    @Override
    public Collection<ConvenioTO> consultarPorConvenenteServico(ConvenioTO convenioTO) {
        ConvenioTODecorator decorator = this.novoConvenioTODecorator(convenioTO);
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("convenenteTO.codigoPessoaConvenente", decorator.getCodigoPessoaConvenente()));
        query.add(this.novoCriterioEQ("servicoTO.textoIdentificadorServico", decorator.getTextoIdentificadorServico()));
        return query.list();
    }

    @Override
    public Collection<ConvenioTO> consultarNaoMigradoPorConvenenteServico(ConvenioTO convenioTO) {
        ConvenioTODecorator decorator = this.novoConvenioTODecorator(convenioTO);
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("convenenteTO.codigoPessoaConvenente", decorator.getCodigoPessoaConvenente()));
        query.add(this.novoCriterioEQ("servicoTO.textoIdentificadorServico", decorator.getTextoIdentificadorServico()));
        Criterion indicadorMigracao = this.novoCriterioNE("indicadorMigracaoDadosNegocio", Character.valueOf('S'));
        Criterion indicadorNULL = Restrictions.isNull((String)"indicadorMigracaoDadosNegocio");
        query.add((Criterion)Restrictions.or((Criterion)indicadorNULL, (Criterion)indicadorMigracao));
        return query.list();
    }

    @Override
    public PaginadorTO consultarPorConvenenteServico(ConvenioTODecorator toDecorado) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("convenenteTO.codigoPessoaConvenente", toDecorado.getCodigoPessoaConvenente()));
        query.add(this.novoCriterioEQ("servicoTO.textoIdentificadorServico", toDecorado.getTextoIdentificadorServico()));
        PaginadorTO paginadorTO = null;
        if (toDecorado.getNomeColunaOrdenada() == null) {
            paginadorTO = this.novoPaginadorTO(query, (PluginTODecoratorAbstrato)toDecorado);
        } else if (toDecorado.getTipoOrdenacao().equals("ASC")) {
            paginadorTO = this.novoPaginadorTOComOrdenacaoASC(query, toDecorado, toDecorado.getNomeColunaOrdenada());
        } else if (toDecorado.getTipoOrdenacao().equals("DESC")) {
            paginadorTO = this.novoPaginadorTOComOrdenacaoDESC(query, toDecorado, toDecorado.getNomeColunaOrdenada());
        }
        return paginadorTO;
    }

    @Override
    public boolean isExisteConvenio(ConvenioTO convenioTO) {
        ConvenioTODecorator decorator = this.novoConvenioTODecorator(convenioTO);
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("convenenteTO.codigoPessoaConvenente", decorator.getCodigoPessoaConvenente()));
        query.add(this.novoCriterioEQ("servicoTO.textoIdentificadorServico", decorator.getTextoIdentificadorServico()));
        query.add(this.novoCriterioEQ("id.numeroConvenio", convenioTO.getId().getNumeroConvenio()));
        return !UtilColecao.isVazio(query.list());
    }

    private ConvenioTODecorator novoConvenioTODecorator(ConvenioTO to) {
        return this.getTOFactory().novoConvenioTODecorator(to);
    }

    @Override
    public ConvenioTO listarPorCodigoPessoaENumeroConvenio(ConvenioTO to) {
        ConvenioTO convenioTO = null;
        Criteria criteria = this.novaCriteria();
        criteria.add(this.novoCriterioEQ("id.numeroConvenio", to.getId().getNumeroConvenio()));
        criteria.add(this.novoCriterioEQ("convenenteTO.codigoPessoaConvenente", to.getConvenenteTO().getCodigoPessoaConvenente()));
        List resultado = criteria.list();
        if (this.isReferencia(resultado)) {
            convenioTO = (ConvenioTO)resultado.get(0);
        }
        return convenioTO;
    }

    @Override
    public void alterarPorCodigoPessoaENumeroConvenio(ConvenioTO to) {
        Query query = this.novaQuery("UPDATE ConvenioTO to SET to.textoDescricaoConvenio = :descricao WHERE to.id.numeroConvenio = :numeroConvenio AND to.convenenteTO.codigoPessoaConvenente = :codigoPessoa AND to.servicoTO.textoIdentificadorServico = :textoIdentificadorServico");
        query.setString("descricao", to.getTextoDescricaoConvenio());
        query.setString("textoIdentificadorServico", to.getServicoTO().getTextoIdentificadorServico());
        query.setInteger("numeroConvenio", to.getId().getNumeroConvenio().intValue());
        query.setInteger("codigoPessoa", to.getConvenenteTO().getCodigoPessoaConvenente().intValue());
        query.executeUpdate();
    }

    @Override
    public void excluirPorCodigoPessoaENumeroConvenio(ConvenioTO to) {
        Query query = this.novaQuery("DELETE FROM ConvenioTO to  WHERE to.id.numeroConvenio = :numeroConvenio AND to.id.codigoPessoaConvenente = :codigoPessoa AND to.servicoTO.textoIdentificadorServico = :textoIdentificadorServico");
        query.setInteger("numeroConvenio", to.getId().getNumeroConvenio().intValue());
        query.setInteger("codigoPessoa", to.getConvenenteTO().getCodigoPessoaConvenente().intValue());
        query.setString("textoIdentificadorServico", to.getServicoTO().getTextoIdentificadorServico());
        query.executeUpdate();
    }

    @Override
    public boolean isExisteConvenioDeNumero(ConvenioTO to) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("numeroConvenio", to.getId().getNumeroConvenio()));
        return !UtilColecao.isVazio(query.list());
    }

    @Override
    protected void incrementarChaveComposta(ConvenioTOId chave) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("id.codigoPessoaConvenente", chave.getCodigoPessoaConvenente()));
        query.add(this.novoCriterioEQ("id.textoIdentificadorServico", chave.getTextoIdentificadorServico()));
        query.setProjection((Projection)Projections.max((String)"id.numeroConvenio"));
        List colecao = query.list();
        Integer max = (Integer)UtilColecao.getElementoDoIndice((Collection)colecao, 0);
        max = UtilSomadoresDeNumero.somar(max, 1);
        chave.setNumeroConvenio(max);
    }

    @Override
    public ConvenioTO incluirOuAlterar(ConvenioTO object) {
        if (object.getId().getNumeroConvenio() == null) {
            this.validarChaveComposta(object);
        }
        return super.incluirOuAlterar(object);
    }

    @Override
    public ConvenioTO consultarPorConvenioServico(ConvenioTODecorator convenioTODecorator) {
        ConvenioTO convenioTO = null;
        Criteria criteria = this.novaCriteria();
        criteria.add(this.novoCriterioEQ("id.numeroConvenio", convenioTODecorator.getNumeroConvenio()));
        criteria.add(this.novoCriterioEQ("id.textoIdentificadorServico", convenioTODecorator.getTextoIdentificadorServico()));
        List resultado = criteria.list();
        if (this.isReferencia(resultado) && resultado.size() > 0) {
            convenioTO = (ConvenioTO)resultado.get(0);
        }
        return convenioTO;
    }

    @Override
    public void excluirPorConvenenteEServico(int codigoPessoaConvenente, String textoIdentificadorServico) {
        String hql = "delete from ConvenioTO  where id.codigoPessoaConvenente = :codigoPessoaConvenente and  id.textoIdentificadorServico = :textoIdentificadorServico";
        Query queryConvenente = this.novaQuery(hql);
        queryConvenente.setInteger("codigoPessoaConvenente", codigoPessoaConvenente);
        queryConvenente.setString("textoIdentificadorServico", textoIdentificadorServico);
        queryConvenente.executeUpdate();
    }

    @Override
    public ConvenioTO consultarPorContaCorrenteCliente(ContaCorrenteClienteTO contaCorrenteCliente) {
        Criteria queryConvenio = this.novaCriteria();
        Criteria queryCorrenteCliente = this.getCriteria(queryConvenio, "contaCorrenteClienteTO");
        queryCorrenteCliente.add(this.novoCriterioEQ("id", contaCorrenteCliente.getId()));
        if (this.isReferencia(queryCorrenteCliente) && queryCorrenteCliente.list().size() > 0) {
            return (ConvenioTO)queryCorrenteCliente.list().get(0);
        }
        return null;
    }
}

