/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.DAO;
import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.politec.generico.fabrica.DataFactory;
import br.com.politec.generico.fabrica.NumeroFactory;
import br.com.politec.reflexao.UtilReflexaoFabrica;
import br.com.politec.reflexao.exception.ReflexaoException;
import junit.framework.TestCase;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class DAOTestAbstrato
extends TestCase {
    protected static SessionFactory sessionFactory;

    protected void setUp() throws Exception {
        SessionFactory sf = DAOTestAbstrato.getSessionFactory();
        Session sessao = DAOTestAbstrato.getSessionFactory().openSession();
        SessionHolder sh = this.novoSessionHolder((org.hibernate.Session)sessao);
        TransactionSynchronizationManager.bindResource((Object)sf, (Object)sh);
    }

    protected void tearDown() throws Exception {
        SessionFactory sf = DAOTestAbstrato.getSessionFactory();
        SessionHolder sh = this.getSessionHolder();
        org.hibernate.Session sessao = sh.getSession();
        sessao.flush();
        TransactionSynchronizationManager.unbindResource((Object)sf);
        SessionFactoryUtils.releaseSession((org.hibernate.Session)sessao, (SessionFactory)sf);
    }

    protected void finalize() throws Throwable {
        DAOTestAbstrato.getSessionFactory().close();
        sessionFactory = null;
        super.finalize();
    }

    protected DAO novaDAO(Class classe) {
        HibernateDAO dao = null;
        try {
            dao = (HibernateDAO)UtilReflexaoFabrica.novoObjeto(classe);
            dao.setSessionFactory(DAOTestAbstrato.getSessionFactory());
        }
        catch (ReflexaoException e) {
            DAOTestAbstrato.assertNull((Object)e);
        }
        return dao;
    }

    protected Integer novoInteger(int valor) {
        return this.getNumeroFactory().novoInteger(valor);
    }

    protected NumeroFactory getNumeroFactory() {
        return NumeroFactory.getInstance();
    }

    protected DataFactory getDataFactory() {
        return DataFactory.getInstance();
    }

    protected static SessionFactory getSessionFactory() {
        if (sessionFactory == null) {
            sessionFactory = DAOTestAbstrato.novoSessionFactory();
        }
        return sessionFactory;
    }

    protected SessionHolder getSessionHolder() {
        SessionFactory sf = DAOTestAbstrato.getSessionFactory();
        return (SessionHolder)TransactionSynchronizationManager.getResource((Object)sf);
    }

    protected SessionHolder novoSessionHolder(org.hibernate.Session sessao) {
        return new SessionHolder(sessao);
    }

    protected static SessionFactory novoSessionFactory() {
        AnnotationConfiguration annotationCfg = new AnnotationConfiguration();
        Configuration cfg = annotationCfg.configure();
        return cfg.buildSessionFactory();
    }
}

