/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.GrupoUsuarioDAO;
import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.negocio.to.GrupoUsuarioTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PluginTODecoratorAbstrato;
import br.com.bb.plugins.gac.negocio.to.decorator.GrupoUsuarioTODecorator;
import br.com.politec.generico.colecao.UtilColecao;
import java.util.Collection;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrupoUsuarioDAOImpl
extends HibernateDAO<GrupoUsuarioTO, Integer>
implements GrupoUsuarioDAO {
    @Override
    protected Class<GrupoUsuarioTO> novoTipoDeObjetoPersistente() {
        return GrupoUsuarioTO.class;
    }

    @Override
    public Collection<GrupoUsuarioTO> consultarPorNome(String nome) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("estadoGrupoUsuarioTO.codigoEstadoGrupoUsuario", 1));
        query.add(this.novoCriterioLike("nomeGrupoUsuario", nome));
        return query.list();
    }

    @Override
    public Collection<GrupoUsuarioTO> consultarOrdenado() {
        Criteria query = this.novaCriteria();
        query.addOrder(Order.asc((String)"nomeGrupoUsuario"));
        return query.list();
    }

    @Override
    protected Integer getChavePrimaria(GrupoUsuarioTO to) {
        return to.getNumeroIdentificadorGrupoUsuario();
    }

    @Override
    public PaginadorTO consultar(GrupoUsuarioTODecorator grupoUsuarioTODecorator) {
        Criteria query = this.novaCriteria();
        return this.novoPaginadorTO(query, (PluginTODecoratorAbstrato)grupoUsuarioTODecorator);
    }

    @Override
    public boolean isExisteRegistro(GrupoUsuarioTO to) {
        Integer numero = to.getNumeroIdentificadorGrupoUsuario();
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("numeroIdentificadorGrupoUsuario", numero));
        return !UtilColecao.isVazio(query.list());
    }

    @Override
    public boolean isExisteRegistro(GrupoUsuarioTODecorator decorator) {
        return this.isExisteRegistro(decorator.getGrupoUsuarioTO());
    }

    @Override
    public boolean isExisteNome(GrupoUsuarioTODecorator to) {
        String nome = to.getGrupoUsuarioTO().getNomeGrupoUsuario();
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("estadoGrupoUsuarioTO.codigoEstadoGrupoUsuario", 1));
        query.add(this.novoCriterioEQIgnoreCase("nomeGrupoUsuario", nome));
        if (to.getGrupoUsuarioTO().getNumeroIdentificadorGrupoUsuario() != null) {
            query.add(this.novoCriterioNE("numeroIdentificadorGrupoUsuario", to.getGrupoUsuarioTO().getNumeroIdentificadorGrupoUsuario()));
        }
        query.list();
        return !UtilColecao.isVazio(query.list());
    }
}

