/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.integracao.dao.LeiauteDAO;
import br.com.bb.plugins.gac.negocio.to.CamposLeiauteTO;
import br.com.bb.plugins.gac.negocio.to.LeiauteTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PluginTODecoratorAbstrato;
import br.com.bb.plugins.gac.negocio.to.decorator.LeiauteTODecorator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeiauteDAOImpl
extends HibernateDAO<LeiauteTO, Integer>
implements LeiauteDAO {
    @Override
    public List<LeiauteTO> getNomeLeiauteIgual(LeiauteTODecorator decorator) {
        String sql = "select leiauteTO from LeiauteTO leiauteTO    inner join leiauteTO.servicoTO as servicoTO    inner join leiauteTO.tipoLeiauteTO as tipoLeiauteTO  where servicoTO.textoIdentificadorServico = ?  and   tipoLeiauteTO.id.textoTipoOperacao  = ?  and   leiauteTO.textoDescricaoLeiaute     = ?  order by leiauteTO.textoDescricaoLeiaute ";
        Query query = this.novaQuery(sql);
        query.setParameter(0, (Object)decorator.getTextoIdentificadorServico());
        query.setParameter(1, (Object)decorator.getTextoTipoOperacao());
        query.setParameter(2, (Object)decorator.getTextoDescricaoLeiaute());
        return query.list();
    }

    @Override
    public void excluir(LeiauteTO leiauteTO) {
        String sql = "";
        Integer numeroLeiaute = leiauteTO.getNumeroLeiaute();
        String numerosCampoLeiaute = "";
        for (CamposLeiauteTO to : leiauteTO.getCamposLeiauteTOs()) {
            numerosCampoLeiaute = String.valueOf(numerosCampoLeiaute) + "'" + to.getId().getNumeroCampoLeiaute() + "',";
        }
        if (numerosCampoLeiaute.compareTo("") != 0) {
            numerosCampoLeiaute = numerosCampoLeiaute.substring(0, numerosCampoLeiaute.length() - 1);
            sql = String.valueOf(sql) + " delete ";
            sql = String.valueOf(sql) + " from  CamposLeiauteTO  campo ";
            sql = String.valueOf(sql) + " where campo.id.numeroCampoLeiaute in ( " + numerosCampoLeiaute + ")";
            sql = String.valueOf(sql) + "   and campo.id.numeroLeiaute =  '" + numeroLeiaute.toString() + "'";
            Query query = this.novaQuery(sql);
            query.executeUpdate();
            this.getSession().flush();
        }
        sql = "";
        sql = String.valueOf(sql) + " delete                   ";
        sql = String.valueOf(sql) + " from LeiauteTO  leiaute  ";
        sql = String.valueOf(sql) + " where numeroLeiaute  =   " + numeroLeiaute.toString();
        Query query2 = this.novaQuery(sql);
        query2.executeUpdate();
        this.getSession().flush();
    }

    @Override
    protected Class<LeiauteTO> novoTipoDeObjetoPersistente() {
        return LeiauteTO.class;
    }

    @Override
    protected Integer getChavePrimaria(LeiauteTO to) {
        return to.getNumeroLeiaute();
    }

    @Override
    public PaginadorTO consultarPorTipoServicoSemTemplate(LeiauteTODecorator decorator) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPorServico(query, decorator);
        Integer tipo = decorator.getCodigoTipoLeiaute();
        String operacao = decorator.getTextoTipoOperacao();
        Criteria criteriaTipoLeiauteTO = query.createCriteria("tipoLeiauteTO", "tipoLeiauteTO");
        if (this.isReferencia(tipo)) {
            criteriaTipoLeiauteTO.add(this.novoCriterioEQ("id.codigoTipoLeiaute", tipo));
        }
        if (this.isReferencia(operacao)) {
            criteriaTipoLeiauteTO.add(this.novoCriterioEQ("id.textoTipoOperacao", operacao));
        }
        query.add(Restrictions.isNull((String)"indicadorLeiauteModelo"));
        return this.novoPaginadorTO(query, (PluginTODecoratorAbstrato)decorator);
    }

    @Override
    public PaginadorTO consultarTodosSemTemplates(LeiauteTODecorator decorator) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioGAC(query);
        query.add(Restrictions.isNull((String)"indicadorLeiauteModelo"));
        this.aplicarOrdenacao(query, (PluginTODecoratorAbstrato)decorator);
        return this.novoPaginadorTO(query, (PluginTODecoratorAbstrato)decorator);
    }

    @Override
    public PaginadorTO consultarTodos(LeiauteTODecorator decorator) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioGAC(query);
        return this.novoPaginadorTO(query, (PluginTODecoratorAbstrato)decorator);
    }

    @Override
    public Collection<LeiauteTO> consultarPeloServico(LeiauteTO to) {
        LeiauteTODecorator decorator = this.novoLeiauteTODecorator(to);
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPorServico(query, decorator);
        return query.list();
    }

    @Override
    public Collection<LeiauteTO> consultarPeloServicoEModelo(LeiauteTO to) {
        LeiauteTODecorator decorator = this.novoLeiauteTODecorator(to);
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPorServico(query, decorator);
        this.adicionarCriterioConsultarPorModelo(query, decorator);
        return query.list();
    }

    private void adicionarCriterioConsultarPorServico(Criteria query, LeiauteTODecorator decorator) {
        String servico = decorator.getTextoIdentificadorServico();
        if (!this.isVazio(servico)) {
            query.add(this.getCriterioConsultarPorServico(decorator));
        }
    }

    @Override
    public void adicionarCriterioGAC(Criteria query) {
        query.add(this.novoCriterioEQ("servicoTO.textoIdentificadorServico", "GAC"));
    }

    private void adicionarCriterioConsultarPorModelo(Criteria query, LeiauteTODecorator decorator) {
        Character modelo = decorator.getIndicadorLeiauteModelo();
        if (this.isReferencia(modelo)) {
            query.add(this.getCriterioConsultarPorModelo(decorator));
        }
    }

    private Criterion getCriterioConsultarPorServico(LeiauteTODecorator decorator) {
        String servico = decorator.getTextoIdentificadorServico();
        return this.novoCriterioEQ("servicoTO.textoIdentificadorServico", servico);
    }

    private Criterion getCriterioConsultarPorModelo(LeiauteTODecorator decorator) {
        Character modelo = decorator.getIndicadorLeiauteModelo();
        return this.novoCriterioEQ("indicadorLeiauteModelo", modelo);
    }

    private LeiauteTODecorator novoLeiauteTODecorator(LeiauteTO to) {
        return this.getTOFactory().novoLeiauteTODecorator(to);
    }

    @Override
    public LeiauteTO consultarIncluirIMP(String servico, int codigoTipoLeiaute, int numeroLeiaute) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("servicoTO.textoIdentificadorServico", servico));
        query.add(this.novoCriterioEQ("indicadorLeiauteModelo", "1"));
        query.add(this.novoCriterioEQ("tipoLeiauteTO.id.codigoTipoLeiaute", codigoTipoLeiaute));
        query.add(this.novoCriterioEQ("numeroLeiaute", numeroLeiaute));
        return (LeiauteTO)query.list().get(0);
    }

    @Override
    public LeiauteTO consultarIncluirEXP(String servico, int codigoTipoLeiaute, int numeroLeiaute) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("servicoTO.textoIdentificadorServico", servico));
        query.add(this.novoCriterioEQ("indicadorLeiauteModelo", "1"));
        query.add(this.novoCriterioEQ("tipoLeiauteTO.id.codigoTipoLeiaute", codigoTipoLeiaute));
        query.add(this.novoCriterioEQ("numeroLeiaute", numeroLeiaute));
        return (LeiauteTO)query.list().get(0);
    }

    @Override
    public Collection<LeiauteTO> consultarPeloServicoETipo(LeiauteTO to) {
        LeiauteTODecorator decorator = this.novoLeiauteTODecorator(to);
        String sql = "select leiauteTO from LeiauteTO leiauteTO  inner join leiauteTO.servicoTO as servicoTO  inner join leiauteTO.tipoLeiauteTO as tipoLeiauteTO  where servicoTO.textoIdentificadorServico=?  and   tipoLeiauteTO.id.textoTipoOperacao= ?  order by leiauteTO.textoDescricaoLeiaute ";
        Query query = this.novaQuery(sql);
        query.setParameter(0, (Object)decorator.getTextoIdentificadorServico());
        query.setParameter(1, (Object)decorator.getTextoTipoOperacao());
        return query.list();
    }

    @Override
    public boolean isNomeLeiauteIgual(LeiauteTODecorator decorator) {
        String sql = "select leiauteTO from LeiauteTO leiauteTO    inner join leiauteTO.servicoTO as servicoTO    inner join leiauteTO.tipoLeiauteTO as tipoLeiauteTO  where servicoTO.textoIdentificadorServico = ?  and   tipoLeiauteTO.id.textoTipoOperacao  = ?  and   leiauteTO.textoDescricaoLeiaute     = ?  order by leiauteTO.textoDescricaoLeiaute ";
        Query query = this.novaQuery(sql);
        query.setParameter(0, (Object)decorator.getTextoIdentificadorServico());
        query.setParameter(1, (Object)decorator.getTextoTipoOperacao());
        query.setParameter(2, (Object)decorator.getTextoDescricaoLeiaute());
        ArrayList lista = (ArrayList)query.list();
        return lista.size() > 0;
    }
}

