/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.integracao.dao.PermissaoUsuarioDAO;
import br.com.bb.plugins.gac.negocio.to.PermissaoUsuarioTO;
import br.com.bb.plugins.gac.negocio.to.PermissaoUsuarioTOId;
import br.com.bb.plugins.gac.negocio.to.UsuarioTO;
import br.com.bb.plugins.gac.negocio.to.decorator.PermissaoUsuarioTODecorator;
import br.com.politec.generico.colecao.UtilColecao;
import java.util.Collection;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissaoUsuarioDAOImpl
extends HibernateDAO<PermissaoUsuarioTO, PermissaoUsuarioTOId>
implements PermissaoUsuarioDAO {
    @Override
    protected Class<PermissaoUsuarioTO> novoTipoDeObjetoPersistente() {
        return PermissaoUsuarioTO.class;
    }

    @Override
    protected PermissaoUsuarioTOId getChavePrimaria(PermissaoUsuarioTO to) {
        return to.getId();
    }

    @Override
    public boolean isExistePermissaoParaUsuario(PermissaoUsuarioTO to) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioPorNumeroIdentificadorUsuario(query, to);
        this.adicionarCriterioPorServico(query, to);
        this.adicionarCriterioPorOpcaoDeMenu(query, to);
        this.adicionarCriterioPorCodigoDeTransacao(query, to);
        return !UtilColecao.isVazio(query.list());
    }

    @Override
    public Collection<PermissaoUsuarioTO> consultarPeloServicoEMenu(PermissaoUsuarioTO to) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioPorServico(query, to);
        this.adicionarCriterioPorOpcaoDeMenu(query, to);
        return query.list();
    }

    private void adicionarCriterioPorServico(Criteria query, PermissaoUsuarioTO to) {
        PermissaoUsuarioTODecorator d = this.novoPermissaoUsuarioTODecorator(to);
        String servico = d.getTextoIdentificadorServico();
        query.add(this.novoCriterioEQ("id.textoIdentificadorServico", servico));
    }

    private void adicionarCriterioPorOpcaoDeMenu(Criteria query, PermissaoUsuarioTO to) {
        PermissaoUsuarioTODecorator d = this.novoPermissaoUsuarioTODecorator(to);
        String menu = d.getTextoCodigoOpcaoMenu();
        query.add(this.novoCriterioEQ("id.textoCodigoOpcaoMenu", menu));
    }

    private void adicionarCriterioPorCodigoDeTransacao(Criteria query, PermissaoUsuarioTO to) {
        PermissaoUsuarioTODecorator d = this.novoPermissaoUsuarioTODecorator(to);
        String transacao = d.getTextoCodigoTransacao();
        query.add(this.novoCriterioEQ("id.textoCodigoTransacao", transacao));
    }

    private void adicionarCriterioPorNumeroIdentificadorUsuario(Criteria query, PermissaoUsuarioTO to) {
        PermissaoUsuarioTODecorator d = this.novoPermissaoUsuarioTODecorator(to);
        Integer usuario = d.getNumeroIdentificadorUsuario();
        query.add(this.novoCriterioEQ("id.numeroIdentificadorUsuario", usuario));
    }

    private PermissaoUsuarioTODecorator novoPermissaoUsuarioTODecorator(PermissaoUsuarioTO to) {
        return this.getTOFactory().novoPermissaoUsuarioTODecorator(to);
    }

    @Override
    public void exluirPorIdentificadorDoUsuario(UsuarioTO to) {
        Query query = this.novaQuery("delete from PermissaoUsuarioTO permissaoUsuario where permissaoUsuario.id.numeroIdentificadorUsuario = " + to.getNumeroIdentificadorUsuario());
        query.executeUpdate();
        this.getSession().flush();
    }

    @Override
    public Collection<PermissaoUsuarioTO> consultarPorUsuario(UsuarioTO to) {
        Criteria criteria = this.novaCriteria();
        Criterion criterion = this.novoCriterioEQ("id.numeroIdentificadorUsuario", to.getNumeroIdentificadorUsuario());
        criteria.add(criterion);
        return criteria.list();
    }

    @Override
    protected void incrementarChaveComposta(PermissaoUsuarioTO chave) {
    }
}

