/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.integracao.dao.RemessaDAO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PluginTODecoratorAbstrato;
import br.com.bb.plugins.gac.negocio.to.RemessaTO;
import br.com.bb.plugins.gac.negocio.to.RemessaTOId;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.TipoSegmentoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.RemessaTODecorator;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.fabrica.ColecaoFactory;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemessaDAOImpl
extends HibernateDAO<RemessaTO, RemessaTOId>
implements RemessaDAO {
    @Override
    protected Class<RemessaTO> novoTipoDeObjetoPersistente() {
        return RemessaTO.class;
    }

    @Override
    protected RemessaTOId getChavePrimaria(RemessaTO to) {
        return to.getId();
    }

    @Override
    public Collection<RemessaTO> consultarPelaRemessaConvenioEServico(RemessaTODecorator decorator) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPorCodigo(query, decorator);
        this.adicionarCriterioConsultarPorConvenio(query, decorator);
        this.adicionarCriterioConsultarPorServico(query, decorator);
        return query.list();
    }

    @Override
    public PaginadorTO consultarValores(RemessaTODecorator decorator) {
        Criteria query = this.novaCriteria();
        ProjectionList projList = Projections.projectionList();
        projList.add((Projection)Projections.groupProperty((String)"id.numeroConvenio"));
        projList.add((Projection)Projections.groupProperty((String)"id.textoIdentificadorServico"));
        projList.add((Projection)Projections.groupProperty((String)"valorRemessa"));
        projList.add((Projection)Projections.count((String)"id.numeroConvenio"), "quantidadeConvenio");
        projList.add((Projection)Projections.sum((String)"valorRemessa"), "somaRemessa");
        query.setProjection((Projection)projList);
        this.adicionarCriterioConsultarPorSituacaoDoRecebimento(query, decorator);
        this.adicionarCriterioConsultarPorTipoDeSegmento(query, decorator);
        this.adicionarCriterioConsultarPorServicoIn(query, decorator);
        this.aplicarOrdenacao(query, (PluginTODecoratorAbstrato)decorator);
        List resultado = query.list();
        Collection<RemessaTODecorator> c = this.getTOFactory().novaColecaoRemessaTODecorator(resultado);
        return this.novoPaginadorTO(c, (PluginTODecoratorAbstrato)decorator);
    }

    @Override
    public PaginadorTO montarPaginador(List<RemessaTODecorator> listaBO, RemessaTODecorator decorator) {
        return this.novoPaginadorTO(listaBO, (PluginTODecoratorAbstrato)decorator);
    }

    @Override
    public boolean isExistePorDataDeRemessa(RemessaTO to) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPorDataDeRemessa(query, to);
        return !UtilColecao.isVazio(query.list());
    }

    private void adicionarCriterioConsultarPorDataDeRemessa(Criteria query, RemessaTO to) {
        Date data = to.getId().getDataRemessa();
        if (!this.isReferencia(data)) {
            query.add(this.novoCriterioEQ("id.dataRemessa", data));
        }
    }

    private void adicionarCriterioConsultarPorTipoDeSegmento(Criteria query, RemessaTODecorator decorator) {
        Collection<TipoSegmentoTO> s = decorator.getColecaoDeTipoSegmento();
        if (!UtilColecao.isVazio(s)) {
            Criteria servicoTO = query.createCriteria("servicoTO");
            Criteria tipoSegmentoTO = servicoTO.createCriteria("tipoSegmentoTO");
            tipoSegmentoTO.add(this.novoCriterioIN("codigoTipoSegmento", s, "codigoTipoSegmento"));
        }
    }

    private void adicionarCriterioConsultarPorServicoIn(Criteria query, RemessaTODecorator decorator) {
        Collection<ServicoTO> s = decorator.getColecaoDeServico();
        if (!UtilColecao.isVazio(s)) {
            query.add(this.novoCriterioIN("id.textoIdentificadorServico", s, "textoIdentificadorServico"));
        }
    }

    private void adicionarCriterioConsultarPorSituacaoDoRecebimento(Criteria query, RemessaTODecorator decorator) {
        String situacao = decorator.getCodigoSituacaoRecebimento();
        if (!this.isVazio(situacao)) {
            Criteria recebimentoDebitoTO = query.createCriteria("recebimentoDebitoTOs");
            recebimentoDebitoTO.add(this.novoCriterioEQ("situacaoRecebimentoTO.codigoSituacaoRecebimento", situacao));
        }
    }

    protected ColecaoFactory getColecaoFactory() {
        return ColecaoFactory.getInstance();
    }

    private void adicionarCriterioConsultarPorServico(Criteria query, RemessaTODecorator decorator) {
        String texto = decorator.getTextoIdentificadorServico();
        if (!this.isVazio(texto)) {
            query.add(this.novoCriterioEQ("id.textoIdentificadorServico", texto));
        }
    }

    private void adicionarCriterioConsultarPorConvenio(Criteria query, RemessaTODecorator decorator) {
        Integer codigo = decorator.getNumeroConvenio();
        if (!this.isZero(codigo)) {
            query.add(this.novoCriterioEQ("id.numeroConvenio", codigo));
        }
    }

    private void adicionarCriterioConsultarPorCodigo(Criteria query, RemessaTODecorator decorator) {
        Integer codigo = decorator.getNumeroRemessa();
        if (!this.isZero(codigo)) {
            query.add(this.novoCriterioEQ("id.numeroRemessa", codigo));
        }
    }

    @Override
    public boolean isExisteRemessa(RemessaTO to) {
        Criteria criteria = this.novaCriteria();
        criteria.add(this.novoCriterioEQ("id.numeroRemessa", to.getId().getNumeroRemessa()));
        criteria.add(this.novoCriterioEQ("id.numeroConvenio", to.getId().getNumeroConvenio()));
        criteria.add(this.novoCriterioEQ("id.codigoPessoaConvenente", to.getId().getCodigoPessoaConvenente()));
        criteria.add(this.novoCriterioEQ("id.textoIdentificadorServico", to.getId().getTextoIdentificadorServico()));
        List list = criteria.list();
        boolean resultado = false;
        if (list.size() > 0) {
            resultado = true;
        }
        return resultado;
    }

    @Override
    public boolean isExisteRemessaVinculadaConvenio(RemessaTO to) {
        Criteria criteria = this.novaCriteria();
        criteria.add(this.novoCriterioEQ("convenioTO.id.numeroConvenio", to.getConvenioTO().getId().getNumeroConvenio()));
        criteria.add(this.novoCriterioEQ("convenioTO.id.codigoPessoaConvenente", to.getConvenioTO().getId().getCodigoPessoaConvenente()));
        criteria.add(this.novoCriterioEQ("convenioTO.id.textoIdentificadorServico", to.getConvenioTO().getId().getTextoIdentificadorServico()));
        List list = criteria.list();
        boolean resultado = false;
        if (list.size() > 0) {
            resultado = true;
        }
        return resultado;
    }

    @Override
    protected void incrementarChaveComposta(RemessaTOId chave) {
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public Integer consultarMaiorRemessa(ConvenioTO convTO) {
        this.flushSession();
        Criteria criteria = this.novaCriteria();
        criteria.add(this.novoCriterioEQ("id.numeroConvenio", convTO.getId().getNumeroConvenio()));
        criteria.add(this.novoCriterioEQ("id.codigoPessoaConvenente", convTO.getId().getCodigoPessoaConvenente()));
        criteria.add(this.novoCriterioEQ("id.textoIdentificadorServico", convTO.getId().getTextoIdentificadorServico()));
        criteria.setProjection((Projection)Projections.max((String)"id.numeroRemessa"));
        List colecao = criteria.list();
        return (Integer)UtilColecao.getElementoDoIndice((Collection)colecao, 0);
    }

    @Override
    public Collection<RemessaTO> listarRecuperarRemessa(RemessaTO to) {
        Criteria criteria = this.novaCriteria();
        criteria.add(this.novoCriterioEQ("id.numeroConvenio", to.getId().getNumeroConvenio()));
        criteria.add(this.novoCriterioEQ("id.codigoPessoaConvenente", to.getId().getCodigoPessoaConvenente()));
        criteria.add(this.novoCriterioEQ("id.textoIdentificadorServico", to.getId().getTextoIdentificadorServico()));
        criteria.add(this.novoCriterioEQ("id.dataRemessa", to.getId().getDataRemessa()));
        return criteria.list();
    }

    @Override
    public Collection<RemessaTO> listarRecuperarRemessaPorCodigoRemessa(RemessaTO to) {
        Criteria criteria = this.novaCriteria();
        criteria.add(this.novoCriterioEQ("id.numeroRemessa", to.getId().getNumeroRemessa()));
        criteria.add(this.novoCriterioEQ("id.numeroConvenio", to.getId().getNumeroConvenio()));
        criteria.add(this.novoCriterioEQ("id.codigoPessoaConvenente", to.getId().getCodigoPessoaConvenente()));
        criteria.add(this.novoCriterioEQ("id.textoIdentificadorServico", to.getId().getTextoIdentificadorServico()));
        criteria.add(this.novoCriterioEQ("id.dataRemessa", to.getId().getDataRemessa()));
        return criteria.list();
    }
}

