/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao;

import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.negocio.to.MembroGrupoClienteRecebimentoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenentePessoaTODecorator;
import br.com.bb.plugins.gac.util.UtilIdentificadorProprio;
import br.com.bb.plugins.gac.util.dominio.UtilDominioTipoDocumento;
import br.com.politec.generico.objeto.UtilPrimitivo;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

public class UtilRestricaoDAO {
    private UtilRestricaoDAO() {
    }

    public static void adicionaRestricaoPessoaPertenceAoGrupoClienteDebito(Integer codigo, Criteria pessoa) {
        DetachedCriteria pessoaPerteceMembroGrupoRecebimento = DetachedCriteria.forClass(MembroGrupoClienteRecebimentoTO.class, (String)"membroGrupoRecebimentoTO").setProjection((Projection)Property.forName((String)"pessoaTO.codigoPessoa")).createAlias("pessoaTO", "pessoaMembroGrupoRecebimentoTO").add((Criterion)Restrictions.and((Criterion)Property.forName((String)"pessoaMembroGrupoRecebimentoTO.codigoPessoa").eqProperty("pessoaTO.codigoPessoa"), (Criterion)Property.forName((String)"membroGrupoRecebimentoTO.id.codigoGrupoClienteRecebimento").eq((Object)codigo)));
        pessoa.add(Property.forName((String)"pessoaTO.codigoPessoa").eq(pessoaPerteceMembroGrupoRecebimento));
    }

    public static void adicionaRestricaoPessoaNaoPerteceAoMembroGrupoClienteRecebimento(Criteria pessoa) {
        DetachedCriteria pessoaNaoPerteceMembroGrupoRecebimento = DetachedCriteria.forClass(MembroGrupoClienteRecebimentoTO.class, (String)"membroGrupoRecebimentoTO").setProjection((Projection)Property.forName((String)"pessoaTO.codigoPessoa"));
        pessoa.add(Property.forName((String)"pessoaTO.codigoPessoa").notIn(pessoaNaoPerteceMembroGrupoRecebimento));
    }

    public static Query adicionaFiltroConvenentePessoa(ConvenentePessoaTODecorator to, boolean ordenar, StringBuilder hql, HibernateDAO daoImpl) {
        return UtilRestricaoDAO.montaFiltroConvenentePessoa(to, ordenar, hql, daoImpl);
    }

    private static String hqlConvPessoa() {
        return "select convPessoaTO.id.codigoPessoa             from ConvenentePessoaTO convPessoaTO             where convPessoaTO.id.codigoPessoaConvenente = ?             and convPessoaTO.id.textoIdentificadorServico = ? ";
    }

    public static Query montaFiltroConvenentePessoa(ConvenentePessoaTODecorator to, boolean ordenar, StringBuilder hql, HibernateDAO daoImpl) {
        boolean filtroConvenio = false;
        boolean filtroGrupo = false;
        boolean filtroInscricao = false;
        boolean filtroNome = false;
        boolean filtroSitAutorizacao = false;
        boolean filtroIdentProprio = false;
        boolean filtroIndicadoDeImpressao = false;
        boolean filtroIdentificacaoDeDebito = false;
        int codigoTipoDocumentoIdentificadorProprioConvenenteServico = UtilIdentificadorProprio.getInstancia().getCodigoTipoDocumento();
        String textoIdentitificadorProprioConvenenteServico = UtilIdentificadorProprio.getInstancia().getTextoIdentificador();
        boolean existeIdentificadorProprio = UtilIdentificadorProprio.getInstancia().existeIdenfificador();
        hql.append("(");
        hql.append(UtilRestricaoDAO.hqlConvPessoa());
        hql.append(")");
        if (to.getNumeroConvenio() != null) {
            daoImpl.montaHQLFiltroConvenio(hql);
            filtroConvenio = true;
        }
        if (to.getCodigoGrupoClienteRecebimento() != null && to.getCodigoGrupoClienteRecebimento() != 9999) {
            daoImpl.montaHQLFiltroGrupoClienteRecebimento(hql);
            filtroGrupo = true;
        }
        if (to.getCodigoGrupoClienteRecebimento() != null && to.getCodigoGrupoClienteRecebimento() == 9999) {
            daoImpl.montaHQLFiltroSemGrupoClienteRecebimento(hql);
        }
        if (to.getCodigoTipoPessoa() != null && (to.getCodigoTipoPessoa().intValue() == UtilDominioTipoDocumento.CPF_PF.intValue() || to.getCodigoTipoPessoa().intValue() == UtilDominioTipoDocumento.CNPJ_PJ.intValue())) {
            hql.append("        and (select objIdentificacaoTO.textoIdentificacao          from objPessoaTO.identificacaoTOs objIdentificacaoTO          where objIdentificacaoTO.pessoaTO.codigoPessoa=objPessoaTO.codigoPessoa                and objIdentificacaoTO.id.codigoTipoDocumento = ?) = ?");
            filtroInscricao = true;
        }
        if (to.getNome() != null && to.getNome().trim().length() > 0) {
            hql.append("        and objPessoaTO.textoNome like ? ");
            filtroNome = true;
        }
        if (to.getTextoSituacaoIdentificador() != UtilPrimitivo.getValorDefaultChar()) {
            daoImpl.montaHQLFiltroSituacaoAutorizacaoDeDebito(hql);
            filtroSitAutorizacao = true;
        }
        if (to.getTextoIdentificacaoIDProprio() != null && to.getTextoIdentificacaoIDProprio().trim().length() > 0 && existeIdentificadorProprio) {
            hql.append("        and '" + to.getTextoIdentificacaoIDProprio() + "' in (select objIdentificacaoTO.textoIdentificacao " + "         from objPessoaTO.identificacaoTOs objIdentificacaoTO " + "         where objIdentificacaoTO.pessoaTO.codigoPessoa=objPessoaTO.codigoPessoa " + "               and (objIdentificacaoTO.id.codigoTipoDocumento = ? and objIdentificacaoTO.id.textoIdentificador = ? ))");
            filtroIdentProprio = true;
        }
        if (to.getIndicadorImpressao() != null && !to.getIndicadorImpressao().equals(new Character('0'))) {
            daoImpl.montaHQLFiltroImpressaoDaAutorizacaoDeDebito(hql);
            filtroIndicadoDeImpressao = true;
        }
        if (to.getIdentificacaoParaDebito() != null && to.getIdentificacaoParaDebito().trim().length() > 0) {
            daoImpl.montaHQLFiltroTextoIdentificadorDeDebito(hql);
            filtroIdentificacaoDeDebito = true;
        }
        String orderBy = to.getNomeColunaOrdenada() == null ? "" : " order by " + to.getNomeColunaOrdenada() + " " + (to.getTipoOrdenacao() == null ? "" : to.getTipoOrdenacao());
        hql.append(" " + (ordenar ? orderBy : ""));
        int iposic = 0;
        Query queryList = daoImpl.novaQuery(hql.toString());
        queryList.setParameter(iposic, (Object)to.getConvenenteTO().getCodigoPessoaConvenente());
        queryList.setParameter(++iposic, (Object)to.getTextoIdentificadorServico());
        if (filtroConvenio) {
            queryList.setParameter(++iposic, (Object)to.getNumeroConvenio());
        }
        if (filtroGrupo) {
            queryList.setParameter(++iposic, (Object)to.getCodigoGrupoClienteRecebimento());
        }
        if (filtroInscricao) {
            queryList.setParameter(++iposic, (Object)to.getCodigoTipoPessoa());
            queryList.setParameter(++iposic, (Object)to.getNumeroInscricao());
        }
        if (filtroNome) {
            queryList.setParameter(++iposic, (Object)("%" + to.getNome() + "%"));
        }
        if (filtroSitAutorizacao) {
            queryList.setParameter(++iposic, (Object)Character.valueOf(to.getTextoSituacaoIdentificador()));
        }
        if (filtroIdentProprio) {
            queryList.setParameter(++iposic, (Object)codigoTipoDocumentoIdentificadorProprioConvenenteServico);
            queryList.setParameter(++iposic, (Object)textoIdentitificadorProprioConvenenteServico);
        }
        if (filtroIndicadoDeImpressao) {
            queryList.setParameter(++iposic, (Object)to.getIndicadorImpressao());
        }
        if (filtroIdentificacaoDeDebito) {
            queryList.setParameter(++iposic, (Object)to.getIdentificacaoParaDebito());
        }
        return queryList;
    }

    protected static void montaHQLFiltroImpressaoDaAutorizacaoDeDebito(StringBuilder hql) {
        hql.append(" and objPessoaTO.codigoPessoa in        (select identDebito.contaCorrenteClienteTO.id.codigoPessoa         from IdentificadorClienteDebitoTO identDebito        where identDebito.indicadorImpressao = ?)");
    }

    protected static void montaHQLFiltroConvenio(StringBuilder hql) {
        hql.append("        and objPessoaTO.codigoPessoa in            (select identDebito.contaCorrenteClienteTO.id.codigoPessoa            from IdentificadorClienteDebitoTO identDebito            where identDebito.convenioDebitoTO.id.numeroConvenio = ?)");
    }

    public static void montaHQLFiltroTextoIdentificadorDeDebito(StringBuilder hql) {
        hql.append("        and objPessoaTO.codigoPessoa in            (select identDebito.pessoaTO.codigoPessoa            from IdentificadorClienteDebitoTO identDebito            where identDebito.textoIdentificadorDebito = ?)");
    }

    public static void montaHQLFiltroSituacaoAutorizacaoDeDebito(StringBuilder hql) {
        hql.append("        and objPessoaTO.codigoPessoa in            (select identDebito.contaCorrenteClienteTO.id.codigoPessoa            from IdentificadorClienteDebitoTO identDebito            where identDebito.situacaoIdentificadorDebitoTO.textoSituacaoIdentificador = ?)");
    }

    public static void montaHQLFiltroGrupoClienteRecebimento(StringBuilder hql) {
        hql.append("        and objPessoaTO.codigoPessoa in            (select membroGrupo.id.codigoPessoaCliente            from MembroGrupoClienteRecebimentoTO membroGrupo            where membroGrupo.id.codigoGrupoClienteRecebimento = ?)");
    }

    public static void montaHQLFiltroSemGrupoClienteRecebimento(StringBuilder hql) {
        hql.append("        and objPessoaTO.codigoPessoa not in            (select membroGrupo.id.codigoPessoaCliente            from MembroGrupoClienteRecebimentoTO membroGrupo)");
    }
}

