/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.integracao.dao.controle;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.controle.JDBCDAOSuport;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.controle.ServicoAplicacaoTO;
import br.com.bb.plugins.gac.util.UtilMensagem;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicoAplicacaoDAO
extends JDBCDAOSuport {
    public ServicoAplicacaoDAO() {
        super("BDGERAL");
    }

    public static void main(String[] args) {
        String s_sql = "CREATE TABLE AUD (TX_CD_OPC_MENU CHAR(4) NOT NULL, TX_CD_TRAN CHAR(20) NOT NULL, NR_AUD INTEGER NOT NULL, NR_IDFR_USU INTEGER NOT NULL, TX_IDFR_SRVC CHAR(4) NOT NULL, DT_HH_AUD DATE)";
        ServicoAplicacaoDAO servicoAplicacaoDAO = new ServicoAplicacaoDAO();
        servicoAplicacaoDAO.setUrlbanco("jdbc:firebirdsql:localhost/3050:C:/TESTE2.GBD");
        try {
            servicoAplicacaoDAO.getConexao().setAutoCommit(false);
            servicoAplicacaoDAO.executarQuery(s_sql);
            servicoAplicacaoDAO.getConexao().commit();
            servicoAplicacaoDAO.getConexao().setAutoCommit(true);
        }
        catch (BBException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void atualizarExpurgo(HashMap<String, ServicoTO> lista) throws BBException {
        String s_sql = "UPDATE SRVC SET NR_DD_RTC_DADO = ?, NR_FRQ_EXCL = ? WHERE TX_IDFR_SRVC = ?";
        try {
            PreparedStatement pstmt = this.getConexao().prepareStatement(s_sql);
            for (ServicoTO plugin : lista.values()) {
                pstmt.setInt(1, plugin.getNumeroDiasRetencaoDados());
                pstmt.setInt(2, plugin.getNumeroFrequenciaExpurgo());
                pstmt.setString(3, plugin.getTextoIdentificadorServico());
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    public ServicoAplicacaoTO consultarServico(String nomeModulo) throws BBException {
        ServicoAplicacaoTO servicoAplicacaoTO = null;
        String s_sql = "SELECT TX_IDFR_SRVC, TX_NM, TX_DCR, TX_VRS, TX_VRS_BASE_DADO, DT_ITLC,IN_EST_CFG_SRVC, IN_MIGR_DADO, DT_MIGR_DADO, IN_PRMO_EXEA, IN_EST_ITLC, NR_FRQ_EXCL, DT_EXEA_ULT_EXCL, NR_DD_RTC_DADO, IN_ASS_DGTL, IN_EST_SRVC, NR_IDFR_USU_ITLC, CD_TIP_SGM FROM SRVC WHERE TX_IDFR_SRVC=?";
        try {
            PreparedStatement pstmt = this.getConexao().prepareStatement(s_sql);
            pstmt.setString(1, nomeModulo);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                servicoAplicacaoTO = new ServicoAplicacaoTO();
                servicoAplicacaoTO.setTextoIdentificadorServico(this.getStringFromResultSet(rs, "TX_IDFR_SRVC"));
                servicoAplicacaoTO.setTextoNome(this.getStringFromResultSet(rs, "TX_NM"));
                servicoAplicacaoTO.setTextoDescricao(this.getStringFromResultSet(rs, "TX_DCR"));
                servicoAplicacaoTO.setTextoVersao(this.getStringFromResultSet(rs, "TX_VRS"));
                servicoAplicacaoTO.setTextoVersaoBaseDados(this.getStringFromResultSet(rs, "TX_VRS_BASE_DADO"));
                servicoAplicacaoTO.setDataInstalacao(this.getDateFromResultSet(rs, "DT_ITLC"));
                servicoAplicacaoTO.setIndicadorEstadoConfiguracaoServico(this.getStringFromResultSet(rs, "IN_EST_CFG_SRVC"));
                servicoAplicacaoTO.setIndicadorMigracaoDados(this.getStringFromResultSet(rs, "IN_MIGR_DADO"));
                servicoAplicacaoTO.setDataMigracaoDados(this.getDateFromResultSet(rs, "DT_MIGR_DADO"));
                servicoAplicacaoTO.setIndicadorPrimeiraExecucao(this.getStringFromResultSet(rs, "IN_PRMO_EXEA"));
                servicoAplicacaoTO.setIndicadorEstadoInstalacao(this.getStringFromResultSet(rs, "IN_EST_ITLC"));
                servicoAplicacaoTO.setNumeroFrequenciaExpurgo(this.getIntFromResultSet(rs, "NR_FRQ_EXCL"));
                servicoAplicacaoTO.setDataExecucaoUltimoExpurgo(this.getDateFromResultSet(rs, "DT_EXEA_ULT_EXCL"));
                servicoAplicacaoTO.setNumeroDiasRetencaoDados(this.getIntFromResultSet(rs, "NR_DD_RTC_DADO"));
                servicoAplicacaoTO.setIndicadorAssinaturaDigital(this.getStringFromResultSet(rs, "IN_ASS_DGTL"));
                servicoAplicacaoTO.setIndicadorEstadoServico(this.getStringFromResultSet(rs, "IN_EST_SRVC"));
                servicoAplicacaoTO.setCodigoTipoSegmento(this.getIntFromResultSet(rs, "CD_TIP_SGM"));
                servicoAplicacaoTO.setNumeroIdentificadorUsuarioInstalador(this.getIntFromResultSet(rs, "NR_IDFR_USU_ITLC"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return servicoAplicacaoTO;
    }

    public void gravarServico(ServicoAplicacaoTO servicoAplicacaoTO) throws BBException {
        String s_sql = "SELECT TX_IDFR_SRVC FROM SRVC WHERE TX_IDFR_SRVC=?";
        try {
            PreparedStatement pstmt = this.getConexao().prepareStatement(s_sql);
            pstmt.setString(1, servicoAplicacaoTO.getTextoIdentificadorServico());
            ResultSet rs = pstmt.executeQuery();
            s_sql = rs.next() ? "UPDATE SRVC SET TX_NM=?, TX_DCR=?, TX_VRS=?, TX_VRS_BASE_DADO=?, DT_ITLC=?, IN_EST_CFG_SRVC=?, IN_MIGR_DADO=?, DT_MIGR_DADO=?, IN_PRMO_EXEA=?, IN_EST_ITLC=?, NR_FRQ_EXCL=?, DT_EXEA_ULT_EXCL=?, NR_DD_RTC_DADO=?, IN_ASS_DGTL=?, IN_EST_SRVC=?, CD_TIP_SGM=?, NR_IDFR_USU_ITLC=? WHERE TX_IDFR_SRVC=?" : "INSERT INTO SRVC (TX_NM, TX_DCR, TX_VRS, TX_VRS_BASE_DADO, DT_ITLC, IN_EST_CFG_SRVC, IN_MIGR_DADO, DT_MIGR_DADO, IN_PRMO_EXEA, IN_EST_ITLC, NR_FRQ_EXCL, DT_EXEA_ULT_EXCL, NR_DD_RTC_DADO, IN_ASS_DGTL, IN_EST_SRVC, CD_TIP_SGM, NR_IDFR_USU_ITLC, TX_IDFR_SRVC) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement pstmt2 = this.getConexao().prepareStatement(s_sql);
            pstmt2.setString(1, servicoAplicacaoTO.getTextoNome());
            pstmt2.setString(2, servicoAplicacaoTO.getTextoDescricao());
            pstmt2.setString(3, servicoAplicacaoTO.getTextoVersao());
            pstmt2.setString(4, servicoAplicacaoTO.getTextoVersaoBaseDados());
            pstmt2.setDate(5, this.parseToSQLDate(servicoAplicacaoTO.getDataInstalacao()));
            pstmt2.setString(6, servicoAplicacaoTO.getIndicadorEstadoConfiguracaoServico());
            pstmt2.setString(7, servicoAplicacaoTO.getIndicadorMigracaoDados());
            pstmt2.setDate(8, this.parseToSQLDate(servicoAplicacaoTO.getDataMigracaoDados()));
            pstmt2.setString(9, servicoAplicacaoTO.getIndicadorPrimeiraExecucao());
            pstmt2.setString(10, servicoAplicacaoTO.getIndicadorEstadoInstalacao());
            pstmt2.setInt(11, servicoAplicacaoTO.getNumeroFrequenciaExpurgo());
            pstmt2.setDate(12, this.parseToSQLDate(servicoAplicacaoTO.getDataExecucaoUltimoExpurgo()));
            pstmt2.setInt(13, servicoAplicacaoTO.getNumeroDiasRetencaoDados());
            pstmt2.setString(14, servicoAplicacaoTO.getIndicadorAssinaturaDigital());
            pstmt2.setString(15, servicoAplicacaoTO.getIndicadorEstadoServico());
            pstmt2.setInt(16, servicoAplicacaoTO.getCodigoTipoSegmento());
            pstmt2.setInt(17, servicoAplicacaoTO.getNumeroIdentificadorUsuarioInstalador());
            pstmt2.setString(18, servicoAplicacaoTO.getTextoIdentificadorServico());
            pstmt2.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    public List<ServicoAplicacaoTO> consultarServicos() throws BBException {
        ArrayList<ServicoAplicacaoTO> servicos = new ArrayList<ServicoAplicacaoTO>();
        String s_sql = "SELECT TX_IDFR_SRVC, TX_NM, TX_DCR, TX_VRS, TX_VRS_BASE_DADO, DT_ITLC,IN_EST_CFG_SRVC, IN_MIGR_DADO, DT_MIGR_DADO, IN_PRMO_EXEA, IN_EST_ITLC, NR_FRQ_EXCL, DT_EXEA_ULT_EXCL, NR_DD_RTC_DADO, IN_ASS_DGTL, IN_EST_SRVC FROM SRVC";
        try {
            Statement sment = this.getConexao().createStatement();
            ResultSet rs = sment.executeQuery(s_sql);
            while (rs.next()) {
                ServicoAplicacaoTO servicoAplicacaoTO = new ServicoAplicacaoTO();
                servicoAplicacaoTO.setTextoIdentificadorServico(this.getStringFromResultSet(rs, "TX_IDFR_SRVC"));
                servicoAplicacaoTO.setTextoNome(this.getStringFromResultSet(rs, "TX_NM"));
                servicoAplicacaoTO.setTextoDescricao(this.getStringFromResultSet(rs, "TX_DCR"));
                servicoAplicacaoTO.setTextoVersao(this.getStringFromResultSet(rs, "TX_VRS"));
                servicoAplicacaoTO.setTextoVersaoBaseDados(this.getStringFromResultSet(rs, "TX_VRS_BASE_DADO"));
                servicoAplicacaoTO.setDataInstalacao(this.getDateFromResultSet(rs, "DT_ITLC"));
                servicoAplicacaoTO.setIndicadorEstadoConfiguracaoServico(this.getStringFromResultSet(rs, "IN_EST_CFG_SRVC"));
                servicoAplicacaoTO.setIndicadorMigracaoDados(this.getStringFromResultSet(rs, "IN_MIGR_DADO"));
                servicoAplicacaoTO.setDataMigracaoDados(this.getDateFromResultSet(rs, "DT_MIGR_DADO"));
                servicoAplicacaoTO.setIndicadorPrimeiraExecucao(this.getStringFromResultSet(rs, "IN_PRMO_EXEA"));
                servicoAplicacaoTO.setIndicadorEstadoInstalacao(this.getStringFromResultSet(rs, "IN_EST_ITLC"));
                servicoAplicacaoTO.setNumeroFrequenciaExpurgo(this.getIntFromResultSet(rs, "NR_FRQ_EXCL"));
                servicoAplicacaoTO.setDataExecucaoUltimoExpurgo(this.getDateFromResultSet(rs, "DT_EXEA_ULT_EXCL"));
                servicoAplicacaoTO.setNumeroDiasRetencaoDados(this.getIntFromResultSet(rs, "NR_DD_RTC_DADO"));
                servicoAplicacaoTO.setIndicadorAssinaturaDigital(this.getStringFromResultSet(rs, "IN_ASS_DGTL"));
                servicoAplicacaoTO.setIndicadorEstadoServico(this.getStringFromResultSet(rs, "IN_EST_SRVC"));
                servicos.add(servicoAplicacaoTO);
            }
        }
        catch (SQLException e) {
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return servicos;
    }

    public boolean testarExistenciaTabela() throws BBException {
        return super.testarExistenciaTabela("SRVC");
    }

    public boolean verificarAtualizacaoBancoDados() throws BBException {
        String s_sql = "SELECT TX_IDFR_SRVC FROM SRVC WHERE IN_EST_ITLC=?";
        try {
            PreparedStatement pstmt = this.getConexao().prepareStatement(s_sql);
            pstmt.setString(1, "T");
            ResultSet rs = pstmt.executeQuery();
            return rs.next();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    public boolean verificarAtualizacaoModulo() throws BBException {
        String s_sql = "SELECT TX_IDFR_SRVC FROM SRVC WHERE IN_EST_ITLC = ?";
        try {
            PreparedStatement pstmt = this.getConexao().prepareStatement(s_sql);
            pstmt.setString(1, "V");
            ResultSet rs = pstmt.executeQuery();
            return rs.next();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    public List<String> consultarServicosAtualizarBD() throws BBException {
        ArrayList<String> servicos = new ArrayList<String>();
        if (!this.testarExistenciaTabela()) {
            servicos.add("GAC");
            return servicos;
        }
        String s_sql = "SELECT TX_IDFR_SRVC FROM SRVC WHERE IN_EST_ITLC=?";
        try {
            PreparedStatement pstmt = this.getConexao().prepareStatement(s_sql);
            pstmt.setString(1, "T");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                servicos.add(this.getStringFromResultSet(rs, "TX_IDFR_SRVC"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return servicos;
    }

    public List<String> consultarServicosAtualizarSemAlteracaoDeBD() throws BBException {
        ArrayList<String> servicos = new ArrayList<String>();
        if (!this.testarExistenciaTabela()) {
            servicos.add("GAC");
            return servicos;
        }
        String sql = "SELECT TX_IDFR_SRVC FROM SRVC WHERE IN_EST_ITLC = ?";
        try {
            PreparedStatement pstmt = this.getConexao().prepareStatement(sql);
            pstmt.setString(1, "V");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                servicos.add(this.getStringFromResultSet(rs, "TX_IDFR_SRVC"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return servicos;
    }

    public boolean verificarAplicativoConfigurado(String nomeServico) throws BBException {
        String s_sql = "SELECT * FROM SRVC_CVNT WHERE TX_IDFR_SRVC = ? AND CD_PSS_CVNT = 400 AND (SELECT COUNT(CD_PSS_CVNT) FROM SRVC_CVNT WHERE TX_IDFR_SRVC = ?) > 1";
        boolean ret = false;
        try {
            PreparedStatement pstmt = this.getConexao().prepareStatement(s_sql);
            pstmt.setString(1, nomeServico);
            pstmt.setString(2, nomeServico);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                ret = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return ret;
    }

    public void desvincularConvenioEConvenenteDemonstracao(String nomeServico) throws BBException {
        String s_sql = "DELETE FROM SRVC_CVNT WHERE CD_PSS_CVNT = 400 AND TX_IDFR_SRVC = ?";
        String s_sql2 = "DELETE FROM CVN WHERE CD_PSS_CVNT = 400 AND TX_IDFR_SRVC = ?";
        try {
            PreparedStatement pstmt = this.getConexao().prepareStatement(s_sql);
            pstmt.setString(1, nomeServico);
            pstmt.executeUpdate();
            PreparedStatement pstmt2 = this.getConexao().prepareStatement(s_sql2);
            pstmt2.setString(1, nomeServico);
            pstmt2.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    public int incluirServicoConvenente(int codigo, String servico) throws BBException {
        PreparedStatement pstmt;
        int ret = 0;
        try {
            String s_sql = "INSERT INTO SRVC_CVNT (CD_PSS_CVNT, TX_IDFR_SRVC) VALUES (?, ?)";
            pstmt = this.getConexao().prepareStatement(s_sql);
            pstmt.setInt(1, codigo);
            pstmt.setString(2, servico);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return ret += pstmt.executeUpdate();
    }

    public int excluirConstraint(String tabela, String constraint) throws BBException, SQLException {
        PreparedStatement pstmt;
        int ret = 0;
        try {
            String s_sql = "ALTER TABLE " + tabela + " DROP CONSTRAINT " + constraint;
            pstmt = this.getConexao().prepareStatement(s_sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return ret += pstmt.executeUpdate();
    }

    public int alterarCampo(String tabela, String campo, String novoValor) throws BBException, SQLException {
        PreparedStatement pstmt;
        int ret = 0;
        try {
            String s_sql = "ALTER TABLE " + tabela + " ALTER " + campo + " TYPE " + novoValor;
            pstmt = this.getConexao().prepareStatement(s_sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return ret += pstmt.executeUpdate();
    }

    public int adicionarConstraint(String tabela, String constraint, String fk, String tabReferencia) throws BBException, SQLException {
        PreparedStatement pstmt;
        int ret = 0;
        try {
            String s_sql = "ALTER TABLE " + tabela + " ADD CONSTRAINT " + constraint + " FOREIGN KEY (" + fk + ")" + " REFERENCES " + tabReferencia + "(" + fk + ")";
            pstmt = this.getConexao().prepareStatement(s_sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return ret += pstmt.executeUpdate();
    }

    public int setarPK(String tabela, String constraint, String pk) throws BBException, SQLException {
        PreparedStatement pstmt;
        int ret = 0;
        try {
            String s_sql = "ALTER TABLE " + tabela + " ADD CONSTRAINT " + constraint + " PRIMARY KEY (" + pk + ")";
            pstmt = this.getConexao().prepareStatement(s_sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return ret += pstmt.executeUpdate();
    }

    @Deprecated
    public int excluirIndice(String tabela, String indice) throws BBException {
        PreparedStatement pstmt;
        int ret = 0;
        try {
            String s_sql = "ALTER INDEX " + indice + " INACTIVE";
            pstmt = this.getConexao().prepareStatement(s_sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return ret += pstmt.executeUpdate();
    }

    public boolean existeDemonstracao(String nomeModulo) throws BBException {
        String s_sql = "SELECT * FROM SRVC_CVNT WHERE CD_PSS_CVNT = ? AND TX_IDFR_SRVC = ?";
        boolean ret = false;
        try {
            PreparedStatement pstmt = this.getConexao().prepareStatement(s_sql);
            pstmt.setString(1, "400");
            pstmt.setString(2, nomeModulo);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return ret;
    }

    public int incluirCampoDtPagamentoEmpenho(String tabela, String campo, String tipoDado) throws BBException, SQLException {
        PreparedStatement pstmt;
        int ret = 0;
        try {
            String s_sql = "ALTER TABLE " + tabela + " ADD " + campo + " " + tipoDado;
            pstmt = this.getConexao().prepareStatement(s_sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return ret += pstmt.executeUpdate();
    }

    @Override
    public boolean testarExistenciaColuna(String nomeTabela, String nomeCampo) throws BBException {
        return super.testarExistenciaColuna(nomeTabela, nomeCampo);
    }
}

