/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.facade;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.facade.PluginFacadeAbstrato;
import br.com.bb.plugins.gac.negocio.model.AtualizarBancoDadosModel;
import br.com.bb.plugins.gac.negocio.model.AtualizarSistemaModel;
import br.com.bb.plugins.gac.negocio.model.IniciarUtilizacaoModel;
import br.com.bb.plugins.gac.negocio.model.ManterBancoDadosControleModel;
import br.com.bb.plugins.gac.negocio.model.ManterEstruturaBancoDadosModel;
import br.com.bb.plugins.gac.negocio.model.ManterPerifericoModel;
import br.com.bb.plugins.gac.negocio.model.MapearDiretorioModel;
import br.com.bb.plugins.gac.negocio.to.controle.ServicoAplicacaoTO;
import br.com.bb.plugins.gac.negocio.to.controle.ServicoControleTO;
import br.com.bb.plugins.gac.negocio.to.decorator.DiretoriosTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.PerifericoTODecorator;
import br.com.bb.plugins.gac.util.objecttablemodel.AplicativoDisponivelAtualizacaoBO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IniciarUtilizacaoFacade
extends PluginFacadeAbstrato {
    private IniciarUtilizacaoModel iniciarUtilizacaoModel;
    private ManterBancoDadosControleModel manterBancoDadosControleModel;
    private ManterEstruturaBancoDadosModel manterEstruturaBancoDadosModel;
    private ManterPerifericoModel manterPerifericoModel;
    private MapearDiretorioModel mapearDiretorioModel;
    private AtualizarSistemaModel atualizarSistemaModel;
    private AtualizarBancoDadosModel atualizarBancoDadosModel;

    public AtualizarSistemaModel getAtualizarSistemaModel() {
        if (this.atualizarSistemaModel == null) {
            this.atualizarSistemaModel = new AtualizarSistemaModel();
        }
        return this.atualizarSistemaModel;
    }

    public void setAtualizarSistemaModel(AtualizarSistemaModel atualizarSistemaModel) {
        this.atualizarSistemaModel = atualizarSistemaModel;
    }

    public boolean testarCopiaSeguranca() throws BBException {
        return this.manterEstruturaBancoDadosModel.testarCopiaSeguranca();
    }

    public boolean verificarAplicativoInstalado(String nomeModulo) throws BBException {
        if (this.getIniciarUtilizacaoModel().verificarAplicativoInstalado(nomeModulo)) {
            return this.getManterEstruturaBancoDadosModel().vericarRegistroAplicativoInstalado(nomeModulo);
        }
        return false;
    }

    public boolean existeVersaoNovaAplicativo(String nomeModulo) throws BBException {
        return this.getManterBancoDadosControleModel().verificarNovaInstalacao(nomeModulo, this.getIniciarUtilizacaoModel().versaoInstalada(nomeModulo));
    }

    public void removerJarModulo(String nomeModulo) throws BBException {
        this.getManterBancoDadosControleModel().removerJarModulo(nomeModulo);
    }

    public void excluirModuloServido(String nomeModulo) throws BBException {
        this.getManterBancoDadosControleModel().excluirModuloServido(nomeModulo);
    }

    public void executarExpurgo(String nomeModulo) throws BBException {
        this.getIniciarUtilizacaoModel().executarExpurgo(nomeModulo);
    }

    public void executarRotinaPosInstalacao(String nomeModulo) throws BBException {
        this.getIniciarUtilizacaoModel().executarRotina(nomeModulo);
    }

    public void executarRotinaPosInstalacaoNovaVersao(String nomeModulo) throws BBException {
        this.getIniciarUtilizacaoModel().executarRotinaNovaVersao(nomeModulo);
    }

    public void instalarModulo(String nomeModulo) throws BBException {
        this.getManterBancoDadosControleModel().instalarModulo(nomeModulo);
    }

    public boolean testarEpurgoCadastroVencido(String nomeModulo) throws BBException {
        ManterEstruturaBancoDadosModel model = this.getManterEstruturaBancoDadosModel();
        return model.testarExpurgoCadastroVencido(nomeModulo);
    }

    public void executarCopiaSeguranca() throws BBException {
        this.getIniciarUtilizacaoModel().executarCopiaSeguranca();
    }

    public IniciarUtilizacaoModel getIniciarUtilizacaoModel() {
        if (this.iniciarUtilizacaoModel == null) {
            this.iniciarUtilizacaoModel = new IniciarUtilizacaoModel();
        }
        return this.iniciarUtilizacaoModel;
    }

    public ManterBancoDadosControleModel getManterBancoDadosControleModel() {
        if (this.manterBancoDadosControleModel == null) {
            this.manterBancoDadosControleModel = new ManterBancoDadosControleModel();
        }
        return this.manterBancoDadosControleModel;
    }

    public ManterEstruturaBancoDadosModel getManterEstruturaBancoDadosModel() {
        if (this.manterEstruturaBancoDadosModel == null) {
            this.manterEstruturaBancoDadosModel = new ManterEstruturaBancoDadosModel();
        }
        return this.manterEstruturaBancoDadosModel;
    }

    public void atualizarEstruturaBancoDados(String nomeModulo) throws BBException {
        this.getManterEstruturaBancoDadosModel().atualizarEstruturaBD(nomeModulo, this.getIniciarUtilizacaoModel().getTabelasXML(nomeModulo));
    }

    public String getVersaoBancoXML(String nomeModulo) throws BBException {
        return this.getIniciarUtilizacaoModel().getVersaoBancoXML(nomeModulo);
    }

    public String getVersaoBancoDadosXML(String nomeModulo) throws BBException {
        return this.getIniciarUtilizacaoModel().getVersaoBancoDadosXML(nomeModulo);
    }

    public boolean atualizarBancoDados() throws BBException {
        return this.getManterEstruturaBancoDadosModel().verificarAtualizacaoBancoDados();
    }

    public boolean atualizarModulo() throws BBException {
        return this.getManterEstruturaBancoDadosModel().verificarAtualizacaoModulo();
    }

    public boolean testarDiaBackup() throws BBException {
        return this.getManterEstruturaBancoDadosModel().verificarAtualizacaoBancoDados();
    }

    public boolean verificarModuloAplicativo(String nomeModulo) throws BBException {
        return this.getManterBancoDadosControleModel().verificarModuloAplicativo(nomeModulo);
    }

    public boolean verificarRemoverModulo(String nomeModulo) throws BBException {
        return this.getManterBancoDadosControleModel().verificarRemoverModulo(nomeModulo);
    }

    public String buscarModulosRemover() throws BBException {
        return this.getManterBancoDadosControleModel().buscarModulosRemover();
    }

    public void bloquearBancoDados() throws BBException {
    }

    public void liberarBancoDados() throws BBException {
    }

    public void atualizarRegistroModuloBancoDados(String nomeModulo, String versaoBancoXML) throws BBException {
        this.getManterEstruturaBancoDadosModel().atualizarRegistroModuloBancoDados(nomeModulo, versaoBancoXML, this.getIniciarUtilizacaoModel().getPluginInfo(nomeModulo));
    }

    public void registrarDadosAplicativo(String nomeModulo) throws BBException {
        this.getManterEstruturaBancoDadosModel().registrarDadosAplicativo(nomeModulo, this.getIniciarUtilizacaoModel().getPluginInfo(nomeModulo));
    }

    public boolean verificarPrimeiraExecucao(String nomeModulo) throws BBException {
        return this.getManterEstruturaBancoDadosModel().verificarPrimeiraExecucao(nomeModulo);
    }

    public boolean verificaVersaoDemonstracao(String nomeModulo) throws BBException {
        return this.getManterEstruturaBancoDadosModel().verificaVersaoDemonstracao(nomeModulo);
    }

    public boolean testarConexaoBancoDados() throws BBException {
        return this.getManterBancoDadosControleModel().testarConexaoBancoDados();
    }

    public boolean verificarVersaoMinimaGAC(String nomeModulo) throws BBException {
        return this.getIniciarUtilizacaoModel().verificarVersaoMinimaGAC(nomeModulo);
    }

    public List<String> consultarServicosAtualizarBD() throws BBException {
        return this.getManterEstruturaBancoDadosModel().consultarServicosAtualizarBD();
    }

    public List<String> consultarServicosAtualizarSemAlteracaoDeBD() throws BBException {
        return this.getManterEstruturaBancoDadosModel().consultarServicosAtualizarSemAlteracaoDeBD();
    }

    public boolean testarConexaoBancoDados(String urlBanco, String nomeUsuarioBD, String senhaBD) throws BBException {
        return this.getManterBancoDadosControleModel().testarConexaoBancoDados(urlBanco, nomeUsuarioBD, senhaBD);
    }

    public void atualizarPrimeiraExecucao(String nomeModulo) throws BBException {
        this.getManterEstruturaBancoDadosModel().atualizarPrimeiraExecucao(nomeModulo);
    }

    public void atualizarAplicativoConfigurado(String nomeModulo) throws BBException {
        this.getManterEstruturaBancoDadosModel().atualizarAplicativoConfigurado(nomeModulo);
    }

    public ManterPerifericoModel getManterPerifericoModel() {
        if (this.manterPerifericoModel == null) {
            this.manterPerifericoModel = new ManterPerifericoModel();
        }
        return this.manterPerifericoModel;
    }

    public MapearDiretorioModel getMapearDiretorioModel() {
        if (this.mapearDiretorioModel == null) {
            this.mapearDiretorioModel = new MapearDiretorioModel();
        }
        return this.mapearDiretorioModel;
    }

    public PerifericoTODecorator recuperaPeriferico() throws BBException {
        return this.getManterPerifericoModel().recuperaPeriferico();
    }

    public boolean arquivoEncontradoNormal() throws BBException {
        return this.getMapearDiretorioModel().arquivoEncontradoNormal();
    }

    public boolean validaSeExisteDiretorios() throws BBException {
        DiretoriosTODecorator diretoriosTODecorator = this.getMapearDiretorioModel().recuperarDiretorios();
        this.getMapearDiretorioModel().setDiretoriosTO(diretoriosTODecorator);
        return this.getMapearDiretorioModel().validaSeExisteDiretorios();
    }

    public void atualizarDataExpurgo(String nomeModulo) throws BBException {
        this.getIniciarUtilizacaoModel().atualizarDataExpurgo(nomeModulo);
    }

    public boolean verificarAplicativoConfigurado(String nomeServico) throws BBException {
        return this.getManterEstruturaBancoDadosModel().verificarAplicativoConfigurado(nomeServico);
    }

    public void desvincularConvenioEConvenenteDemonstracao(String nomeServico) throws BBException {
        this.getManterEstruturaBancoDadosModel().desvincularConvenioEConvenenteDemonstracao(nomeServico);
    }

    public ServicoControleTO consultarServico(String nomeServico) throws BBException {
        return this.getManterBancoDadosControleModel().consultarServico(nomeServico);
    }

    public List<ServicoControleTO> consultarServicos() throws BBException {
        return this.getManterBancoDadosControleModel().listaAplicativosInstalados();
    }

    public List<AplicativoDisponivelAtualizacaoBO> aplicativosAtualizar() throws BBException, IOException {
        return this.getAtualizarSistemaModel().listaAplicativosAtualizar(this.getManterBancoDadosControleModel().listaAplicativosInstalados());
    }

    public List<AplicativoDisponivelAtualizacaoBO> servicosAtualizar() throws BBException, IOException {
        List<AplicativoDisponivelAtualizacaoBO> servicos = new ArrayList<AplicativoDisponivelAtualizacaoBO>(0);
        List<ServicoAplicacaoTO> servicosInstalados = this.getIniciarUtilizacaoModel().getServicoAplicacaoDao().consultarServicos();
        if (servicosInstalados.size() > 1) {
            servicos = this.aplicativosAtualizar();
        }
        return servicos;
    }

    public AtualizarBancoDadosModel getAtualizarBancoDadosModel() {
        if (this.atualizarBancoDadosModel == null) {
            this.atualizarBancoDadosModel = new AtualizarBancoDadosModel();
        }
        return this.atualizarBancoDadosModel;
    }

    public void setAtualizarBancoDadosModel(AtualizarBancoDadosModel atualizarBancoDadosModel) {
        this.atualizarBancoDadosModel = atualizarBancoDadosModel;
    }

    public boolean verificarAtualizacaoGAC(int update) throws BBException {
        return this.getAtualizarBancoDadosModel().verificarAtualizacaoNoGAC(update);
    }

    public void atualizarGAC(int atualizacao) throws BBException {
        this.getAtualizarBancoDadosModel().atualizarGAC(atualizacao);
    }

    public String getArquivoJAR(String nomeModulo) {
        return this.getIniciarUtilizacaoModel().getArquivoJAR(nomeModulo);
    }

    public void registrarDadosModuloBasico(String nomeModulo) throws BBException {
        this.getManterEstruturaBancoDadosModel().registrarDadosAplicativo(nomeModulo, this.getIniciarUtilizacaoModel().getPluginInfoModuloBasico(nomeModulo));
    }
}

