/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.apresentacao.atualizarsistema.form.AtualizarSistemaForm;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.FormFactory;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.controle.ServicoControleTO;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.bb.plugins.gac.util.StringUtil;
import br.com.bb.plugins.gac.util.Util;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.controller.view.Plugin;
import br.com.bb.plugins.gac.util.objecttablemodel.AplicativoDisponivelAtualizacaoBO;
import br.com.bb.plugins.gac.util.objecttablemodel.AplicativoDisponivelInstalacaoBO;
import br.com.bb.plugins.gac.util.objecttablemodel.AplicativoInstaladoBO;
import br.com.bb.plugins.gac.util.swing.componente.BBFileDownLoad;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtualizarSistemaModel
extends PluginModelAbstrato {
    private ConfiguracaoProperties configuracaoProperties = null;
    private List<Plugin> pluginsList = new ArrayList<Plugin>();
    private List<AplicativoDisponivelAtualizacaoBO> listaAplicativosParaAtualizar;
    private List<AplicativoDisponivelInstalacaoBO> listaAplicativosNovos;
    private List<AplicativoDisponivelAtualizacaoBO> listaModuloBasicoParaAtualizar;

    public void buscarDescritivoArquivos(AtualizarSistemaForm atualizarSistemaForm) throws BBException {
        BBFileDownLoad bbdown = atualizarSistemaForm.getFileDownload();
        bbdown.doDownLoad();
    }

    public void processaXMLDescritor(AtualizarSistemaForm atualizarSistemaForm) throws BBException, IOException {
        try {
            this.LerConfiguracoes();
            HashMap<String, AplicativoInstaladoBO> aplicativosInstaladosMap = new HashMap<String, AplicativoInstaladoBO>();
            if (atualizarSistemaForm.getListaAplicativosInstalados() != null) {
                for (AplicativoInstaladoBO aplicativoInstaladoBO : atualizarSistemaForm.getListaAplicativosInstalados()) {
                    aplicativosInstaladosMap.put(aplicativoInstaladoBO.getCodigo().trim(), aplicativoInstaladoBO);
                }
                this.adicionaModuloBasicoNoMap(aplicativosInstaladosMap);
            }
            this.listaModuloBasicoParaAtualizar = new ArrayList<AplicativoDisponivelAtualizacaoBO>();
            this.listaAplicativosParaAtualizar = new ArrayList<AplicativoDisponivelAtualizacaoBO>();
            this.listaAplicativosNovos = new ArrayList<AplicativoDisponivelInstalacaoBO>();
            if (this.pluginsList != null) {
                for (Plugin plugin : this.pluginsList) {
                    AplicativoInstaladoBO aplicativoInstaladoBO = (AplicativoInstaladoBO)aplicativosInstaladosMap.get(plugin.getNome().trim());
                    if (aplicativoInstaladoBO == null) {
                        AplicativoDisponivelInstalacaoBO aplicativoDisponivelInstalacaoBO = new AplicativoDisponivelInstalacaoBO(plugin.getNome(), plugin.getTitulo(), plugin.getVersao(), plugin.getDatapacote(), "", plugin.getNomejar(), plugin.getTamanho(), plugin.getVersaominimagac());
                        this.listaAplicativosNovos.add(aplicativoDisponivelInstalacaoBO);
                        continue;
                    }
                    if (!this.versaoEMaior(plugin.getVersao(), aplicativoInstaladoBO.getVersao())) continue;
                    AplicativoDisponivelAtualizacaoBO aplicativoDisponivelAtualizacaoBO = new AplicativoDisponivelAtualizacaoBO(plugin.getNome(), plugin.getTitulo(), aplicativoInstaladoBO.getVersao(), plugin.getVersao(), plugin.getDatapacote(), "", plugin.getNomejar(), plugin.getTamanho(), plugin.getVersaominimagac());
                    if ("GAC".equalsIgnoreCase(aplicativoDisponivelAtualizacaoBO.getCodigo())) {
                        this.listaModuloBasicoParaAtualizar.add(aplicativoDisponivelAtualizacaoBO);
                        continue;
                    }
                    this.listaAplicativosParaAtualizar.add(aplicativoDisponivelAtualizacaoBO);
                }
            }
            atualizarSistemaForm.setListaAplicativosDisponiveisInstalacao(this.listaAplicativosNovos);
            atualizarSistemaForm.setListaAplicativosDisponiveisAtualizacao(this.listaAplicativosParaAtualizar);
            atualizarSistemaForm.setListaModuloBasicoParaAtualizar(this.listaModuloBasicoParaAtualizar);
        }
        catch (BBException e) {
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    public boolean versaoEMaior(String versao, String versao2) {
        return Util.parseLong(versao) > Util.parseLong(versao2);
    }

    private void LerConfiguracoes() throws BBException, IOException {
        ConfiguracaoProperties config = ConfiguracaoProperties.getConfiguracaoProperties();
        File fileapp = new File(String.valueOf(config.getDirTemp()) + "/aplicativos.xml");
        SAXBuilder sax = new SAXBuilder();
        this.pluginsList.clear();
        try {
            try {
                Document doc = sax.build(fileapp);
                Element tab = doc.getRootElement();
                List lista = tab.getChildren("aplicativo");
                for (Element element : lista) {
                    Plugin plugin = new Plugin();
                    plugin.setNome(element.getChildText("sigla"));
                    plugin.setTitulo(element.getChildText("titulo"));
                    plugin.setVersao(element.getChildText("versao"));
                    plugin.setVersaoDB(element.getChildText("versaodb"));
                    plugin.setDatapacote(element.getChildText("datapacote"));
                    plugin.setNomejar(element.getChildText("nomejar"));
                    plugin.setVersaominimagac(element.getChildText("versaominimagac"));
                    plugin.setTamanho(Util.parseLong(element.getChildText("tamanho")));
                    this.pluginsList.add(plugin);
                }
            }
            catch (JDOMException e) {
                System.out.println("Ocorreu o erro: " + e.getMessage());
                e.printStackTrace();
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
        }
        finally {
            try {
                fileapp.delete();
            }
            catch (Exception e) {
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
        }
    }

    public ConfiguracaoProperties getConfiguracaoProperties() {
        if (this.configuracaoProperties == null) {
            this.configuracaoProperties = ConfiguracaoProperties.getConfiguracaoProperties();
        }
        return this.configuracaoProperties;
    }

    private void adicionaModuloBasicoNoMap(Map<String, AplicativoInstaladoBO> aplicativosInstaladosMap) {
        AplicativoInstaladoBO aplicativoInstaladoBO = new AplicativoInstaladoBO("GAC", null, StringUtil.removeNotNumeric(UtilMensagem.getInstancia().getMensagem("versao.gac")), null, null, null);
        aplicativosInstaladosMap.put(aplicativoInstaladoBO.getCodigo().trim(), aplicativoInstaladoBO);
    }

    public List<AplicativoDisponivelAtualizacaoBO> listaAplicativosAtualizar(List<ServicoControleTO> lista) throws BBException, IOException {
        AtualizarSistemaForm form = FormFactory.getInstancia().novoAtualizarSistemaForm();
        form.setListaAplicativosInstalados(lista);
        BBFileDownLoad fd = new BBFileDownLoad("aplicativos.xml", 0L);
        fd.setPath(ConfiguracaoProperties.getConfiguracaoProperties().getDirTemp());
        form.setFileDownload(fd);
        this.buscarDescritivoArquivos(form);
        this.processaXMLDescritor(form);
        ArrayList<AplicativoDisponivelAtualizacaoBO> appsAtualizar = new ArrayList<AplicativoDisponivelAtualizacaoBO>(0);
        for (AplicativoDisponivelAtualizacaoBO app : form.getListaAplicativosDisponiveisAtualizacao()) {
            appsAtualizar.add(app);
        }
        return appsAtualizar;
    }
}

