/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.ModelFactory;
import br.com.bb.plugins.gac.negocio.model.ManterPerifericoModel;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.DominioTO;
import br.com.bb.plugins.gac.negocio.to.decorator.PerifericoTODecorator;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.politec.generico.arquivo.UtilArquivo;
import br.com.politec.generico.string.UtilString;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Properties;

public class ConfigurarScannerModel
extends PluginModelAbstrato {
    private static final String CABECALHO = "[SCANNER]";

    public DominioTO recuperaScanner() throws BBException {
        DominioTO scannerTODecorator = new DominioTO();
        File file = new File(this.getCaminhoArquivo());
        if (file.exists()) {
            scannerTODecorator.setModelo(this.getValorPropertie("scanner") == null ? "0" : this.getValorPropertie("scanner"));
        } else {
            try {
                FileWriter fileWriter = new FileWriter(file);
            }
            catch (IOException e) {
                System.out.println(this.getCaminhoArquivo());
                e.printStackTrace();
                throw new BBException("MI051");
            }
        }
        return scannerTODecorator;
    }

    private String getValorPropertie(String propriedade) {
        return UtilString.getString(this.getArquivoProperties().get(propriedade));
    }

    public Properties getArquivoProperties() {
        return UtilArquivo.getProperties(this.getCaminhoArquivo());
    }

    private String getCaminhoArquivo() {
        return String.valueOf(ConfiguracaoProperties.getConfiguracaoProperties().getDirProg()) + "/Periferico.ini";
    }

    public void incluirInformacoesScanner(DominioTO scannerTODecorator) throws BBException {
        try {
            this.gravarArquivoConfiguracaoScanner(scannerTODecorator);
        }
        catch (FileNotFoundException e) {
            System.out.println(this.getCaminhoArquivo());
            e.printStackTrace();
            throw new BBException("MI051");
        }
        catch (IOException e) {
            System.out.println(this.getCaminhoArquivo());
            e.printStackTrace();
            throw new BBException("MI051");
        }
    }

    private void gravarArquivoConfiguracaoScanner(DominioTO scannerTODecorator) throws FileNotFoundException, IOException, BBException {
        PerifericoTODecorator perifericoTODecorator = this.getManterPerifericoModel().recuperaPeriferico();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.getCaminhoArquivo())));
        this.getManterPerifericoModel().popula(bufferedWriter, perifericoTODecorator);
        this.popula(bufferedWriter, scannerTODecorator);
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    public void popula(BufferedWriter bufferedWriter, DominioTO scannerTODecorator) throws IOException {
        bufferedWriter.newLine();
        bufferedWriter.write(CABECALHO);
        bufferedWriter.newLine();
        bufferedWriter.write("scanner=" + this.trataModelo(scannerTODecorator));
        bufferedWriter.newLine();
    }

    private String trataModelo(DominioTO scannerTODecorator) {
        return scannerTODecorator.getModelo() == null ? "0" : (scannerTODecorator.getModelo().trim().length() == 0 ? "0" : scannerTODecorator.getModelo());
    }

    public ManterPerifericoModel getManterPerifericoModel() {
        return ModelFactory.getInstancia().novoManterPerifericoModel();
    }
}

