/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.ContaCorrenteClienteDAO;
import br.com.bb.plugins.gac.integracao.dao.PessoaDAO;
import br.com.bb.plugins.gac.integracao.dao.ServicoDAO;
import br.com.bb.plugins.gac.negocio.model.GerarCopiaSegurancaModel;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ControleCopiaSegurancaTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.PessoaTODecorator;
import br.com.bb.plugins.gac.util.UtilArquivoConfiguracao;
import br.com.bb.plugins.gac.util.UtilNotificador;
import br.com.politec.generico.calculadores.UtilSomadoresDeData;
import br.com.politec.generico.conversor.UtilConversorDeData;
import br.com.politec.generico.fabrica.DataFactory;
import java.util.Collection;
import java.util.Date;

public class ExecutarExpurgoCadastroPessoaModel
extends PluginModelAbstrato {
    private PessoaDAO pessoaDAO;
    private ServicoDAO servicoDAO;
    private ContaCorrenteClienteDAO contaCorrenteClienteDAO;
    private GerarCopiaSegurancaModel gerarCopiaSegurancaModel;

    public void alterar(ServicoTO servicoTO) {
        servicoTO.setDataExecucaoUltimoExpurgo(UtilConversorDeData.converterParaSqlDate(this.getDataAtual()));
        this.getServicoDAO().alterar(servicoTO);
    }

    public ServicoTO listar(ServicoTO servicoTO) {
        return this.getServicoDAO().listar(servicoTO);
    }

    public void executarCopiaSeguranca(PessoaTODecorator pessoaTODecorator) throws BBException {
        ControleCopiaSegurancaTODecorator to = this.getFabricaDeTO().novoControleCopiaSegurancaTODecorator();
        String diretorio = this.getDiretorioCopiaDeSeguraca();
        to.setTextoNomeDiretorioArquivo(diretorio);
        to.setNotificaCopiaSeguranca(pessoaTODecorator.getNotificaCopiaSeguranca());
        this.getGerarCopiaSegurancaModel().gerar(to);
    }

    public void excluir(PessoaTODecorator pessoaTODecorator) throws BBException {
        long registroAtual = 1L;
        pessoaTODecorator.getPessoaTO().setDataUltimaOperacao(UtilSomadoresDeData.adicionarDias(this.getDataAtual(), -pessoaTODecorator.getDiasRetencaoDados()));
        Collection<PessoaTO> colecaoExpurgo = this.getPessoaDAO().consultarPorServicoDataEDebito(pessoaTODecorator);
        for (PessoaTO pessoaTO : colecaoExpurgo) {
            this.getContaCorrenteClienteDAO().excluir(pessoaTO);
            this.getPessoaDAO().excluir(pessoaTO);
            this.atualizaPorcentagem(pessoaTODecorator.getNotificaExpurgo(), pessoaTODecorator.getTotalCadastrosExpurgo(), registroAtual);
            ++registroAtual;
        }
    }

    public String getDiretorioCopiaDeSeguraca() {
        String diretorioCopiaSeguranca = this.getUtilArquivoConfiguracao().getValorPropertie("diretorio.copiaseguranca");
        return diretorioCopiaSeguranca;
    }

    protected UtilArquivoConfiguracao getUtilArquivoConfiguracao() {
        return UtilArquivoConfiguracao.getInstancia();
    }

    public Integer getQuantidadePorDataEDebito(PessoaTODecorator pessoaTODecorator) {
        pessoaTODecorator.setDataUltimaOperacao(UtilSomadoresDeData.adicionarDias(this.getDataAtual(), -pessoaTODecorator.getDiasRetencaoDados()));
        return this.getPessoaDAO().getQuantidadePorDataEDebito(pessoaTODecorator);
    }

    public Integer getQuantidadePorServicoDataEDebito(PessoaTODecorator pessoaTODecorator) {
        pessoaTODecorator.setDataUltimaOperacao(UtilSomadoresDeData.adicionarDias(this.getDataAtual(), -pessoaTODecorator.getDiasRetencaoDados()));
        return this.getPessoaDAO().getQuantidadePorServicoDataEDebito(pessoaTODecorator);
    }

    private Date getDataAtual() {
        return DataFactory.getInstance().novoDate();
    }

    private void atualizaPorcentagem(UtilNotificador notificaExpurgo, int totalCadastros, long numeroCadastroAtual) {
        long porcentagem = numeroCadastroAtual * 100L / (long)totalCadastros;
        notificaExpurgo.notifyObservers(porcentagem);
    }

    public PessoaDAO getPessoaDAO() {
        return this.pessoaDAO;
    }

    public void setPessoaDAO(PessoaDAO pessoaDAO) {
        this.pessoaDAO = pessoaDAO;
    }

    public ServicoDAO getServicoDAO() {
        return this.servicoDAO;
    }

    public void setServicoDAO(ServicoDAO servicoDAO) {
        this.servicoDAO = servicoDAO;
    }

    public GerarCopiaSegurancaModel getGerarCopiaSegurancaModel() {
        return this.gerarCopiaSegurancaModel;
    }

    public void setGerarCopiaSegurancaModel(GerarCopiaSegurancaModel gerarCopiaSegurancaModel) {
        this.gerarCopiaSegurancaModel = gerarCopiaSegurancaModel;
    }

    public ContaCorrenteClienteDAO getContaCorrenteClienteDAO() {
        return this.contaCorrenteClienteDAO;
    }

    public void setContaCorrenteClienteDAO(ContaCorrenteClienteDAO contaCorrenteClienteDAO) {
        this.contaCorrenteClienteDAO = contaCorrenteClienteDAO;
    }
}

