/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.ControleCopiaSegurancaDAO;
import br.com.bb.plugins.gac.integracao.dao.ServicoDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.ControleCopiaSegurancaTO;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ControleCopiaSegurancaTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.DiretoriosTODecorator;
import br.com.bb.plugins.gac.util.UtilArquivoConfiguracao;
import br.com.bb.plugins.gac.util.UtilBBException;
import br.com.bb.plugins.gac.util.UtilNotificador;
import br.com.bb.plugins.gac.util.ZipUtils;
import br.com.politec.generico.formatador.UtilFormatadorDeData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Calendar;
import java.util.Date;

public class GerarCopiaSegurancaModel
extends PluginModelAbstrato {
    private ControleCopiaSegurancaDAO controleCopiaSegurancaDAO;
    private ServicoDAO servicoDAO;
    private DiretoriosTODecorator diretoriosTO;

    private FilenameFilter getFiltroFDB() {
        return new FilenameFilter(){

            public boolean accept(File diretorio, String nomeArquivo) {
                return nomeArquivo.endsWith("FDB");
            }
        };
    }

    public void gerar(ControleCopiaSegurancaTODecorator to) throws BBException {
        String diretorio = this.getUtilArquivoConfiguracao().getValorPropertie("diretorio.banco");
        Date dataAtual = Calendar.getInstance().getTime();
        to.setTextoNomeArquivoCopiaSeguranca(this.getNomeArquivoBancoDadosBackUp(dataAtual));
        to.setDataEfetivacaoCopiaSeguranca(dataAtual);
        to.setIndicadorTipoCopiaSeguranca(Character.valueOf('F'));
        to.setTextoVersaoBaseDados(this.getVersaoBancoDados());
        this.criaPastasSeNecessario(to.getTextoNomeDiretorioArquivo());
        ZipUtils.zip(diretorio, String.valueOf(to.getTextoNomeDiretorioArquivo()) + File.separator + to.getTextoNomeArquivoCopiaSeguranca(), this.getFiltroFDB());
        this.incluir(to.getControleCopiaSegurancaTO());
    }

    private File criaPastasSeNecessario(String pathPasta) {
        File pasta = new File(pathPasta);
        if (!pasta.exists()) {
            pasta.mkdirs();
        }
        return pasta;
    }

    protected String getVersaoBancoDados() {
        ServicoTO to = this.getFabricaDeTO().novoServicoTO();
        to.setTextoIdentificadorServico("GAC");
        ServicoTO servicoTO = this.getServicoDAO().listar(to);
        return servicoTO.getTextoVersaoBaseDados();
    }

    public void incluir(ControleCopiaSegurancaTO to) {
        this.getControleCopiaSegurancaDAO().incluir(to);
    }

    private String getNomeArquivoBancoDadosBackUp(Date dataAtual) {
        return "BBGACA" + UtilFormatadorDeData.formatar(dataAtual, "yyyyMMdd_hhmmss") + ".zip";
    }

    public void copiarArquivo(String origem, String destino, ControleCopiaSegurancaTODecorator to) throws BBException {
        UtilArquivoConfiguracao util = this.getUtilArquivoConfiguracao();
        String dirPadraoAtual = util.getValorPropertie("diretorio.copiaseguranca");
        if (dirPadraoAtual == null) {
            this.getUtilArquivoConfiguracao().setValor("diretorio.copiaseguranca", to.getTextoNomeDiretorioArquivo());
            this.getUtilArquivoConfiguracao().salvar();
        }
        File fileOrigem = this.getArquivoFactory().novoFile(origem);
        File fileDestino = this.getArquivoFactory().novoFile(destino);
        FileChannel inChannel = null;
        AbstractInterruptibleChannel outChannel = null;
        try {
            try {
                inChannel = new FileInputStream(fileOrigem).getChannel();
                outChannel = new FileOutputStream(fileDestino).getChannel();
                int maxCount = 1024;
                long size = inChannel.size();
                long position = 0L;
                while (position < size) {
                    position += inChannel.transferTo(position, maxCount, (WritableByteChannel)((Object)outChannel));
                    this.atualizaPorcentagem(to.getNotificaCopiaSeguranca(), size, position);
                }
            }
            catch (FileNotFoundException e) {
                throw UtilBBException.getErroDeSistema(e);
            }
            catch (IOException e) {
                throw UtilBBException.getErroDeSistema(e);
            }
        }
        finally {
            try {
                if (inChannel != null) {
                    inChannel.close();
                }
                if (outChannel != null) {
                    outChannel.close();
                }
            }
            catch (IOException e) {
                throw UtilBBException.getErroDeSistema(e);
            }
        }
    }

    protected void copiarArquivoOld(String origem, String destino, ControleCopiaSegurancaTODecorator to) throws BBException {
        BufferedWriter bufferDestino = null;
        BufferedReader bufferOrigem = null;
        try {
            try {
                File arqdestino = this.getArquivoFactory().novoFile(origem);
                FileWriter writerDestino = this.getArquivoFactory().novoFileWriter(destino);
                FileReader readerOrigem = this.getArquivoFactory().novoFileReader(origem);
                bufferDestino = this.getArquivoFactory().novoBufferedWriter(writerDestino);
                bufferOrigem = this.getArquivoFactory().novoBufferedReader(readerOrigem);
                long tamanhoArquivoOrigem = arqdestino.length();
                char[] buffer = new char[1024];
                long totalBuff = tamanhoArquivoOrigem / 1024L;
                int i = 0;
                while (bufferOrigem.read(buffer) != -1) {
                    bufferDestino.write(buffer);
                    this.atualizaPorcentagem(to.getNotificaCopiaSeguranca(), totalBuff, i);
                    ++i;
                }
            }
            catch (FileNotFoundException e) {
                throw UtilBBException.getErroDeSistema(e);
            }
            catch (IOException e) {
                throw UtilBBException.getErroDeSistema(e);
            }
        }
        finally {
            try {
                bufferDestino.close();
                bufferOrigem.close();
            }
            catch (IOException e) {
                throw UtilBBException.getErroDeSistema(e);
            }
        }
    }

    private void atualizaPorcentagem(UtilNotificador notificaCopiaSeguranca, long tamanhoTotal, long tamanhoAtual) {
        long porcentagem = tamanhoAtual * 100L / tamanhoTotal;
        notificaCopiaSeguranca.notifyObservers(porcentagem);
    }

    public boolean isInstalacaoCompartilhada() {
        String valor = this.getUtilArquivoConfiguracao().getValorPropertie("hibernate.tipoinstalacaobancodados");
        return valor.equals(String.valueOf(0));
    }

    protected UtilArquivoConfiguracao getUtilArquivoConfiguracao() {
        return UtilArquivoConfiguracao.getInstancia();
    }

    public ControleCopiaSegurancaDAO getControleCopiaSegurancaDAO() {
        return this.controleCopiaSegurancaDAO;
    }

    public void setControleCopiaSegurancaDAO(ControleCopiaSegurancaDAO controleCopiaSegurancaDAO) {
        this.controleCopiaSegurancaDAO = controleCopiaSegurancaDAO;
    }

    public ServicoDAO getServicoDAO() {
        return this.servicoDAO;
    }

    public void setServicoDAO(ServicoDAO servicoDAO) {
        this.servicoDAO = servicoDAO;
    }

    private void armazenaMapeamentoDiretorios() throws BBException {
        this.getUtilArquivoConfiguracao().setValor("diretorio.copiaseguranca", this.getDiretoriosTO().getDiretorioPadraoBackup());
    }

    public DiretoriosTODecorator getDiretoriosTO() {
        return this.diretoriosTO;
    }
}

