/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.TOFactory;
import br.com.bb.plugins.gac.integracao.dao.AuditoriaDAO;
import br.com.bb.plugins.gac.integracao.dao.GrupoUsuarioDAO;
import br.com.bb.plugins.gac.integracao.dao.PermissaoGrupoDAO;
import br.com.bb.plugins.gac.integracao.dao.UsuarioDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.EstadoGrupoUsuarioTO;
import br.com.bb.plugins.gac.negocio.to.GrupoUsuarioTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.decorator.GrupoUsuarioTODecorator;
import br.com.bb.plugins.gac.util.dominio.UtilDominioTipoEstadoUsuario;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrupoUsuarioModel
extends PluginModelAbstrato {
    private GrupoUsuarioDAO grupoUsuarioDAO;
    private UsuarioDAO usuarioDAO;
    private AuditoriaDAO auditoriaDAO;
    private PermissaoGrupoDAO permissaoGrupoDAO;

    public AuditoriaDAO getAuditoriaDAO() {
        return this.auditoriaDAO;
    }

    public void setAuditoriaDAO(AuditoriaDAO auditoriaDAO) {
        this.auditoriaDAO = auditoriaDAO;
    }

    public UsuarioDAO getUsuarioDAO() {
        return this.usuarioDAO;
    }

    public void setUsuarioDAO(UsuarioDAO usuarioDAO) {
        this.usuarioDAO = usuarioDAO;
    }

    public GrupoUsuarioTO incluir(GrupoUsuarioTODecorator grupoUsuarioTO) throws BBException {
        GrupoUsuarioTO grupo = grupoUsuarioTO.getGrupoUsuarioTO();
        EstadoGrupoUsuarioTO estado = TOFactory.getInstancia().novoEstadoGrupoUsuarioTO();
        estado.setCodigoEstadoGrupoUsuario(UtilDominioTipoEstadoUsuario.ATIVO);
        if (this.getGrupoUsuarioDAO().isExisteNome(grupoUsuarioTO)) {
            throw new BBException("MP031");
        }
        grupo.setEstadoGrupoUsuarioTO(estado);
        grupo = this.getGrupoUsuarioDAO().incluir(grupo);
        return grupo;
    }

    public PaginadorTO consultar(GrupoUsuarioTODecorator grupoTO) {
        return this.getGrupoUsuarioDAO().consultar(grupoTO);
    }

    public void excluir(GrupoUsuarioTO grupoUsuarioTO) throws BBException {
        if (this.getUsuarioDAO().isExisteRegistro(grupoUsuarioTO)) {
            throw new BBException("MP029");
        }
        this.getPermissaoGrupoDAO().excluirPorIdentificadorDoGrupoUsuario(grupoUsuarioTO);
        this.getGrupoUsuarioDAO().excluir(grupoUsuarioTO);
    }

    public void editar(GrupoUsuarioTODecorator grupoUsuarioTO) throws BBException {
        if (this.getGrupoUsuarioDAO().isExisteNome(grupoUsuarioTO)) {
            throw new BBException("MP031");
        }
        this.getGrupoUsuarioDAO().alterar(grupoUsuarioTO.getGrupoUsuarioTO());
    }

    public GrupoUsuarioDAO getGrupoUsuarioDAO() {
        return this.grupoUsuarioDAO;
    }

    public void setGrupoUsuarioDAO(GrupoUsuarioDAO grupoUsuarioDAO) {
        this.grupoUsuarioDAO = grupoUsuarioDAO;
    }

    public Collection<GrupoUsuarioTO> getGrupoUsuario() {
        return this.getGrupoUsuarioDAO().consultar();
    }

    public PermissaoGrupoDAO getPermissaoGrupoDAO() {
        return this.permissaoGrupoDAO;
    }

    public void setPermissaoGrupoDAO(PermissaoGrupoDAO permissaoGrupoDAO) {
        this.permissaoGrupoDAO = permissaoGrupoDAO;
    }
}

