/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.controle.ServicoControleDAO;
import br.com.bb.plugins.gac.negocio.to.controle.ServicoControleTO;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.bb.plugins.gac.util.FileUtils;
import br.com.bb.plugins.gac.util.Util;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.ZipUtils;
import br.com.bb.plugins.gac.util.objecttablemodel.AplicativoDisponivelInstalacaoBO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManterBancoDadosControleModel {
    private ConfiguracaoProperties config = ConfiguracaoProperties.getConfiguracaoProperties();
    private ServicoControleDAO servicoControleDAO = null;
    private String pastatemp = null;
    private String pastaAplicacao = null;
    private String urlBanco = null;

    public ManterBancoDadosControleModel() {
        this.setPastatemp(this.config.getDirTemp());
        this.setPastaAplicacao(this.config.getDirProg());
        this.setUrlBanco(this.config.getUrl());
    }

    public ServicoControleDAO getServicoControleDAO() {
        if (this.servicoControleDAO == null) {
            this.servicoControleDAO = new ServicoControleDAO();
        }
        return this.servicoControleDAO;
    }

    public void gravarServico(ServicoControleTO servico) throws BBException {
        this.getServicoControleDAO().gravarServico(servico);
    }

    public void lerPacote(String nomePacote) throws BBException {
        try {
            ServicoControleTO servicoControle = this.consultarServico(nomePacote);
            byte[] blobByteArray = this.getServicoControleDAO().lerCampoBLOB(nomePacote);
            if (blobByteArray == null) {
                System.out.println("Pacote de instala\u00e7\u00e3o do Aplicativo n\u00e3o foi encontrado no Banco de dados de Controle");
                throw new BBException("MI004");
            }
            FileOutputStream out = new FileOutputStream(String.valueOf(this.getPastatemp()) + servicoControle.getNomeFisicoPacote());
            out.write(blobByteArray);
            out.close();
        }
        catch (IOException e) {
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    public void excluirModuloServido(String nomePacote) throws BBException {
        this.getServicoControleDAO().deletarServico(nomePacote);
    }

    public ServicoControleTO consultarServico(String nomePacote) throws BBException {
        return this.getServicoControleDAO().consultarServico(nomePacote);
    }

    public void gravarPacoteJar(String nomePacote, String nomearquivo) throws BBException {
        try {
            File arquivo = new File(nomearquivo);
            FileInputStream inputStream = new FileInputStream(arquivo);
            this.getServicoControleDAO().gravarCampoBLOB(nomePacote, inputStream, (int)arquivo.length());
        }
        catch (FileNotFoundException e) {
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    public boolean excluirJar(String modulo) {
        File file = new File(modulo);
        return file.delete();
    }

    public boolean verificarNovaInstalacao(String nomeModulo, String versaoInstalada) throws BBException {
        ServicoControleTO ServicoControleTO2 = this.getServicoControleDAO().consultarServico(nomeModulo);
        return ServicoControleTO2 != null && (versaoInstalada == null || versaoInstalada.trim().length() == 0 || Util.parseLong(versaoInstalada) < Util.parseLong(ServicoControleTO2.getVersaoPacote()));
    }

    public String getPastatemp() {
        return this.pastatemp;
    }

    public void setPastatemp(String pastatemp) {
        this.pastatemp = pastatemp;
    }

    public String getPastaAplicacao() {
        return this.pastaAplicacao;
    }

    public void setPastaAplicacao(String pastaAplicacao) {
        this.pastaAplicacao = pastaAplicacao;
    }

    public boolean verificarModuloAplicativo(String nomeModulo) throws BBException {
        ServicoControleTO servicoControleTO = this.getServicoControleDAO().consultarServico(nomeModulo);
        return servicoControleTO != null;
    }

    public boolean verificarRemoverModulo(String nomeModulo) throws BBException {
        if (nomeModulo == null || nomeModulo.trim().equals("")) {
            throw new BBException("Nome do M\u00f3dulo deve ser preenchido");
        }
        return this.buscarModulosRemover().indexOf(nomeModulo.toUpperCase()) >= 0;
    }

    public String buscarModulosRemover() throws BBException {
        return ConfiguracaoProperties.getConfiguracaoProperties().getRemoverModulo();
    }

    public void instalarModulo(String nomeModulo) throws BBException {
        this.lerPacote(nomeModulo);
        ServicoControleTO servicoControle = this.consultarServico(nomeModulo);
        if ("GAC".equalsIgnoreCase(nomeModulo)) {
            if (servicoControle.getNomeFisicoPacote().toLowerCase().endsWith(".jar")) {
                try {
                    FileUtils.copiar(new File(String.valueOf(this.getPastatemp()) + File.separator + servicoControle.getNomeFisicoPacote()), new File(String.valueOf(this.getPastaAplicacao()) + File.separator + servicoControle.getNomeFisicoPacote()));
                }
                catch (Throwable e) {
                    throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
                }
            } else if (servicoControle.getNomeFisicoPacote().toLowerCase().endsWith(".zip")) {
                ZipUtils.descompacta(String.valueOf(this.getPastatemp()) + File.separator + servicoControle.getNomeFisicoPacote(), String.valueOf(this.getPastaAplicacao()) + File.separator);
            }
        } else {
            try {
                File modulo = new File(String.valueOf(this.getPastatemp()) + File.separator + servicoControle.getNomeFisicoPacote());
                long bytes = modulo.length();
                FileUtils.copiar(modulo, new File(String.valueOf(this.getPastaAplicacao()) + File.separator + "plugins" + File.separator + servicoControle.getNomeFisicoPacote()));
            }
            catch (Throwable e) {
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
        }
    }

    public List<ServicoControleTO> listaAplicativosInstalados() throws BBException {
        return this.getServicoControleDAO().consultarServicos();
    }

    public void removerJarModulo(String nomeModulo) throws BBException {
        File file;
        if (nomeModulo == null || nomeModulo.trim().equals("")) {
            throw new BBException("Selecione um m\u00f3dulo!");
        }
        nomeModulo = nomeModulo.trim();
        String jarTemp = String.valueOf(this.getPastatemp()) + File.separator + "bb" + nomeModulo.toLowerCase() + ".jar";
        this.excluirJar(jarTemp);
        String jarPlugin = String.valueOf(this.getPastaAplicacao()) + File.separator + "plugins" + File.separator + "bb" + nomeModulo.toLowerCase() + ".jar";
        if (!this.excluirJar(jarPlugin) && (file = new File(jarPlugin)).exists()) {
            throw new BBException("Problema na remo\u00e7\u00e3o do m\u00f3dulo" + nomeModulo + "! Feche o aplicativo e tente novamente.");
        }
    }

    public void salvarAplicacoes(List aplicativosAtualizados, List aplicativosInstalados) throws BBException {
        this.getServicoControleDAO().salvarAplicacoes(aplicativosAtualizados, aplicativosInstalados, this.config.getDirTemp());
    }

    public void salvarAplicacoes(List<AplicativoDisponivelInstalacaoBO> aplicativosInstalar) throws BBException {
        this.getServicoControleDAO().salvarAplicacoes(aplicativosInstalar, String.valueOf(this.config.getDirProg()) + File.separator + "plugins");
    }

    public boolean testarConexaoBancoDados() throws BBException {
        return this.testarConexaoBancoDados(this.config.getUrlControle(), this.config.getNomeUsuario(), this.config.getSenha());
    }

    public String getUrlBanco() {
        return this.urlBanco;
    }

    public void setUrlBanco(String urlBanco) {
        this.urlBanco = urlBanco;
    }

    public boolean testarConexaoBancoDados(String urlBanco, String nomeUsuarioBD, String senhaBD) throws BBException {
        this.getServicoControleDAO().setUrlbanco(urlBanco);
        this.getServicoControleDAO().setUsuarioBanco(nomeUsuarioBD);
        this.getServicoControleDAO().setSenhaBanco(senhaBD);
        try {
            Class.forName(this.config.getDriver());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return this.getServicoControleDAO().testarConexaoBancoDados();
    }
}

