/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.ComplementoPessoaFisicaDAO;
import br.com.bb.plugins.gac.integracao.dao.ConvenentePessoaDAO;
import br.com.bb.plugins.gac.negocio.model.ManterCadastroPessoaModel;
import br.com.bb.plugins.gac.negocio.to.CapacidadeCivilTO;
import br.com.bb.plugins.gac.negocio.to.ComplementoPessoaFisicaTO;
import br.com.bb.plugins.gac.negocio.to.ContatoTO;
import br.com.bb.plugins.gac.negocio.to.ConvenentePessoaTO;
import br.com.bb.plugins.gac.negocio.to.EstadoCivilTO;
import br.com.bb.plugins.gac.negocio.to.FormacaoTO;
import br.com.bb.plugins.gac.negocio.to.GrauInstrucaoTO;
import br.com.bb.plugins.gac.negocio.to.NaturezaOcupacaoTO;
import br.com.bb.plugins.gac.negocio.to.NivelCargoTO;
import br.com.bb.plugins.gac.negocio.to.OcupacaoTO;
import br.com.bb.plugins.gac.negocio.to.SituacaoImovelTO;
import br.com.bb.plugins.gac.negocio.to.TipoContratoTrabalhoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenentePessoaTODecorator;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManterCadastroPessoaFisicaModel
extends ManterCadastroPessoaModel {
    private ComplementoPessoaFisicaDAO complementoPessoaFisicaDAO;
    private ConvenentePessoaDAO convenentePessoaDAO;

    public ComplementoPessoaFisicaTO incluir(ComplementoPessoaFisicaTO pessoaFisicaTO) throws BBException {
        this.verificaSeExistePessoaCadastrada(pessoaFisicaTO);
        this.atribuiValoresPadroes(pessoaFisicaTO);
        this.atribuiIdContato(pessoaFisicaTO);
        this.atribuiTipoPessoa(pessoaFisicaTO, 1);
        this.atribuiDataDaUltimaOperacao(pessoaFisicaTO);
        this.atribuiPessoaTONaColecaoIdentificacaoTO(pessoaFisicaTO);
        this.atribuiPessoaTONaColecaoContatoTO(pessoaFisicaTO);
        this.atribuiPessoaTONaColecaoLogradouroTO(pessoaFisicaTO);
        return this.getComplementoPessoaFisicaDAO().incluirOuAlterar(pessoaFisicaTO);
    }

    private void atribuiValoresPadroes(ComplementoPessoaFisicaTO complementoPessoaFisica) {
        complementoPessoaFisica.setPessoaTOByCdPssEpgr(complementoPessoaFisica);
        complementoPessoaFisica.setCapacidadeCivilTO(new CapacidadeCivilTO());
        complementoPessoaFisica.getCapacidadeCivilTO().setCodigoCapacidadeCivil(0);
        complementoPessoaFisica.setEstadoCivilTO(new EstadoCivilTO());
        complementoPessoaFisica.getEstadoCivilTO().setCodigoEstadoCivil(0);
        complementoPessoaFisica.setFormacaoTO(new FormacaoTO());
        complementoPessoaFisica.getFormacaoTO().setCodigoFormacao(0);
        complementoPessoaFisica.setGrauInstrucaoTO(new GrauInstrucaoTO());
        complementoPessoaFisica.getGrauInstrucaoTO().setCodigoGrauInstrucao(0);
        complementoPessoaFisica.setNaturezaOcupacaoTO(new NaturezaOcupacaoTO());
        complementoPessoaFisica.getNaturezaOcupacaoTO().setCodigoNaturezaOcupacao(0);
        complementoPessoaFisica.setNivelCargoTO(new NivelCargoTO());
        complementoPessoaFisica.getNivelCargoTO().setCodigoNivelCargo(0);
        complementoPessoaFisica.setOcupacaoTO(new OcupacaoTO());
        complementoPessoaFisica.getOcupacaoTO().setCodigoOcupacao(0);
        complementoPessoaFisica.setSituacaoImovelTO(new SituacaoImovelTO());
        complementoPessoaFisica.getSituacaoImovelTO().setCodigoSituacaoImovel(0);
        complementoPessoaFisica.setTipoContratoTrabalhoTO(new TipoContratoTrabalhoTO());
        complementoPessoaFisica.getTipoContratoTrabalhoTO().setCodigoTipoContratoTrabalho(0);
    }

    public void editar(ComplementoPessoaFisicaTO complementoPessoaFisicaTO) {
        if (!this.existeVinculoDaPessoaEmAlgumNegocio(complementoPessoaFisicaTO)) {
            this.excluirIdentificacaoTO(complementoPessoaFisicaTO);
        }
        this.excluirContatoTO(complementoPessoaFisicaTO);
        this.excluirLogradouroTO(complementoPessoaFisicaTO);
        this.atribuiValoresPadroes(complementoPessoaFisicaTO);
        this.atribuiTipoPessoa(complementoPessoaFisicaTO, 1);
        this.atribuiIdContato(complementoPessoaFisicaTO);
        this.atribuiPessoaTONaColecaoIdentificacaoTO(complementoPessoaFisicaTO);
        this.atribuiPessoaTONaColecaoContatoTO(complementoPessoaFisicaTO);
        this.atribuiPessoaTONaColecaoLogradouroTO(complementoPessoaFisicaTO);
        this.getComplementoPessoaFisicaDAO().alterar(complementoPessoaFisicaTO);
    }

    private void atribuiIdContato(ComplementoPessoaFisicaTO complementoPessoaFisicaTO) {
        int icont = 1;
        for (ContatoTO contatoTO : complementoPessoaFisicaTO.getContatoTOs()) {
            contatoTO.getId().setNumeroIdentificadorContato(icont);
            ++icont;
        }
    }

    public void excluir(ComplementoPessoaFisicaTO complementoPessoaFisicaTO) throws BBException {
        if (this.getConvenentePessoaDAO().consultarPorCodigoPessoaRetornandoColecao(complementoPessoaFisicaTO.getCodigoPessoa()).size() > 0) {
            throw new BBException("MP019");
        }
        if (this.getConvenentePessoaDAO().consultarColecaoPorConvenente(complementoPessoaFisicaTO.getCodigoPessoa()).size() > 0) {
            throw new BBException("MP019");
        }
        if (this.getComplementoPessoaFisicaDAO().isConjuge(complementoPessoaFisicaTO)) {
            throw new BBException("MP061");
        }
        this.getComplementoPessoaFisicaDAO().excluir(complementoPessoaFisicaTO);
    }

    public ComplementoPessoaFisicaDAO getComplementoPessoaFisicaDAO() {
        return this.complementoPessoaFisicaDAO;
    }

    public void setComplementoPessoaFisicaDAO(ComplementoPessoaFisicaDAO complementoPessoaFisicaDAO) {
        this.complementoPessoaFisicaDAO = complementoPessoaFisicaDAO;
    }

    @Override
    public ConvenentePessoaDAO getConvenentePessoaDAO() {
        return this.convenentePessoaDAO;
    }

    @Override
    public void setConvenentePessoaDAO(ConvenentePessoaDAO convenentePessoaDAO) {
        this.convenentePessoaDAO = convenentePessoaDAO;
    }

    public Collection<ComplementoPessoaFisicaTO> consultarTodosComplementosPF() {
        return this.getComplementoPessoaFisicaDAO().consultarTodosComplementosPF();
    }

    public Collection<ConvenentePessoaTO> consultarConvenentePorCodigoConvenio(Integer codigoConvenente) {
        return this.getConvenentePessoaDAO().consultarColecaoPorConvenente(codigoConvenente);
    }

    public Collection<ComplementoPessoaFisicaTO> consultarComplementosPessoaFisicaPor(ConvenentePessoaTODecorator convenetePessoaTODecorator) {
        return this.getComplementoPessoaFisicaDAO().consultarComplementosPessoaFisicaPor(convenetePessoaTODecorator);
    }

    public Collection<ComplementoPessoaFisicaTO> consultar() {
        return this.getComplementoPessoaFisicaDAO().consultar();
    }
}

