/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.ConvenenteDAO;
import br.com.bb.plugins.gac.integracao.dao.IdentificadorDAO;
import br.com.bb.plugins.gac.integracao.dao.IdentificadorProprioConvenenteServicoDAO;
import br.com.bb.plugins.gac.integracao.dao.LogradouroDAO;
import br.com.bb.plugins.gac.integracao.dao.PessoaDAO;
import br.com.bb.plugins.gac.integracao.dao.ServicoConvenenteDAO;
import br.com.bb.plugins.gac.integracao.dao.ServicoTipoDocumentoDAO;
import br.com.bb.plugins.gac.integracao.dao.TipoDocumentoDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorProprioConvenenteServicoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorProprioConvenenteServicoTOId;
import br.com.bb.plugins.gac.negocio.to.IdentificadorTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorTOId;
import br.com.bb.plugins.gac.negocio.to.LogradouroTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.ServicoConvenenteTOId;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.ServicoTipoDocumentoTO;
import br.com.bb.plugins.gac.negocio.to.ServicoTipoDocumentoTOId;
import br.com.bb.plugins.gac.negocio.to.TipoDocumentoTO;
import br.com.bb.plugins.gac.negocio.to.TipoLogradouroTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenenteTODecorator;
import br.com.bb.plugins.gac.util.UtilIdentificadorProprio;
import br.com.bb.plugins.gac.util.dominio.UtilDominioTipoDocumento;
import br.com.politec.generico.string.UtilString;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManterConvenenteModel
extends PluginModelAbstrato {
    private ConvenenteDAO convenenteDAO;
    private LogradouroDAO logradouroDAO;
    private PessoaDAO pessoaDAO;
    private IdentificadorDAO identificadorDAO;
    private TipoDocumentoDAO tipoDocumentoDAO;
    private ServicoTipoDocumentoDAO servicoTipoDocumentoDAO;
    private IdentificadorProprioConvenenteServicoDAO identificadorProprioConvenenteServicoDAO;
    private ServicoConvenenteDAO servicoConvenenteDAO;

    public ConvenenteDAO getConvenenteDAO() {
        return this.convenenteDAO;
    }

    public void setConvenenteDAO(ConvenenteDAO convenenteDAO) {
        this.convenenteDAO = convenenteDAO;
    }

    public boolean isExistePessoa(ConvenenteTO convenenteTO) {
        return this.getConvenenteDAO().isExistePessoa(convenenteTO);
    }

    public ConvenenteTO incluir(ConvenenteTO convenenteTO) {
        return this.getConvenenteDAO().incluir(convenenteTO);
    }

    public ConvenenteTO listar(ConvenenteTO convenenteTO) {
        return this.getConvenenteDAO().listar(convenenteTO);
    }

    public PaginadorTO consultar(ConvenenteTODecorator decorator) {
        if (!this.isReferencia(decorator)) {
            decorator = this.getFabricaDeTO().novoConvenenteTODecorator();
        }
        decorator.setColecaoTipoDocumento(this.getColecaoDeTipoDocumentoDeCPFeCNPJ());
        return this.getConvenenteDAO().consultarPeloTipoDeDocumento(decorator);
    }

    public void excluir(ConvenenteTO convenente) throws BBException {
        this.verificaExclusaoConvenente(convenente);
        this.excluirIdentificadorProprioConvenenteServico(convenente);
        if (this.existeOutroServicoConvenente(convenente)) {
            this.excluirAssociacaoServicoConvenente(convenente);
        } else {
            this.getConvenenteDAO().excluir(convenente);
        }
    }

    private void excluirIdentificadorProprioConvenenteServico(ConvenenteTO convenente) throws BBException {
        IdentificadorProprioConvenenteServicoTO identificadorProprioConvenenteServicoTO = UtilIdentificadorProprio.getInstancia().consultaIdentificadorProprioConvenenteServicoPor(convenente, this.getServicoAtual());
        if (identificadorProprioConvenenteServicoTO != null) {
            this.getIdentificadorProprioConvenenteServicoDAO().excluir(identificadorProprioConvenenteServicoTO);
        }
    }

    private void verificaExclusaoConvenente(ConvenenteTO convenente) throws BBException {
        if (this.verificaConveniosConvenente(convenente)) {
            throw new BBException("MP047");
        }
    }

    private ServicoTipoDocumentoTO insereServicoTipoDocumento(TipoDocumentoTO tipoDocumentoTO, String strServico) {
        ServicoTipoDocumentoTO servicoTipoDoc = this.getFabricaDeTO().novoServicoTipoDocumentoTO();
        ServicoTipoDocumentoTOId servicoTipoDocid = this.getFabricaDeTO().novoServicoTipoDocumentoTOId();
        servicoTipoDoc.setId(servicoTipoDocid);
        servicoTipoDoc.getId().setCodigoTipoDocumento(tipoDocumentoTO.getCodigoTipoDocumento());
        servicoTipoDoc.getId().setTextoIdentificadorServico(strServico);
        return this.getServicoTipoDocumentoDAO().incluirOuAlterar(servicoTipoDoc);
    }

    private void excluiServicoTipoDocumento(TipoDocumentoTO tipoDocumentoTO) {
        ServicoTipoDocumentoTO servicoTipoDoc = this.getFabricaDeTO().novoServicoTipoDocumentoTO();
        ServicoTipoDocumentoTOId servicoTipoDocid = this.getFabricaDeTO().novoServicoTipoDocumentoTOId();
        servicoTipoDocid.setCodigoTipoDocumento(tipoDocumentoTO.getCodigoTipoDocumento());
        servicoTipoDocid.setTextoIdentificadorServico(this.getServicoAtual());
        this.getServicoTipoDocumentoDAO().excluirPorID(servicoTipoDocid);
    }

    public void editar(ConvenenteTODecorator convenenteTOSelecionado) {
        for (LogradouroTO logradouroTO : convenenteTOSelecionado.getPessoaTO().getLogradouroTOs()) {
            String textoCEP = this.removeMascara(logradouroTO.getTextoCep());
            logradouroTO.setTextoCep(textoCEP);
            if (logradouroTO.getPessoaTO() != null && logradouroTO.getPessoaTO().getCodigoPessoa() != convenenteTOSelecionado.getPessoaTO().getCodigoPessoa()) {
                logradouroTO.setCodigoLogradouro(null);
                logradouroTO.setPessoaTO(null);
            }
            if (logradouroTO.getPessoaTO() == null) {
                logradouroTO.setPessoaTO(convenenteTOSelecionado.getPessoaTO());
                TipoLogradouroTO tipLogradouroTO = new TipoLogradouroTO();
                tipLogradouroTO.setCodigoTipoLogradouro(1);
                logradouroTO.setTipoLogradouroTO(tipLogradouroTO);
                logradouroTO.setNumeroLogradouro(0);
            }
            this.getLogradouroDAO().incluirOuAlterar(logradouroTO);
        }
        IdentificadorProprioConvenenteServicoTO identificadorProprioConvenenteServicoTO = UtilIdentificadorProprio.getInstancia().consultaIdentificadorProprioConvenenteServicoPor(convenenteTOSelecionado.getConvenente(), this.getServicoAtual());
        IdentificadorTO identificadorAnterior = identificadorProprioConvenenteServicoTO != null ? identificadorProprioConvenenteServicoTO.getIdentificadorTO() : null;
        IdentificadorTO identificador = convenenteTOSelecionado.getIdentificadorProprio(true);
        if (identificador.getNomeIdentificador() != null && identificador.getNomeIdentificador().compareTo("") == 0 && convenenteTOSelecionado.isApagarDocumento()) {
            ConvenenteTO convenenteTO = convenenteTOSelecionado.getConvenente();
            if (this.isReferencia(identificadorAnterior)) {
                this.getIdentificadorProprioConvenenteServicoDAO().excluir(identificadorProprioConvenenteServicoTO);
                this.getIdentificadorDAO().excluir(identificadorAnterior);
                this.atualizaConvenenteDaSessao(convenenteTOSelecionado);
            }
            return;
        }
        if (identificadorAnterior == null && identificador.getNomeIdentificador() != null && identificador.getNomeIdentificador().compareTo("") != 0) {
            this.insereServicoTipoDocumento((TipoDocumentoTO)((Object)this.getTipoDocumentoDAO().listar(10)), this.getServicoAtual());
            IdentificadorTO identificadorTO = this.salvarIdentificadorTO(identificador);
            this.salvaIdentificadorProprioConvenenteServico(identificadorTO, convenenteTOSelecionado);
        }
        this.getPessoaDAO().alterar(convenenteTOSelecionado.getPessoaTO());
        this.atualizaConvenenteDaSessao(convenenteTOSelecionado);
    }

    private void salvaIdentificadorProprioConvenenteServico(IdentificadorTO identificadorTO, ConvenenteTODecorator convenenteTODecorator) {
        IdentificadorProprioConvenenteServicoTO identificadorProprioConvenenteServicoTO = this.preencheIdentificadorProprioConvenenteServicoPor(identificadorTO, convenenteTODecorator.getConvenente());
        this.getIdentificadorProprioConvenenteServicoDAO().incluirOuAlterar(identificadorProprioConvenenteServicoTO);
    }

    private IdentificadorProprioConvenenteServicoTO preencheIdentificadorProprioConvenenteServicoPor(IdentificadorTO identificadorTO, ConvenenteTO convenenteTO) {
        IdentificadorProprioConvenenteServicoTO identificadorProprioConvenenteServicoTO = this.getFabricaDeTO().novoIdentificadorProprioConvenenteServicoTO();
        identificadorProprioConvenenteServicoTO.setConvenenteTO(convenenteTO);
        identificadorProprioConvenenteServicoTO.setIdentificadorTO(identificadorTO);
        identificadorProprioConvenenteServicoTO.setServicoTO(new ServicoTO(this.getServicoAtual()));
        IdentificadorProprioConvenenteServicoTOId id = this.getFabricaDeTO().novoIdentificadorProprioConvenenteServicoTOId();
        id.setCodigoPessoaConvenente(convenenteTO.getCodigoPessoaConvenente());
        id.setCodigoTipoDocumento(identificadorTO.getId().getCodigoTipoDocumento());
        id.setTextoIdentificador(identificadorTO.getId().getTextoIdentificador());
        id.setTextoIdentificadorServico(this.getServicoAtual());
        identificadorProprioConvenenteServicoTO.setId(id);
        return identificadorProprioConvenenteServicoTO;
    }

    private IdentificadorTO salvarIdentificadorTO(IdentificadorTO identificador) {
        String mascara;
        IdentificadorTO ident = this.getFabricaDeTO().novoIdentificadorTO();
        IdentificadorTOId id = new IdentificadorTOId();
        id.setCodigoTipoDocumento(10);
        Integer proximoNumero = this.getIdentificadorDAO().consultarProximoIdentificador(10);
        if (proximoNumero < 10) {
            proximoNumero = 10;
        }
        id.setTextoIdentificador("" + proximoNumero);
        ident.setId(id);
        if (identificador.getTextoMascara().toString().charAt(0) == '#') {
            ident.setIndicadorDominio(Character.valueOf('N'));
            mascara = identificador.getTextoMascara().replace('#', '9');
        } else {
            ident.setIndicadorDominio(Character.valueOf('A'));
            mascara = identificador.getTextoMascara().replace('@', '9');
        }
        ident.setNomeIdentificador(identificador.getNomeIdentificador());
        ident.setNumeroTamanhoIdentificador(identificador.getNumeroTamanhoIdentificador());
        ident.setTextoMascara(mascara);
        int tamMascara = 0;
        if (identificador.getTextoMascara().length() > 0) {
            tamMascara = identificador.getTextoMascara().length();
        }
        ident.setTextoMascaraSaida(mascara);
        ident.setNumeroQuantidadeMinima(1);
        ident.setNumeroQuantidadeMaxima(tamMascara);
        ident.setIndicadorComplemento(identificador.getIndicadorComplemento());
        ident.setTextoMascaraIdentificadora(identificador.getTextoMascaraIdentificadora());
        ident.setTextoIdentificadorInscricaoDebito(identificador.getTextoIdentificadorInscricaoDebito());
        ident.setIndicadorEstadoIdentificador(Character.valueOf('1'));
        ident.setTipoDocumentoTO((TipoDocumentoTO)((Object)this.getTipoDocumentoDAO().listar(10)));
        IdentificadorTO identificadorTO = this.getIdentificadorDAO().incluir(ident);
        return identificadorTO;
    }

    public IdentificadorProprioConvenenteServicoDAO getIdentificadorProprioConvenenteServicoDAO() {
        return this.identificadorProprioConvenenteServicoDAO;
    }

    public void setIdentificadorProprioConvenenteServicoDAO(IdentificadorProprioConvenenteServicoDAO identificadorProprioConvenenteServicoDAO) {
        this.identificadorProprioConvenenteServicoDAO = identificadorProprioConvenenteServicoDAO;
    }

    private void atualizaConvenenteDaSessao(ConvenenteTODecorator convenenteTOSelecionado) {
        ConvenenteTO convenenteDB = this.getConvenenteDAO().listar(convenenteTOSelecionado.getConvenente());
        convenenteTOSelecionado.setConvenente(convenenteDB);
        if (convenenteDB.getCodigoPessoaConvenente().equals(this.getFabricaDeControladorDeAcesso().novoPluginControladorDeAcesso().getConvenenteTO().getCodigoPessoaConvenente())) {
            this.getFabricaDeControladorDeAcesso().novoPluginControladorDeAcesso().setConvenenteTO(convenenteDB);
            this.getFabricaDeControladorDeAcesso().novoPluginControladorDeAcesso().atualizaServico(this.getServicoAtual());
        }
    }

    private String removeMascara(String valor) {
        String resultado = valor;
        if (!UtilString.isVazio(valor)) {
            resultado = UtilString.substituirString(valor, "-", "");
        }
        return resultado;
    }

    private Collection<TipoDocumentoTO> getColecaoDeTipoDocumentoDeCPFeCNPJ() {
        return UtilDominioTipoDocumento.getColecaoDeTipoDocumentoDeCPFeCNPJ();
    }

    public LogradouroDAO getLogradouroDAO() {
        return this.logradouroDAO;
    }

    public void setLogradouroDAO(LogradouroDAO logradouroDAO) {
        this.logradouroDAO = logradouroDAO;
    }

    public PessoaDAO getPessoaDAO() {
        return this.pessoaDAO;
    }

    public void setPessoaDAO(PessoaDAO pessoaDAO) {
        this.pessoaDAO = pessoaDAO;
    }

    public IdentificadorDAO getIdentificadorDAO() {
        return this.identificadorDAO;
    }

    public void setIdentificadorDAO(IdentificadorDAO identificadorDAO) {
        this.identificadorDAO = identificadorDAO;
    }

    public TipoDocumentoDAO getTipoDocumentoDAO() {
        return this.tipoDocumentoDAO;
    }

    public void setTipoDocumentoDAO(TipoDocumentoDAO tipoDocumentoDAO) {
        this.tipoDocumentoDAO = tipoDocumentoDAO;
    }

    public ServicoTipoDocumentoDAO getServicoTipoDocumentoDAO() {
        return this.servicoTipoDocumentoDAO;
    }

    public void setServicoTipoDocumentoDAO(ServicoTipoDocumentoDAO servicoTipoDocumentoDAO) {
        this.servicoTipoDocumentoDAO = servicoTipoDocumentoDAO;
    }

    public boolean verificaConveniosConvenente(ConvenenteTODecorator convenente) {
        boolean resultado = false;
        if (convenente == null) {
            return false;
        }
        return this.verificaConveniosConvenente(convenente.getConvenente());
    }

    public boolean verificaConveniosConvenente(ConvenenteTO convenente) {
        if (convenente == null) {
            return false;
        }
        return this.getConvenenteDAO().isExisteConvenio(convenente, this.getServicoAtual());
    }

    private boolean existeOutroServicoConvenente(ConvenenteTO convenente) {
        ServicoConvenenteTOId servicoConvenenteTOId = this.getFabricaDeTO().novoServicoConvenenteTOId();
        servicoConvenenteTOId.setCodigoPessoaConvenente(convenente.getCodigoPessoaConvenente());
        servicoConvenenteTOId.setTextoIdentificadorServico(this.getServicoAtual());
        return this.getServicoConvenenteDAO().isExisteOutroServicoConvenente(servicoConvenenteTOId);
    }

    private void excluirAssociacaoServicoConvenente(ConvenenteTO convenente) {
        ServicoConvenenteTOId servicoConvenenteTOId = this.getFabricaDeTO().novoServicoConvenenteTOId();
        servicoConvenenteTOId.setCodigoPessoaConvenente(convenente.getCodigoPessoaConvenente());
        servicoConvenenteTOId.setTextoIdentificadorServico(this.getServicoAtual());
        this.getServicoConvenenteDAO().excluir(servicoConvenenteTOId);
    }

    public void setServicoConvenenteDAO(ServicoConvenenteDAO servicoConvenenteDAO) {
        this.servicoConvenenteDAO = servicoConvenenteDAO;
    }

    public ServicoConvenenteDAO getServicoConvenenteDAO() {
        return this.servicoConvenenteDAO;
    }
}

