/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.apresentacao.mantercontacorrentecliente.form.ManterContaCorrenteForm;
import br.com.bb.plugins.gac.integracao.dao.AgenciaInstituicaoFinanceiraDAO;
import br.com.bb.plugins.gac.integracao.dao.ContaCorrenteClienteDAO;
import br.com.bb.plugins.gac.integracao.dao.InstituicaoFinanceiraDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.AgenciaInstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTO;
import br.com.bb.plugins.gac.negocio.to.InstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.decorator.InstituicaoFinanceiraTODecorator;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManterInstituicaoFinanceiraModel
extends PluginModelAbstrato {
    private InstituicaoFinanceiraDAO instituicaoFinanceiraDAO;
    private AgenciaInstituicaoFinanceiraDAO agenciaInstituicaoFinanceiraDAO;
    private ContaCorrenteClienteDAO contaCorrenteClienteDAO;

    public AgenciaInstituicaoFinanceiraDAO getAgenciaInstituicaoFinanceiraDAO() {
        return this.agenciaInstituicaoFinanceiraDAO;
    }

    public void setAgenciaInstituicaoFinanceiraDAO(AgenciaInstituicaoFinanceiraDAO agenciaInstituicaoFinanceiraDAO) {
        this.agenciaInstituicaoFinanceiraDAO = agenciaInstituicaoFinanceiraDAO;
    }

    public PaginadorTO listar(InstituicaoFinanceiraTODecorator to) {
        return this.getInstituicaoFinanceiraDAO().consultarInstituicaoFinanceira(to);
    }

    public InstituicaoFinanceiraTO incluir(InstituicaoFinanceiraTODecorator to) {
        InstituicaoFinanceiraTO instituicaoFinanceiraTO = this.getFabricaDeTO().novoInstituicaoFinanceiraTO();
        InstituicaoFinanceiraTO resultado = null;
        boolean existeInstituicao = false;
        instituicaoFinanceiraTO.setCodigoInstituicaoFinanceira(to.getCodigoInstituicaoFinanceira());
        existeInstituicao = this.getInstituicaoFinanceiraDAO().isExisteRegistro(instituicaoFinanceiraTO);
        if (!existeInstituicao) {
            to.setIndicadorEstadoInstituicaoFinanceira(Character.valueOf(Character.forDigit(1, 36)));
            resultado = this.getInstituicaoFinanceiraDAO().incluir(to.getInstituicaoFinanceiraTO());
        }
        return resultado;
    }

    public boolean excluir(InstituicaoFinanceiraTODecorator to) {
        boolean resultado = false;
        AgenciaInstituicaoFinanceiraTO agenciaInstituicaoFinanceiraTO = this.getFabricaDeTO().novaAgenciaInstituicaoFinanceiraTO(to.getInstituicaoFinanceiraTO());
        resultado = this.getAgenciaInstituicaoFinanceiraDAO().isExisteAgenciaParaInstistituicao(agenciaInstituicaoFinanceiraTO);
        if (!resultado && !(resultado = this.getContaCorrenteClienteDAO().isExisteInstistituicaoFinanceira(to.getCodigoInstituicaoFinanceira()))) {
            this.getInstituicaoFinanceiraDAO().excluir(to.getInstituicaoFinanceiraTO());
        }
        return !resultado;
    }

    public void editar(InstituicaoFinanceiraTODecorator to) {
        to.setIndicadorEstadoInstituicaoFinanceira(Character.valueOf(Character.forDigit(1, 36)));
        this.getInstituicaoFinanceiraDAO().alterar(to.getInstituicaoFinanceiraTO());
    }

    public InstituicaoFinanceiraDAO getInstituicaoFinanceiraDAO() {
        return this.instituicaoFinanceiraDAO;
    }

    public ContaCorrenteClienteDAO getContaCorrenteClienteDAO() {
        return this.contaCorrenteClienteDAO;
    }

    public void setContaCorrenteClienteDAO(ContaCorrenteClienteDAO contaCorrenteClienteDAO) {
        this.contaCorrenteClienteDAO = contaCorrenteClienteDAO;
    }

    public void setInstituicaoFinanceiraDAO(InstituicaoFinanceiraDAO instituicaoFinanceiraDAO) {
        this.instituicaoFinanceiraDAO = instituicaoFinanceiraDAO;
    }

    public Collection<InstituicaoFinanceiraTO> listarInstituicoesFinanceiras() {
        return this.getInstituicaoFinanceiraDAO().listarInstituicoesFinanceiras();
    }

    public Collection<AgenciaInstituicaoFinanceiraTO> listarAgenciasParaInstituicaoFinanceira(InstituicaoFinanceiraTO instituicaoFinanceiraTO) {
        return this.getAgenciaInstituicaoFinanceiraDAO().consultarPorCodigoBanco(instituicaoFinanceiraTO.getCodigoInstituicaoFinanceira());
    }

    public void alterarContaCorrente(ManterContaCorrenteForm form) {
        ContaCorrenteClienteTO contaCorrenteTO = form.getContaCorrenteClienteTODecorator().getContaCorrenteClienteTO();
        try {
            this.getContaCorrenteClienteDAO().alterar(contaCorrenteTO);
            form.setTipoDeMensagem(1);
            form.setMensagem("Conta alterada com sucesso!");
        }
        catch (Exception e) {
            form.setTipoDeMensagem(0);
            form.setMensagem("Erro ao alterar conta!");
            e.printStackTrace();
        }
    }
}

