/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.ModelFactory;
import br.com.bb.plugins.gac.negocio.model.ConfigurarScannerModel;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.DominioTO;
import br.com.bb.plugins.gac.negocio.to.decorator.PerifericoTODecorator;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.politec.generico.arquivo.UtilArquivo;
import br.com.politec.generico.string.UtilString;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Properties;

public class ManterPerifericoModel
extends PluginModelAbstrato {
    private static final String CABECALHO = "[CMC7CX]";

    public PerifericoTODecorator recuperaPeriferico() throws BBException {
        PerifericoTODecorator perifericoTODecorator = this.getFabricaDeTO().novoPerifericoTODecorator();
        File file = new File(this.getCaminhoArquivo());
        if (file.exists()) {
            perifericoTODecorator.setPortaComunicacao(this.getValorPropertie("Port"));
            perifericoTODecorator.setVelocidade(this.getValorPropertie("Velocidade"));
            perifericoTODecorator.setTamanhoPalavra(this.getValorPropertie("Tamanho"));
            perifericoTODecorator.setStopBits(this.getValorPropertie("StopBits"));
            perifericoTODecorator.setParidade(this.getValorPropertie("Paridade"));
            perifericoTODecorator.setProtocolo(this.getValorPropertie("Modelo"));
        } else {
            try {
                FileWriter fileWriter = new FileWriter(file);
            }
            catch (IOException e) {
                System.out.println(this.getCaminhoArquivo());
                e.printStackTrace();
                throw new BBException("MI051");
            }
        }
        return perifericoTODecorator;
    }

    private String getValorPropertie(String propriedade) {
        return UtilString.getString(this.getArquivoProperties().get(propriedade));
    }

    public Properties getArquivoProperties() {
        return UtilArquivo.getProperties(this.getCaminhoArquivo());
    }

    private String getCaminhoArquivo() {
        return String.valueOf(ConfiguracaoProperties.getConfiguracaoProperties().getDirProg()) + "/Periferico.ini";
    }

    public void incluirInformacoesPeriferico(PerifericoTODecorator perifericoTODecorator) throws BBException {
        try {
            this.gravarArquivoConfiguracaoPeriferico(perifericoTODecorator);
        }
        catch (FileNotFoundException e) {
            System.out.println(this.getCaminhoArquivo());
            e.printStackTrace();
            throw new BBException("MI051");
        }
        catch (IOException e) {
            System.out.println(this.getCaminhoArquivo());
            e.printStackTrace();
            throw new BBException("MI051");
        }
    }

    private void gravarArquivoConfiguracaoPeriferico(PerifericoTODecorator perifericoTODecorator) throws FileNotFoundException, IOException, BBException {
        DominioTO scannerTO = this.getConfigurarScannerModel().recuperaScanner();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.getCaminhoArquivo())));
        this.popula(bufferedWriter, perifericoTODecorator);
        this.getConfigurarScannerModel().popula(bufferedWriter, scannerTO);
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    public void popula(BufferedWriter bufferedWriter, PerifericoTODecorator perifericoTODecorator) throws IOException {
        bufferedWriter.write(CABECALHO);
        bufferedWriter.newLine();
        bufferedWriter.write("Port=" + perifericoTODecorator.getPortaComunicacao());
        bufferedWriter.newLine();
        bufferedWriter.write("Modelo=" + perifericoTODecorator.getProtocolo());
        bufferedWriter.newLine();
        bufferedWriter.write("Velocidade=" + perifericoTODecorator.getVelocidade());
        bufferedWriter.newLine();
        bufferedWriter.write("Tamanho=" + perifericoTODecorator.getTamanhoPalavra());
        bufferedWriter.newLine();
        bufferedWriter.write("StopBits=" + perifericoTODecorator.getStopBits());
        bufferedWriter.newLine();
        bufferedWriter.write("Paridade=" + (perifericoTODecorator.getParidade() == null ? "" : perifericoTODecorator.getParidade().toUpperCase()));
        bufferedWriter.newLine();
    }

    public ConfigurarScannerModel getConfigurarScannerModel() {
        return ModelFactory.getInstancia().novoConfigurarScannerModel();
    }
}

