/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.ArquivoFactory;
import br.com.bb.plugins.gac.integracao.dao.TipoSegmentoDAO;
import br.com.bb.plugins.gac.negocio.facade.ManterArquivoRetornoFacade;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.decorator.RetornoTODecorator;
import br.com.bb.plugins.gac.util.UtilArquivoConfiguracao;
import br.com.bb.plugins.gac.util.controller.view.ApplicationContextFactory;
import br.com.bb.plugins.gac.util.controller.view.Plugin;
import br.com.bb.plugins.gac.util.controller.view.PluginController;
import br.com.bb.plugins.gac.util.parserarquivo.IParserArquivo;
import br.com.bb.plugins.gac.util.parserarquivo.IParserArquivoFactory;
import br.com.bb.plugins.gac.util.parserarquivo.ParserArquivoFactory;
import br.com.politec.generico.string.UtilString;
import br.com.politec.infra.util.UtilLog;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManterRetornosPendentesModel
extends PluginModelAbstrato {
    private TipoSegmentoDAO tipoSegmentoDAO;
    private String cabecalho;
    private Hashtable<String, ManterArquivoRetornoFacade> facades;

    public String getCabecalho() {
        return this.cabecalho;
    }

    public void setCabecalho(String cabecalho) {
        this.cabecalho = cabecalho;
    }

    public List<RetornoTODecorator> consultarServicos() throws BBException {
        List<Plugin> servicosSegmentoSelecionado = this.recuperaServicosInstalados();
        File[] listaArquivosPastaRetorno = this.recuperaArquivosDeRetorno();
        return this.recuperaArquivosRetorno(servicosSegmentoSelecionado, listaArquivosPastaRetorno);
    }

    private List<RetornoTODecorator> recuperaArquivosRetorno(List<Plugin> servicosSegmento, File[] listaArquivosPastaRetorno) throws BBException {
        List listaRetorno = this.getColecaoFactory().novoArrayList();
        Iterator<Plugin> iterator = servicosSegmento.iterator();
        IParserArquivoFactory factory = ParserArquivoFactory.getInstancia();
        String nomeServicoArquivo = "";
        while (iterator.hasNext()) {
            Plugin plugin = iterator.next();
            int i = 0;
            while (i < listaArquivosPastaRetorno.length) {
                File arquivo = listaArquivosPastaRetorno[i];
                IParserArquivo parser = factory.novoParserArquivo(arquivo);
                String valorCabecalho = parser.getValorDoCabecalhoString("Debito");
                if (valorCabecalho != null && this.isArquivoTipoRetorno(nomeServicoArquivo = this.subString(valorCabecalho, 0, 3), plugin.getNome())) {
                    this.populaRetornoTO(arquivo, listaRetorno, plugin, parser);
                }
                ++i;
            }
        }
        return listaRetorno;
    }

    private void populaRetornoTO(File arquivo, List<RetornoTODecorator> listaRetorno, Plugin plugin, IParserArquivo parser) throws BBException {
        RetornoTODecorator retornoTO = new RetornoTODecorator();
        retornoTO.setNomeArquivo(this.getNomeArquivo(arquivo));
        retornoTO.setNumeroConvenio(new Integer(parser.getValorDoCabecalhoString("Convenio")));
        Integer identificadorRetorno = parser.getValorDoCabecalhoInteger("SequencialArq");
        retornoTO.setNumeroIdentificadorRetorno(identificadorRetorno);
        if (plugin.getNome().equalsIgnoreCase("DBT")) {
            retornoTO.setNumeroProcesso("");
        }
        retornoTO.setDataProcessamentoRetorno(parser.getValorDoCabecalhoDate("DataArq"));
        retornoTO.setTipoRetorno(plugin.getTitulo());
        retornoTO.setTipoSegmento(Integer.parseInt(plugin.getTipoSegmento()));
        retornoTO.setTextoIdentificadorServico(plugin.getNome());
        listaRetorno.add(retornoTO);
    }

    private String getNomeArquivo(File file) {
        String f = file.getName();
        return f.substring(0, f.lastIndexOf(46));
    }

    private boolean isArquivoTipoRetorno(String nomeServicoArquivo, String nomeServicoInstalado) {
        return nomeServicoArquivo.equalsIgnoreCase(nomeServicoInstalado);
    }

    private String subString(String string, int inicio, int fim) {
        return UtilString.substring(string, inicio, fim);
    }

    private List<Plugin> recuperaServicosInstalados() {
        return PluginController.getInstance().getPlugins();
    }

    private File[] recuperaArquivosDeRetorno() {
        File arquivosDiretorio = this.getArquivoFactory().novoFile(this.getPathDiretorioRetorno());
        File[] listaArquivos = arquivosDiretorio.listFiles();
        return listaArquivos;
    }

    @Override
    protected ArquivoFactory getArquivoFactory() {
        return ArquivoFactory.getInstancia();
    }

    private String getPathDiretorioRetorno() {
        return UtilArquivoConfiguracao.getInstancia().getValorPropertie("diretorio.retorno");
    }

    public TipoSegmentoDAO getTipoSegmentoDAO() {
        return this.tipoSegmentoDAO;
    }

    public void setTipoSegmentoDAO(TipoSegmentoDAO tipoSegmentoDAO) {
        this.tipoSegmentoDAO = tipoSegmentoDAO;
    }

    public void processarRetorno(List<RetornoTODecorator> retornos) throws BBException {
        Plugin plugin = null;
        ManterArquivoRetornoFacade facade = null;
        for (RetornoTODecorator retornoTODecorator : retornos) {
            plugin = PluginController.getPlugin(retornoTODecorator.getServicoTO().getTextoIdentificadorServico());
            facade = this.getManterArquivoRetornoFacade(plugin);
            if (facade == null) continue;
            facade.processarArquivoRetorno(retornoTODecorator);
        }
    }

    private ManterArquivoRetornoFacade getManterArquivoRetornoFacade(Plugin plugin) throws BBException {
        ManterArquivoRetornoFacade retorno = null;
        String nomeClasse = null;
        try {
            nomeClasse = plugin.getIdBeanRetorno();
            retorno = this.getFacades().get(nomeClasse);
            if (retorno == null) {
                retorno = (ManterArquivoRetornoFacade)this.getApplicationContext().getBean(nomeClasse);
                this.getFacades().put(nomeClasse, retorno);
            }
        }
        catch (Exception e) {
            UtilLog.getLog().debug(e);
            throw new BBException("MI054", plugin.getTitulo());
        }
        return retorno;
    }

    private Hashtable<String, ManterArquivoRetornoFacade> getFacades() {
        if (this.facades == null) {
            this.facades = new Hashtable();
        }
        return this.facades;
    }

    private ApplicationContext getApplicationContext() {
        return ApplicationContextFactory.getInstance().getApplicationContext();
    }
}

