/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.decorator.DiretoriosTODecorator;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.bb.plugins.gac.util.UtilArquivoConfiguracao;
import br.com.bb.plugins.gac.util.constante.Excecao;
import java.io.File;
import org.apache.commons.lang.BooleanUtils;

public class MapearDiretorioModel
extends PluginModelAbstrato {
    private DiretoriosTODecorator diretoriosTO;

    public void mapear(DiretoriosTODecorator diretoriosTO) throws BBException {
        this.setDiretoriosTO(diretoriosTO);
        this.validaDadosDiretoriosPreenchidos();
        this.armazenaMapeamentoDiretorios();
    }

    private void armazenaMapeamentoDiretorios() throws BBException {
        this.getUtilArquivoConfiguracao().setValor("diretorio.transmitidos", this.getDiretoriosTO().getAplicativoTransmissao());
        this.getUtilArquivoConfiguracao().setValor("diretorio.processados", this.getDiretoriosTO().getAplicativoProcessado());
        this.getUtilArquivoConfiguracao().setValor("diretorio.aasp", this.getDiretoriosTO().getEnderecoDoAASP());
        this.getUtilArquivoConfiguracao().setValor("diretorio.contratos", this.getDiretoriosTO().getGeracaoArquivosContrato());
        this.getUtilArquivoConfiguracao().setValor("diretorio.remessa", this.getDiretoriosTO().getGeracaoArquivosRemessa(true));
        this.getUtilArquivoConfiguracao().setValor("diretorio.remessa.padrao", String.valueOf(BooleanUtils.toInteger(this.getDiretoriosTO().isGeracaoArquivosRemessaPadrao())));
        this.getUtilArquivoConfiguracao().setValor("diretorio.gefin", this.getDiretoriosTO().getGerenciadorFinanceiro());
        this.getUtilArquivoConfiguracao().setValor("diretorio.retorno", this.getDiretoriosTO().getProcessamentoArquivosRetorno(true));
        this.getUtilArquivoConfiguracao().setValor("diretorio.retorno.padrao", String.valueOf(BooleanUtils.toInteger(this.getDiretoriosTO().isProcessamentoArquivosRetornoPadrao())));
        this.getUtilArquivoConfiguracao().setValor("diretorio.copiaseguranca", this.getDiretoriosTO().getDiretorioPadraoBackup());
        this.getUtilArquivoConfiguracao().salvar();
    }

    private void validaDadosDiretoriosPreenchidos() throws BBException {
        this.verificaExistePastaAplicativoTransmissao();
        this.verificaExistePastaAplicativoProcessado();
        this.verificaExistePastaEnderecoDoAASP();
        this.verificaExistePastaArquivosContrato();
        this.verificaExistePastaArquivosRemessa();
        this.verificaExistePastaGerenciadorFinanceiro();
        this.verificaExistePastaProcessamentoArquivosRetorno();
        this.verificaExistePastaPadraoBackup();
    }

    private void verificaExistePastaAplicativoProcessado() throws BBException {
        this.getDiretoriosTO().setAplicativoProcessado(this.verificaExistePasta(this.getDiretoriosTO().getAplicativoProcessado()));
    }

    private void verificaExistePastaProcessamentoArquivosRetorno() throws BBException {
        this.getDiretoriosTO().setProcessamentoArquivosRetorno(this.verificaExistePasta(this.getDiretoriosTO().getProcessamentoArquivosRetorno(true)));
    }

    private void verificaExistePastaGerenciadorFinanceiro() throws BBException {
        this.getDiretoriosTO().setGerenciadorFinanceiro(this.verificaExistePasta(this.getDiretoriosTO().getGerenciadorFinanceiro()));
    }

    private void verificaExistePastaArquivosRemessa() throws BBException {
        this.getDiretoriosTO().setGeracaoArquivosRemessa(this.verificaExistePasta(this.getDiretoriosTO().getGeracaoArquivosRemessa(true)));
    }

    private void verificaExistePastaArquivosContrato() throws BBException {
        this.getDiretoriosTO().setGeracaoArquivosContrato(this.verificaExistePasta(this.getDiretoriosTO().getGeracaoArquivosContrato()));
    }

    private void verificaExistePastaEnderecoDoAASP() throws BBException {
        this.getDiretoriosTO().setEnderecoDoAASP(this.verificaExistePasta(this.getDiretoriosTO().getEnderecoDoAASP()));
    }

    private void verificaExistePastaPadraoBackup() throws BBException {
        this.getDiretoriosTO().setDiretorioPadraoBackup(this.verificaExistePasta(this.getDiretoriosTO().getDiretorioPadraoBackup()));
    }

    private void verificaExistePastaAplicativoTransmissao() throws BBException {
        this.getDiretoriosTO().setAplicativoTransmissao(this.verificaExistePasta(this.getDiretoriosTO().getAplicativoTransmissao()));
    }

    private String verificaExistePasta(String pasta) throws BBException {
        if (pasta == null || pasta.trim().length() == 0) {
            return "";
        }
        File file = new File(pasta);
        if (!file.isDirectory()) {
            this.criarDiretorio(file);
        }
        pasta = file.getAbsolutePath();
        return pasta;
    }

    private void criarDiretorio(File file) throws BBException {
        if (!file.mkdirs()) {
            throw new BBException(Excecao.getErroDeSistema(), "Voc\u00ea n\u00e3o tem permiss\u00e3o para criar a pasta " + file.getAbsolutePath());
        }
    }

    private UtilArquivoConfiguracao getUtilArquivoConfiguracao() {
        return UtilArquivoConfiguracao.getInstancia();
    }

    public DiretoriosTODecorator getDiretoriosTO() {
        return this.diretoriosTO;
    }

    public void setDiretoriosTO(DiretoriosTODecorator diretoriosTO) {
        this.diretoriosTO = diretoriosTO;
    }

    public DiretoriosTODecorator recuperarDiretorios() {
        DiretoriosTODecorator diretoriosRetorno = this.getFabricaDeTO().novoDiretoriosTODecorator();
        UtilArquivoConfiguracao util = this.getUtilArquivoConfiguracao();
        diretoriosRetorno.setGeracaoArquivosContrato(util.getValorPropertie("diretorio.contratos"));
        diretoriosRetorno.setAplicativoTransmissao(util.getValorPropertie("diretorio.transmitidos"));
        diretoriosRetorno.setAplicativoProcessado(util.getValorPropertie("diretorio.processados"));
        diretoriosRetorno.setEnderecoDoAASP(util.getValorPropertie("diretorio.aasp"));
        diretoriosRetorno.setGeracaoArquivosRemessa(util.getValorPropertie("diretorio.remessa"));
        if (util.getValorPropertie("diretorio.remessa.padrao") != null) {
            diretoriosRetorno.setGeracaoArquivosRemessaPadrao(BooleanUtils.toBoolean(util.getValorPropertie("diretorio.remessa.padrao"), "1", "0"));
        } else {
            diretoriosRetorno.setGeracaoArquivosRemessaPadrao(true);
        }
        diretoriosRetorno.setGerenciadorFinanceiro(util.getValorPropertie("diretorio.gefin"));
        diretoriosRetorno.setProcessamentoArquivosRetorno(util.getValorPropertie("diretorio.retorno"));
        if (util.getValorPropertie("diretorio.retorno.padrao") != null) {
            diretoriosRetorno.setProcessamentoArquivosRetornoPadrao(BooleanUtils.toBoolean(util.getValorPropertie("diretorio.retorno.padrao"), "1", "0"));
        } else {
            diretoriosRetorno.setProcessamentoArquivosRetornoPadrao(true);
        }
        diretoriosRetorno.setDiretorioPadraoBackup(util.getValorPropertie("diretorio.copiaseguranca"));
        return diretoriosRetorno;
    }

    public DiretoriosTODecorator restaurarDiretorios() {
        DiretoriosTODecorator diretoriosRetorno = this.getFabricaDeTO().novoDiretoriosTODecorator();
        UtilArquivoConfiguracao util = this.getUtilArquivoConfiguracao();
        diretoriosRetorno.setGeracaoArquivosContrato(util.getValorPropertie("diretorio.contpadrao"));
        diretoriosRetorno.setAplicativoTransmissao(util.getValorPropertie("diretorio.transpadrao"));
        diretoriosRetorno.setAplicativoProcessado(util.getValorPropertie("diretorio.processpadrao"));
        diretoriosRetorno.setEnderecoDoAASP(util.getValorPropertie("diretorio.aasppadrao"));
        diretoriosRetorno.setGeracaoArquivosRemessa(util.getValorPropertie("diretorio.rempadrao"));
        diretoriosRetorno.setGerenciadorFinanceiro(util.getValorPropertie("diretorio.gefinpadrao"));
        diretoriosRetorno.setProcessamentoArquivosRetorno(util.getValorPropertie("diretorio.retpadrao"));
        diretoriosRetorno.setDiretorioPadraoBackup(util.getValorPropertie("diretorio.copiaseguranca"));
        return diretoriosRetorno;
    }

    public boolean arquivoEncontradoNormal() throws BBException {
        return this.getConfiguracaoProperties().arquivoEncontradoNormal();
    }

    public ConfiguracaoProperties getConfiguracaoProperties() {
        return ConfiguracaoProperties.getConfiguracaoProperties();
    }

    public boolean validaSeExisteDiretorios() throws BBException {
        return this.existePastaAplicativoTransmissao() && this.existePastaAplicativoProcessado() && this.existePastaEnderecoDoAASP() && this.existePastaArquivosContrato() && this.existePastaArquivosRemessa() && this.existePastaGerenciadorFinanceiro() && this.existePastaProcessamentoArquivosRetorno() && this.existePastaPadraoBackup();
    }

    private boolean existePastaAplicativoProcessado() throws BBException {
        return this.existePasta(this.getDiretoriosTO().getAplicativoProcessado());
    }

    private boolean existePastaPadraoBackup() throws BBException {
        return this.existePasta(this.getDiretoriosTO().getDiretorioPadraoBackup());
    }

    private boolean existePastaProcessamentoArquivosRetorno() throws BBException {
        return this.existePasta(this.getDiretoriosTO().getProcessamentoArquivosRetorno(true));
    }

    private boolean existePastaGerenciadorFinanceiro() throws BBException {
        return this.existePasta(this.getDiretoriosTO().getGerenciadorFinanceiro());
    }

    private boolean existePastaArquivosRemessa() throws BBException {
        return this.existePasta(this.getDiretoriosTO().getGeracaoArquivosRemessa(true));
    }

    private boolean existePastaArquivosContrato() throws BBException {
        return this.existePasta(this.getDiretoriosTO().getGeracaoArquivosContrato());
    }

    private boolean existePastaEnderecoDoAASP() throws BBException {
        return this.existePasta(this.getDiretoriosTO().getEnderecoDoAASP());
    }

    private boolean existePastaAplicativoTransmissao() throws BBException {
        return this.existePasta(this.getDiretoriosTO().getAplicativoTransmissao());
    }

    private boolean existePasta(String pasta) throws BBException {
        if (pasta == null || pasta.trim().length() == 0) {
            throw new BBException();
        }
        File file = new File(pasta);
        if (!file.isDirectory()) {
            throw new BBException();
        }
        return true;
    }
}

