/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.ArquivoFactory;
import br.com.bb.plugins.gac.integracao.dao.ControleCopiaSegurancaDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.ControleCopiaSegurancaTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ControleCopiaSegurancaTODecorator;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.bb.plugins.gac.util.UtilArquivoConfiguracao;
import br.com.bb.plugins.gac.util.UtilBBException;
import br.com.bb.plugins.gac.util.UtilNotificador;
import br.com.politec.generico.formatador.UtilFormatadorDeData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecuperarCopiaSegurancaModel
extends PluginModelAbstrato {
    private ControleCopiaSegurancaDAO controleCopiaSegurancaDAO;

    public void recuperar(ControleCopiaSegurancaTODecorator controleCopiaSegurancaTODecorator) throws BBException {
        String diretorio = this.getUtilArquivoConfiguracao().getValorPropertie("diretorio.banco");
        if (!(diretorio = diretorio.replaceAll("\\\\", "/")).endsWith("/")) {
            diretorio = String.valueOf(diretorio) + "/";
        }
        String nomeNovoArquivo = this.getNomeArquivoBancoDadosRestaurado();
        this.copiarArquivo(String.valueOf(controleCopiaSegurancaTODecorator.getTextoNomeDiretorioArquivo()) + "\\" + controleCopiaSegurancaTODecorator.getTextoNomeArquivoCopiaSeguranca(), String.valueOf(diretorio) + nomeNovoArquivo, controleCopiaSegurancaTODecorator);
        this.alterar(controleCopiaSegurancaTODecorator);
        ConfiguracaoProperties.getConfiguracaoProperties().setBancoRestaurar(nomeNovoArquivo);
        ConfiguracaoProperties.getConfiguracaoProperties().salvaPropriedades();
    }

    public void alterar(ControleCopiaSegurancaTODecorator to) {
        ControleCopiaSegurancaTO toControle = this.getControleCopiaSegurancaDAO().listar(to.getControleCopiaSegurancaTO());
        toControle.setDataRecuperacao(Calendar.getInstance().getTime());
        toControle.setTextoNomeArquivoRecuperado(to.getTextoNomeArquivoRecuperado());
        this.getControleCopiaSegurancaDAO().alterar(toControle);
    }

    protected void copiarArquivo(String origem, String destino, ControleCopiaSegurancaTODecorator to) throws BBException {
        File fileOrigem = this.getArquivoFactory().novoFile(origem);
        File fileDestino = this.getArquivoFactory().novoFile(destino);
        FileChannel inChannel = null;
        AbstractInterruptibleChannel outChannel = null;
        try {
            try {
                inChannel = new FileInputStream(fileOrigem).getChannel();
                outChannel = new FileOutputStream(fileDestino).getChannel();
                int maxCount = 1024;
                long size = inChannel.size();
                long position = 0L;
                while (position < size) {
                    position += inChannel.transferTo(position, maxCount, (WritableByteChannel)((Object)outChannel));
                    this.atualizaPorcentagem(to.getNotificaCopiaSeguranca(), size, position);
                }
            }
            catch (FileNotFoundException e) {
                throw UtilBBException.getErroDeSistema(e);
            }
            catch (IOException e) {
                throw UtilBBException.getErroDeSistema(e);
            }
        }
        finally {
            try {
                if (inChannel != null) {
                    inChannel.close();
                }
                if (outChannel != null) {
                    outChannel.close();
                }
            }
            catch (IOException e) {
                throw UtilBBException.getErroDeSistema(e);
            }
        }
    }

    public boolean isInstalacaoCompartilhada() {
        String valor = this.getUtilArquivoConfiguracao().getValorPropertie("hibernate.tipoinstalacaobancodados");
        return valor.equals(String.valueOf(0));
    }

    protected void renomeiaArquivo(String arquivoAtual, String novoNomeArquivo) {
        File arquivoBanco = this.getArquivoFactory().novoFile(arquivoAtual);
        File arquivoBancoRenomeado = this.getArquivoFactory().novoFile(novoNomeArquivo);
        arquivoBanco.renameTo(arquivoBancoRenomeado);
    }

    private String getNomeArquivoBancoDadosRestaurado() {
        return "BBGACA" + UtilFormatadorDeData.formatar(Calendar.getInstance().getTime(), "yyyyMMdd_hhmmss") + ".BBR";
    }

    private void atualizaPorcentagem(UtilNotificador notificaCopiaSeguranca, long tamanhoTotal, long tamanhoAtual) {
        long porcentagem = tamanhoAtual * 100L / tamanhoTotal;
        notificaCopiaSeguranca.notifyObservers(porcentagem);
    }

    public PaginadorTO listar(ControleCopiaSegurancaTODecorator to) {
        PaginadorTO paginadorTO = this.getControleCopiaSegurancaDAO().cosultarTodos(to);
        Collection colecao = paginadorTO.getColecaoDeRegistros();
        this.verficaExistenciaArquivo(colecao);
        return paginadorTO;
    }

    public PaginadorTO listarDescendente(ControleCopiaSegurancaTODecorator to) {
        PaginadorTO paginadorTO = this.getControleCopiaSegurancaDAO().cosultarTodosDescendente(to);
        Collection colecao = paginadorTO.getColecaoDeRegistros();
        this.verficaExistenciaArquivo(colecao);
        return paginadorTO;
    }

    private void verficaExistenciaArquivo(Collection<ControleCopiaSegurancaTO> colecaoDeRegistros) {
        ArrayList<ControleCopiaSegurancaTO> colecao = new ArrayList<ControleCopiaSegurancaTO>(1);
        for (ControleCopiaSegurancaTO to : colecaoDeRegistros) {
            boolean existeFisicamente = this.isExisteArquivoFisico(to);
            if (existeFisicamente) continue;
            colecao.add(to);
        }
        colecaoDeRegistros.removeAll(colecao);
    }

    private boolean isExisteArquivoFisico(ControleCopiaSegurancaTO to) {
        boolean existe = false;
        String diretorio = to.getTextoNomeDiretorioArquivo();
        File arquivo = this.getArquivoFactory().novoFile(String.valueOf(diretorio) + "\\" + to.getTextoNomeArquivoCopiaSeguranca());
        existe = arquivo.isFile();
        return existe;
    }

    @Override
    protected ArquivoFactory getArquivoFactory() {
        return ArquivoFactory.getInstancia();
    }

    protected UtilArquivoConfiguracao getUtilArquivoConfiguracao() {
        return UtilArquivoConfiguracao.getInstancia();
    }

    public ControleCopiaSegurancaDAO getControleCopiaSegurancaDAO() {
        return this.controleCopiaSegurancaDAO;
    }

    public void setControleCopiaSegurancaDAO(ControleCopiaSegurancaDAO controleCopiaSegurancaDAO) {
        this.controleCopiaSegurancaDAO = controleCopiaSegurancaDAO;
    }
}

