/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.RemessaDAO;
import br.com.bb.plugins.gac.negocio.facade.ManterLancamentosRemessaFacade;
import br.com.bb.plugins.gac.negocio.model.ConfigurarExpurgoModel;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.GerarRemessaNegocioDecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.RemessaTODecorator;
import br.com.bb.plugins.gac.util.UtilAbrirBrowserPadrao;
import br.com.bb.plugins.gac.util.controller.view.ApplicationContextFactory;
import br.com.bb.plugins.gac.util.controller.view.Plugin;
import br.com.bb.plugins.gac.util.controller.view.PluginController;
import br.com.bb.plugins.gac.util.ordenacao.ColunaTipoComparator;
import br.com.politec.infra.util.UtilLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemessaModel
extends PluginModelAbstrato {
    private ConfigurarExpurgoModel configurarExpurgoModel;
    private RemessaDAO remessaDAO;

    public RemessaDAO getRemessaDAO() {
        return this.remessaDAO;
    }

    public void setRemessaDAO(RemessaDAO remessaDAO) {
        this.remessaDAO = remessaDAO;
    }

    public ConfigurarExpurgoModel getConfigurarExpurgoModel() {
        return this.configurarExpurgoModel;
    }

    public void setConfigurarExpurgoModel(ConfigurarExpurgoModel configurarExpurgoModel) {
        this.configurarExpurgoModel = configurarExpurgoModel;
    }

    public void remessaGefin() throws BBException {
        UtilAbrirBrowserPadrao.abreURL("https://aapj.bb.com.br/aapj/liemp.bb?codigoTransacao=IED1");
    }

    public void retornoGefin() throws BBException {
        UtilAbrirBrowserPadrao.abreURL("https://aapj.bb.com.br/aapj/liemp.bb?codigoTransacao=IED3&indicadorTransacao=1");
    }

    public void remessaArquivoAASP() throws BBException {
        UtilAbrirBrowserPadrao.abreURL("https://aapj.bb.com.br/aapj/ligov.bb?codigoTransacao=IED1");
    }

    public void retornoArquivoAASP() throws BBException {
        UtilAbrirBrowserPadrao.abreURL("https://aapj.bb.com.br/aapj/ligov.bb?codigoTransacao=IED3&indicadorTransacao=1");
    }

    public void remessaArquivoAAPR() throws BBException {
        UtilAbrirBrowserPadrao.abreURL(" https://aapj.bb.com.br/aapj/loginapr.bb?codigoTransacao=IED1");
    }

    public void retornoArquivoAAPR() throws BBException {
        UtilAbrirBrowserPadrao.abreURL(" https://aapj.bb.com.br/aapj/loginapr.bb?codigoTransacao=IED3&indicadorTransacao=1");
    }

    public void receberArquivoRefazimentoGefin() throws BBException {
        UtilAbrirBrowserPadrao.abreURL("https://aapj.bb.com.br/aapj/liemp.bb?codigoTransacao=IED9");
    }

    public void receberArquivoRefazimentoAASP() throws BBException {
        UtilAbrirBrowserPadrao.abreURL("https://aapj.bb.com.br/aapj/ligov.bb?codigoTransacao=IED9");
    }

    public void receberArquivoRefazimentoAAPR() throws BBException {
        UtilAbrirBrowserPadrao.abreURL("https://aapj.bb.com.br/aapj/loginapr.bb?codigoTransacao=IED9");
    }

    public List<ServicoTO> consultarListaDeServicosTO(List<Plugin> listaDeAplicationsInstalados) {
        return this.getConfigurarExpurgoModel().consultarListaDeServicosTO(listaDeAplicationsInstalados);
    }

    public PaginadorTO consultarRemessasGerar(List<Plugin> listaDeAplicationsFiltrada, RemessaTODecorator remessaTODecorator) throws BBException {
        ManterLancamentosRemessaFacade facade = null;
        ArrayList<RemessaTODecorator> listaBO = new ArrayList<RemessaTODecorator>();
        ColunaTipoComparator comparador = new ColunaTipoComparator(remessaTODecorator.getNomeColunaOrdenada(), remessaTODecorator.getTipoOrdenacao());
        for (Plugin plugin : listaDeAplicationsFiltrada) {
            facade = this.getManterLancamentosRemessaFacade(plugin);
            if (facade == null) continue;
            listaBO.addAll(this.consultarLancamentos(facade, plugin));
        }
        Collections.sort(listaBO, comparador);
        PaginadorTO paginador = this.getRemessaDAO().montarPaginador(listaBO, remessaTODecorator);
        return paginador;
    }

    private ManterLancamentosRemessaFacade getManterLancamentosRemessaFacade(Plugin plugin) throws BBException {
        ManterLancamentosRemessaFacade retorno = null;
        ApplicationContext appContext = ApplicationContextFactory.getInstance().getApplicationContext();
        try {
            retorno = (ManterLancamentosRemessaFacade)appContext.getBean(plugin.getIdBeanRemessa());
        }
        catch (ClassCastException e) {
            UtilLog.getLog().debug(e);
            throw new BBException("MI054", plugin.getTitulo());
        }
        return retorno;
    }

    private List<RemessaTODecorator> consultarLancamentos(ManterLancamentosRemessaFacade facade, Plugin plugin) throws BBException {
        List<RemessaTODecorator> retorno = null;
        try {
            retorno = facade.consultarLancamentosConsolidados();
        }
        catch (Exception e) {
            e.printStackTrace();
            UtilLog.getLog().debug(e);
            throw new BBException("MI054", plugin.getTitulo());
        }
        return retorno;
    }

    public void consultarLancamentosDaRemessa(GerarRemessaNegocioDecorator decorator) throws BBException {
        ManterLancamentosRemessaFacade facade = null;
        try {
            Plugin plugin = PluginController.getPlugin(decorator.getGerarRemessaBO().getServico());
            facade = this.getManterLancamentosRemessaFacade(plugin);
            facade.consultarRecebimentosDaRemessa(decorator);
        }
        catch (Exception e) {
            UtilLog.getLog().debug(e);
            throw new BBException("N\u00e3o foi poss\u00edvel consultar os lan\u00e7amentos da Remessa");
        }
    }

    public void gerarRemessa(GerarRemessaNegocioDecorator decorator) throws BBException {
        ManterLancamentosRemessaFacade facade = null;
        try {
            Plugin plugin = PluginController.getPlugin(decorator.getGerarRemessaBO().getServico());
            facade = this.getManterLancamentosRemessaFacade(plugin);
            facade.gerarRemessa(decorator);
        }
        catch (Exception e) {
            UtilLog.getLog().debug(e);
            throw new BBException("N\u00e3o foi poss\u00edvel gerar a remessa");
        }
    }

    public List<RemessaTODecorator> consultarRemessaPendente(List<Plugin> listaDeAplicationsFiltrada, RemessaTODecorator remessaTODecorator) throws BBException {
        ManterLancamentosRemessaFacade facade = null;
        ArrayList<RemessaTODecorator> listaBO = new ArrayList<RemessaTODecorator>();
        ColunaTipoComparator comparador = new ColunaTipoComparator(remessaTODecorator.getNomeColunaOrdenada(), remessaTODecorator.getTipoOrdenacao());
        for (Plugin plugin : listaDeAplicationsFiltrada) {
            facade = this.getManterLancamentosRemessaFacade(plugin);
            if (facade == null) continue;
            listaBO.addAll(this.consultarRemessaPendente(facade, plugin));
        }
        Collections.sort(listaBO, comparador);
        return listaBO;
    }

    private List<RemessaTODecorator> consultarRemessaPendente(ManterLancamentosRemessaFacade facade, Plugin plugin) throws BBException {
        List<RemessaTODecorator> retorno = null;
        try {
            retorno = facade.consultarRemessaRecuperar(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            UtilLog.getLog().debug(e);
            throw new BBException("MI052", plugin.getTitulo());
        }
        return retorno;
    }

    public void recuperarRemessa(List<RemessaTODecorator> remessas) throws BBException {
        int i = 0;
        for (RemessaTODecorator remessa : remessas) {
            remessa.getRemessaTO().getServicoTO();
            this.recuperarRemessa(remessa);
            remessa.getNotificaRecuperarRemessa().notifyObservers(++i / remessas.size() * 100);
        }
    }

    private void recuperarRemessa(RemessaTODecorator remessa) throws BBException {
        Plugin plugin = PluginController.getPlugin(remessa.getRemessaTO().getServicoTO().getTextoIdentificadorServico());
        ManterLancamentosRemessaFacade facade = this.getManterLancamentosRemessaFacade(plugin);
        try {
            remessa.getListaRemessa().add(remessa);
            facade.recuperarRemessas(remessa);
        }
        catch (ClassCastException e) {
            UtilLog.getLog().debug(e);
            throw new BBException("MI054", plugin.getTitulo());
        }
    }
}

