/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.ContaCorrenteClienteDAO;
import br.com.bb.plugins.gac.integracao.dao.ConvenenteDAO;
import br.com.bb.plugins.gac.integracao.dao.controle.ServicoAplicacaoDAO;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTO;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.controle.ServicoAplicacaoTO;
import br.com.bb.plugins.gac.util.Criptografia;
import br.com.bb.plugins.gac.util.ServicoInfo;
import br.com.bb.plugins.gac.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.jdom.JDOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SenhaMestraModel {
    private ConvenenteDAO convenenteDAO;
    private ContaCorrenteClienteDAO contaCorrenteClienteDAO;
    private ServicoAplicacaoDAO servicoAplicacaoDAO;

    public static String obterChaveMestra(String agencia, String conta) throws JDOMException, IOException {
        GregorianCalendar calendario = new GregorianCalendar();
        if (agencia.charAt(4) == 'X' || agencia.charAt(4) == 'x') {
            agencia = String.valueOf(agencia.substring(0, 4)) + "0";
        }
        String chave_agencia = String.valueOf(agencia) + agencia.substring(2, 3) + agencia.substring(0, 1) + agencia.substring(3, 4) + agencia.substring(1, 2) + agencia.substring(2, 3) + agencia.substring(3, 4) + agencia.substring(3, 4);
        String chave_conta = "";
        try {
            chave_conta = Util.padR(conta, 11, "0");
            if (chave_conta.charAt(10) == 'X' || chave_conta.charAt(10) == 'x') {
                chave_conta = String.valueOf(chave_conta.substring(0, 10)) + "0";
            }
        }
        catch (Throwable t) {
            System.out.println("Erro no m\u00e9todo obterSenhaMestra. Conta = " + conta);
        }
        int dia = calendario.get(5);
        int mes = calendario.get(2) + 1;
        int ano = calendario.get(1);
        String sDia = (dia += (mes += dia)) < 10 ? "0" + dia : String.valueOf(dia);
        String sMes = mes < 10 ? "0" + mes : String.valueOf(mes);
        String parcial = String.valueOf(sDia) + sMes;
        String sAno = String.valueOf(ano += Integer.parseInt(parcial));
        String chave_data = String.valueOf(parcial) + sAno + chave_conta.substring(8);
        String chave_plugin = "";
        String alfanum = "abcdefghijklmnopqrstuvwxyz1234567890";
        String codPlugin = ServicoInfo.getInstance().GetFileInfoGAC().getSigla().toLowerCase();
        int a = 0;
        while (a < codPlugin.length()) {
            int x = alfanum.indexOf(codPlugin.substring(a, a + 1));
            chave_plugin = String.valueOf(chave_plugin) + String.valueOf(x);
            ++a;
        }
        long chaveMestra = Long.parseLong(chave_agencia) + Long.parseLong(chave_conta) + Long.parseLong(chave_data) + Long.parseLong(chave_plugin);
        String input = String.valueOf(chaveMestra);
        if (input.length() > 11) {
            input = input.substring(input.length() - 11);
        }
        return Criptografia.encriptarChave(input);
    }

    public boolean verificarSeChaveMestra(String senha) throws BBException {
        boolean mestra = false;
        if (senha.length() < 11) {
            return false;
        }
        try {
            Collection convenentes = this.getConvenenteDAO().consultar();
            for (ConvenenteTO convenente : convenentes) {
                ContaCorrenteClienteTO contaCorrenteClienteTO = new ContaCorrenteClienteTO();
                contaCorrenteClienteTO.getId().setCodigoContaCorrente(1L);
                contaCorrenteClienteTO.setPessoaTO(new PessoaTO());
                if (convenente.getCodigoPessoaConvenente() <= 400) continue;
                contaCorrenteClienteTO.getPessoaTO().setCodigoPessoa(convenente.getCodigoPessoaConvenente());
                List<ContaCorrenteClienteTO> contasCorrentesClienteTO = this.getContasBancoDoBrasil(this.getContaCorrenteClienteDAO().listarContas(contaCorrenteClienteTO.getPessoaTO()));
                for (ContaCorrenteClienteTO conta : contasCorrentesClienteTO) {
                    String _cc;
                    String cc;
                    String _agencia;
                    String agencia;
                    if (conta.getId() == null || !senha.equalsIgnoreCase(Criptografia.obterChaveMestra(agencia = Util.completaZeros(5, _agencia = String.valueOf(conta.getId().getCodigoAgencia().toString()) + conta.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia().toString()), cc = Util.completaZeros(11, _cc = String.valueOf(conta.getId().getCodigoContaCorrente().toString()) + conta.getDigitoVerificadorContaCorrente().toString())))) continue;
                    mestra = true;
                    break;
                }
                if (!mestra) {
                    continue;
                }
                break;
            }
        }
        catch (StringIndexOutOfBoundsException siobex) {
            System.err.println("[Erro ao calcular a chave mestra]");
            siobex.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mestra;
    }

    public boolean chaveConsumida() throws BBException {
        ServicoAplicacaoTO gac = this.getServicoAplicacaoDAO().consultarServico("GAC");
        if (Util.formatarData(new Date(), "yyyyMMdd").compareTo(Util.formatarData(gac.getDataInstalacao(), "yyyyMMdd")) > 0) {
            gac.setDataInstalacao(new Date());
            this.getServicoAplicacaoDAO().gravarServico(gac);
            return true;
        }
        return false;
    }

    private List<ContaCorrenteClienteTO> getContasBancoDoBrasil(List<ContaCorrenteClienteTO> contasCorrentes) {
        ArrayList<ContaCorrenteClienteTO> contasBB = new ArrayList<ContaCorrenteClienteTO>();
        for (ContaCorrenteClienteTO conta : contasCorrentes) {
            if (conta.getId().getCodigoInstituicaoFinanceira() != 1) continue;
            contasBB.add(conta);
        }
        return contasBB;
    }

    public ConvenenteDAO getConvenenteDAO() {
        return this.convenenteDAO;
    }

    public void setConvenenteDAO(ConvenenteDAO convenenteDAO) {
        this.convenenteDAO = convenenteDAO;
    }

    public ContaCorrenteClienteDAO getContaCorrenteClienteDAO() {
        return this.contaCorrenteClienteDAO;
    }

    public void setContaCorrenteClienteDAO(ContaCorrenteClienteDAO contaCorrenteClienteDAO) {
        this.contaCorrenteClienteDAO = contaCorrenteClienteDAO;
    }

    public ServicoAplicacaoDAO getServicoAplicacaoDAO() {
        if (this.servicoAplicacaoDAO == null) {
            this.servicoAplicacaoDAO = new ServicoAplicacaoDAO();
        }
        return this.servicoAplicacaoDAO;
    }

    public void setServicoAplicacaoDAO(ServicoAplicacaoDAO servicoAplicacaoDAO) {
        this.servicoAplicacaoDAO = servicoAplicacaoDAO;
    }
}

