/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.integracao.dao.GrupoUsuarioDAO;
import br.com.bb.plugins.gac.integracao.dao.PermissaoGrupoDAO;
import br.com.bb.plugins.gac.integracao.dao.ServicoDAO;
import br.com.bb.plugins.gac.integracao.dao.TipoSegmentoDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.GrupoUsuarioTO;
import br.com.bb.plugins.gac.negocio.to.PermissaoGrupoTO;
import br.com.bb.plugins.gac.negocio.to.PermissaoGrupoTOId;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.TipoSegmentoTO;
import br.com.bb.plugins.gac.negocio.to.TransacaoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.TipoSegmentoTODecorator;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VincularPermissaoGrupoUsuarioModel
extends PluginModelAbstrato {
    private PermissaoGrupoDAO permissaoGrupoDAO;
    private TipoSegmentoDAO tipoSegmentoDAO;
    private ServicoDAO servicoDAO;
    private GrupoUsuarioDAO grupoUsuarioDAO;

    public Collection<TipoSegmentoTO> consultarTipoSegmento() {
        return this.getTipoSegmentoDAO().consultarTodos();
    }

    public Collection<ServicoTO> consultarServicoInstalado(TipoSegmentoTODecorator tipoSegmentoTODecorator) {
        char estadoInstalacao = '1';
        return this.getServicoDAO().consultarPorEstadoInstalacaoETipoSegmento(Character.valueOf(estadoInstalacao), tipoSegmentoTODecorator);
    }

    public void vincular(GrupoUsuarioTO grupoUsuarioTO, Collection<TransacaoTO> colecao) {
        this.getPermissaoGrupoDAO().excluirPorIdentificadorDoGrupoUsuario(grupoUsuarioTO);
        if (colecao == null) {
            return;
        }
        for (TransacaoTO to : colecao) {
            PermissaoGrupoTO permissaoGrupoTO = this.preenchePermissaoUsuarioTO(grupoUsuarioTO, to);
            this.getPermissaoGrupoDAO().incluir(permissaoGrupoTO);
        }
    }

    private PermissaoGrupoTO preenchePermissaoUsuarioTO(GrupoUsuarioTO grupoUsuarioTO, TransacaoTO to) {
        PermissaoGrupoTO permissaoGrupoTO = this.getFabricaDeTO().novoPermissaoGrupoTO();
        PermissaoGrupoTOId id = this.getFabricaDeTO().novoPermissaoGrupoTOId();
        id.setNumeroIdentificadorGrupoUsuario(grupoUsuarioTO.getNumeroIdentificadorGrupoUsuario());
        id.setTextoCodigoOpcaoMenu(to.getId().getTextoCodigoOpcaoMenu().trim());
        id.setTextoCodigoTransacao(to.getId().getTextoCodigoTransacao().trim());
        id.setTextoIdentificadorServico(to.getId().getTextoIdentificadorServico().trim());
        permissaoGrupoTO.setId(id);
        return permissaoGrupoTO;
    }

    public Collection<PermissaoGrupoTO> consultarPermissaoGrupoUsuario(GrupoUsuarioTO grupoUsuarioTO) {
        return this.getPermissaoGrupoDAO().consultarPeloGrupoUsuario(grupoUsuarioTO.getNumeroIdentificadorGrupoUsuario());
    }

    public TipoSegmentoDAO getTipoSegmentoDAO() {
        return this.tipoSegmentoDAO;
    }

    public void setTipoSegmentoDAO(TipoSegmentoDAO tipoSegmentoDAO) {
        this.tipoSegmentoDAO = tipoSegmentoDAO;
    }

    public PermissaoGrupoDAO getPermissaoGrupoDAO() {
        return this.permissaoGrupoDAO;
    }

    public void setPermissaoGrupoDAO(PermissaoGrupoDAO permissaoGrupoDAO) {
        this.permissaoGrupoDAO = permissaoGrupoDAO;
    }

    public ServicoDAO getServicoDAO() {
        return this.servicoDAO;
    }

    public void setServicoDAO(ServicoDAO servicoDAO) {
        this.servicoDAO = servicoDAO;
    }

    public GrupoUsuarioDAO getGrupoUsuarioDAO() {
        return this.grupoUsuarioDAO;
    }

    public void setGrupoUsuarioDAO(GrupoUsuarioDAO grupoUsuarioDAO) {
        this.grupoUsuarioDAO = grupoUsuarioDAO;
    }
}

