/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.model;

import br.com.bb.plugins.gac.integracao.dao.PermissaoGrupoDAO;
import br.com.bb.plugins.gac.integracao.dao.PermissaoUsuarioDAO;
import br.com.bb.plugins.gac.integracao.dao.ServicoDAO;
import br.com.bb.plugins.gac.integracao.dao.TipoSegmentoDAO;
import br.com.bb.plugins.gac.integracao.dao.UsuarioDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.PermissaoGrupoTO;
import br.com.bb.plugins.gac.negocio.to.PermissaoUsuarioTO;
import br.com.bb.plugins.gac.negocio.to.PermissaoUsuarioTOId;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.TipoSegmentoTO;
import br.com.bb.plugins.gac.negocio.to.TransacaoTO;
import br.com.bb.plugins.gac.negocio.to.UsuarioTO;
import br.com.bb.plugins.gac.negocio.to.decorator.TipoSegmentoTODecorator;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VincularPermissaoUsuarioModel
extends PluginModelAbstrato {
    private PermissaoUsuarioDAO permissaoUsuarioDAO;
    private TipoSegmentoDAO tipoSegmentoDAO;
    private ServicoDAO servicoDAO;
    private UsuarioDAO usuarioDAO;
    private PermissaoGrupoDAO permissaoGrupoDAO;

    public Collection<TipoSegmentoTO> consultarTipoSegmento() {
        return this.getTipoSegmentoDAO().consultarTodos();
    }

    public Collection<ServicoTO> consultarServicoInstalado(TipoSegmentoTODecorator tipoSegmentoTODecorator) {
        char estadoInstalacao = '1';
        return this.getServicoDAO().consultarPorEstadoInstalacaoETipoSegmento(Character.valueOf(estadoInstalacao), tipoSegmentoTODecorator);
    }

    public void vincular(UsuarioTO usuarioTO, Collection<TransacaoTO> colecao) {
        this.getPermissaoUsuarioDAO().exluirPorIdentificadorDoUsuario(usuarioTO);
        if (colecao == null) {
            return;
        }
        for (TransacaoTO to : colecao) {
            PermissaoUsuarioTO permissaoUsuarioTO = this.preenchePermissaoUsuarioTO(usuarioTO, to);
            this.getPermissaoUsuarioDAO().incluir(permissaoUsuarioTO);
        }
    }

    private PermissaoUsuarioTO preenchePermissaoUsuarioTO(UsuarioTO usuarioTO, TransacaoTO to) {
        PermissaoUsuarioTO permissaoUsuarioTO = this.getFabricaDeTO().novoPermissaoUsuarioTO();
        PermissaoUsuarioTOId id = this.getFabricaDeTO().novoPermissaoUsuarioTOId();
        id.setNumeroIdentificadorUsuario(usuarioTO.getNumeroIdentificadorUsuario());
        id.setTextoCodigoOpcaoMenu(to.getId().getTextoCodigoOpcaoMenu().trim());
        id.setTextoCodigoTransacao(to.getId().getTextoCodigoTransacao().trim());
        id.setTextoIdentificadorServico(to.getId().getTextoIdentificadorServico().trim());
        permissaoUsuarioTO.setId(id);
        return permissaoUsuarioTO;
    }

    public Collection<PermissaoUsuarioTO> consultarPermissaoUsuario(UsuarioTO usuarioTO) {
        return this.getPermissaoUsuarioDAO().consultarPorUsuario(usuarioTO);
    }

    public Collection<PermissaoGrupoTO> consultarPermissaoGrupoUsuario(UsuarioTO usuarioTO) {
        return this.getPermissaoGrupoDAO().consultarPeloGrupoUsuario(usuarioTO.getGrupoUsuarioTO().getNumeroIdentificadorGrupoUsuario());
    }

    public TipoSegmentoDAO getTipoSegmentoDAO() {
        return this.tipoSegmentoDAO;
    }

    public void setTipoSegmentoDAO(TipoSegmentoDAO tipoSegmentoDAO) {
        this.tipoSegmentoDAO = tipoSegmentoDAO;
    }

    public PermissaoUsuarioDAO getPermissaoUsuarioDAO() {
        return this.permissaoUsuarioDAO;
    }

    public void setPermissaoUsuarioDAO(PermissaoUsuarioDAO permissaoUsuarioDAO) {
        this.permissaoUsuarioDAO = permissaoUsuarioDAO;
    }

    public ServicoDAO getServicoDAO() {
        return this.servicoDAO;
    }

    public void setServicoDAO(ServicoDAO servicoDAO) {
        this.servicoDAO = servicoDAO;
    }

    public UsuarioDAO getUsuarioDAO() {
        return this.usuarioDAO;
    }

    public void setUsuarioDAO(UsuarioDAO usuarioDAO) {
        this.usuarioDAO = usuarioDAO;
    }

    public PermissaoGrupoDAO getPermissaoGrupoDAO() {
        return this.permissaoGrupoDAO;
    }

    public void setPermissaoGrupoDAO(PermissaoGrupoDAO permissaoGrupoDAO) {
        this.permissaoGrupoDAO = permissaoGrupoDAO;
    }
}

