/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.to;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.Type;

public class GeradorDeId
implements Configurable,
IdentifierGenerator {
    private String nomeTabela;
    private String nomeColuna;
    private String valorMinimo;
    private static final String NOME_TABELA = "nomeTabela";
    private static final String NOME_COLUNA = "nomeColuna";
    private static final String VALOR_MINIMO = "valorMinimo";

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        this.nomeTabela = params.getProperty(NOME_TABELA);
        this.nomeColuna = params.getProperty(NOME_COLUNA);
        this.valorMinimo = params.getProperty(VALOR_MINIMO);
    }

    public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        ClassMetadata classMetadata = session.getFactory().getClassMetadata(object.getClass());
        Integer pkValue = this.generatePkValue(session);
        if (this.converterParaInteger(pkValue) < this.converterParaInteger(this.valorMinimo)) {
            pkValue = this.converterParaInteger(this.valorMinimo);
        }
        classMetadata.setIdentifier(object, (Serializable)pkValue, EntityMode.POJO);
        return pkValue;
    }

    private Integer converterParaInteger(Object numero) {
        if (numero == null) {
            return 0;
        }
        try {
            return Integer.parseInt(numero.toString());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private Integer generatePkValue(SessionImplementor session) {
        Integer pkValue = 0;
        String sql = "SELECT MAX(" + this.nomeColuna + ") FROM " + this.nomeTabela;
        try {
            PreparedStatement pstmt = session.getBatcher().prepareStatement(sql);
            try {
                try {
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        pkValue = new Integer(rs.getInt(1));
                    }
                    pkValue = pkValue + 1;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    session.getBatcher().closeStatement(pstmt);
                }
            }
            finally {
                session.getBatcher().closeStatement(pstmt);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw JDBCExceptionHelper.convert((SQLExceptionConverter)session.getFactory().getSQLExceptionConverter(), (SQLException)sqle, (String)"Sequencial n\u00e3o pode ser gerado: ", (String)sql);
        }
        return pkValue;
    }
}

