/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.negocio.to.decorator;

import br.com.bb.plugins.gac.negocio.to.AgenciaInstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioDebitoTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioDebitoTOId;
import br.com.bb.plugins.gac.negocio.to.GrupoClienteRecebimentoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorClienteDebitoTO;
import br.com.bb.plugins.gac.negocio.to.InstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.MembroGrupoClienteRecebimentoTO;
import br.com.bb.plugins.gac.negocio.to.PluginTODecoratorAbstrato;
import br.com.bb.plugins.gac.negocio.to.decorator.GrupoClienteRecebimentoTODecorator;
import br.com.politec.generico.formatador.UtilFormatadorDeData;
import br.com.politec.generico.formatador.UtilFormatadorDeReal;
import java.math.BigDecimal;
import java.util.Date;

public class MembroGrupoClienteRecebimentoTODecorator
extends PluginTODecoratorAbstrato {
    private MembroGrupoClienteRecebimentoTO membroGrupoClienteRecebimentoTO;
    private Date dataRecebimento;
    private BigDecimal valorRecebimento;
    private GrupoClienteRecebimentoTODecorator grupoClienteRecebimentoTODecorator;

    public MembroGrupoClienteRecebimentoTO getMembroGrupoClienteRecebimentoTO() {
        if (!this.isReferencia(this.membroGrupoClienteRecebimentoTO)) {
            this.membroGrupoClienteRecebimentoTO = this.getTOFactory().novoMembroGrupoClienteRecebimentoTO();
        }
        return this.membroGrupoClienteRecebimentoTO;
    }

    public void setMembroGrupoClienteRecebimentoTO(MembroGrupoClienteRecebimentoTO membroGrupoClienteRecebimentoTO) {
        this.membroGrupoClienteRecebimentoTO = membroGrupoClienteRecebimentoTO;
    }

    public GrupoClienteRecebimentoTO getGrupoClienteRecebimentoTO() {
        return this.getMembroGrupoClienteRecebimentoTO().getGrupoClienteRecebimentoTO();
    }

    public IdentificadorClienteDebitoTO getIdentificadorClienteDebitoTO() {
        return this.getMembroGrupoClienteRecebimentoTO().getIdentificadorClienteDebitoTO();
    }

    public void setGrupoClienteRecebimentoTO(GrupoClienteRecebimentoTO grupoClienteRecebimentoTO) {
        this.getMembroGrupoClienteRecebimentoTO().setGrupoClienteRecebimentoTO(grupoClienteRecebimentoTO);
    }

    public void setIdentificadorClienteDebitoTO(IdentificadorClienteDebitoTO identificadorClienteDebitoTO) {
        this.getMembroGrupoClienteRecebimentoTO().setIdentificadorClienteDebitoTO(identificadorClienteDebitoTO);
    }

    public String getTextoDescricaoGrupoClienteDebito() {
        return this.getGrupoClienteRecebimentoTO().getTextoDescricao();
    }

    public String getBanco() {
        String banco = "-";
        InstituicaoFinanceiraTO to = this.getInstituicaoFinanceiraContaCliente();
        if (this.isReferencia(to)) {
            banco = to.toString();
        }
        return banco;
    }

    public String getAgencia() {
        Integer codAgencia = this.getAgenciaInsituicaoFinanceiraContaCliente().getId().getCodigoAgencia();
        Character digito = this.getAgenciaInsituicaoFinanceiraContaCliente().getDigitoVerificadorAgencia();
        String agencia = "-";
        if (this.isReferencia(codAgencia) && this.isReferencia(digito)) {
            agencia = codAgencia + "-" + Character.toString(digito.charValue());
        }
        return agencia;
    }

    public String getContaCorrente() {
        String conta = "-";
        Long contaCorrente = this.getContaCorrenteClienteIdentificador().getId().getCodigoContaCorrente();
        Character digito = this.getContaCorrenteClienteIdentificador().getDigitoVerificadorContaCorrente();
        if (this.isReferencia(contaCorrente) && this.isReferencia(digito)) {
            conta = contaCorrente + "-" + Character.toString(digito.charValue());
        }
        return conta;
    }

    public String getSituacaoIdentificacaoDebito() {
        return this.getIdentificadorClienteDebitoTO().getSituacaoIdentificadorDebitoTO().getTextoDescricao();
    }

    public String getIdentificacaoParaDebitoCliente() {
        return this.getIdentificadorClienteDebitoTO().getTextoIdentificadorDebito();
    }

    public InstituicaoFinanceiraTO getInstituicaoFinanceiraContaCliente() {
        InstituicaoFinanceiraTO to = this.getAgenciaInsituicaoFinanceiraContaCliente().getInstituicaoFinanceiraTO();
        if (!this.isReferencia(to)) {
            to = this.getTOFactory().novoInstituicaoFinanceiraTO();
        }
        return to;
    }

    public AgenciaInstituicaoFinanceiraTO getAgenciaInsituicaoFinanceiraContaCliente() {
        AgenciaInstituicaoFinanceiraTO to = this.getContaCorrenteClienteIdentificador().getAgenciaInstituicaoFinanceiraTO();
        if (!this.isReferencia(to)) {
            to = this.getTOFactory().novoAgenciaInstituicaoFinanceiraTO();
        }
        return to;
    }

    public ContaCorrenteClienteTO getContaCorrenteClienteIdentificador() {
        ContaCorrenteClienteTO to = this.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO();
        if (!this.isReferencia(to)) {
            to = this.getTOFactory().novoContaCorrenteClienteTO();
        }
        return to;
    }

    public Integer getNumeroConvenio() {
        return this.getConvenioDebitoTOId().getNumeroConvenio();
    }

    public ConvenioDebitoTOId getConvenioDebitoTOId() {
        if (!this.isReferencia(this.getConvenioDebitoTO().getId())) {
            ConvenioDebitoTOId id = this.getTOFactory().novoConvenioDebitoTOId();
            this.getConvenioDebitoTO().setId(id);
        }
        return this.getConvenioDebitoTO().getId();
    }

    public ConvenioDebitoTO getConvenioDebitoTO() {
        ConvenioDebitoTO convenioDebitoTO = null;
        if (!this.isReferencia(this.getIdentificadorClienteDebitoTO().getConvenioDebitoTO())) {
            convenioDebitoTO = this.getTOFactory().novoConvenioDebitoTO();
            this.getIdentificadorClienteDebitoTO().setConvenioDebitoTO(convenioDebitoTO);
        }
        return this.getIdentificadorClienteDebitoTO().getConvenioDebitoTO();
    }

    public Date getDataRecebimento() {
        return this.dataRecebimento;
    }

    public String getDataRecebimentoFormatada() {
        String retorno = null;
        retorno = this.dataRecebimento != null ? UtilFormatadorDeData.formatar_ddMMyyyy(this.dataRecebimento) : "";
        return retorno;
    }

    public void setDataRecebimento(Date dataRecebimento) {
        this.dataRecebimento = dataRecebimento;
    }

    public BigDecimal getValorRecebimento() {
        return this.valorRecebimento;
    }

    public String getValorRecebimentoFormatado() {
        String retorno = null;
        retorno = this.valorRecebimento != null ? "R$ " + UtilFormatadorDeReal.formatar(this.valorRecebimento, 2) : "";
        return retorno;
    }

    public void setValorRecebimento(BigDecimal valorRecebimento) {
        this.valorRecebimento = valorRecebimento;
    }

    public void setGrupoClienteRecebimentoTODecorator(GrupoClienteRecebimentoTODecorator grupoClienteRecebimentoTODecorator) {
        this.grupoClienteRecebimentoTODecorator = grupoClienteRecebimentoTODecorator;
    }

    public GrupoClienteRecebimentoTODecorator getGrupoClienteRecebimentoTODecorator() {
        return this.grupoClienteRecebimentoTODecorator;
    }
}

