/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.relatorio;

import br.com.bb.plugins.gac.excecao.BBException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

public class RelatorioDataSource
extends JRBeanCollectionDataSource {
    private Iterator iterator;
    private Object proximoObjeto;
    private Iterator listaDeMapas;
    private HashMap proximoMapa;
    private String primeiraLetra;

    public RelatorioDataSource(Collection collection) {
        super(collection);
        this.setIterator(collection.iterator());
        this.setListaDeMapas(this.toMapList(collection).iterator());
    }

    public Iterator getIterator() {
        return this.iterator;
    }

    private void setIterator(Iterator itAgentes) {
        this.iterator = itAgentes;
    }

    public Object getProximoObjeto() {
        return this.proximoObjeto;
    }

    public void setProximoObjeto(Object proximoObjeto) {
        this.proximoObjeto = proximoObjeto;
    }

    public boolean next() {
        boolean retorno = false;
        if (this.getIterator().hasNext()) {
            retorno = true;
            this.setProximoObjeto(this.getIterator().next());
            this.setProximoMapa((HashMap)this.getListaDeMapas().next());
        }
        return retorno;
    }

    private ArrayList toMapList(Collection colecao) {
        ArrayList resultado = new ArrayList();
        for (Object obj : colecao) {
            HashMap<String, Object> mapa = new HashMap<String, Object>();
            Class<?> c = obj.getClass();
            Method[] theMethods = c.getDeclaredMethods();
            int i = 0;
            while (i < theMethods.length) {
                Class[] parameterTypes;
                String metodo = theMethods[i].getName();
                if (this.isGetValido(metodo, parameterTypes = theMethods[i].getParameterTypes())) {
                    try {
                        mapa.put(this.removeGet(metodo), this.invoke(theMethods[i], obj));
                    }
                    catch (BBException bBException) {
                        // empty catch block
                    }
                }
                ++i;
            }
            resultado.add(mapa);
        }
        return resultado;
    }

    private String removeGet(String metodo) {
        String retorno = metodo.substring(3);
        this.primeiraLetra = retorno.substring(0, 1);
        this.primeiraLetra = this.primeiraLetra.toLowerCase();
        retorno = String.valueOf(this.primeiraLetra) + retorno.substring(1);
        return retorno;
    }

    private Object invoke(Method method, Object obj) throws BBException {
        try {
            Object temp = method.invoke(obj, null);
            return temp;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("O m\u00e9todo " + method.getName() + " requer um parametro aonde espera-se m\u00e9todos sem " + "parametro nenhum");
        }
        catch (IllegalAccessException e) {
            throw new BBException("O m\u00e9todo " + method.getName() + " \u00e9 protegido/privado e n\u00e3o pode ser invocado");
        }
        catch (InvocationTargetException e) {
            throw new BBException("N\u00e3o existe o m\u00e9todo " + method.getName());
        }
    }

    private boolean isGetValido(String metodo, Class[] parameterTypes) {
        return metodo.length() > 3 && metodo.substring(0, 3).equals("get") && parameterTypes.length == 0;
    }

    public Object getFieldValue(JRField campo) {
        return this.getProximoMapa().get(campo.getName());
    }

    private Iterator getListaDeMapas() {
        return this.listaDeMapas;
    }

    private void setListaDeMapas(Iterator iterator2) {
        this.listaDeMapas = iterator2;
    }

    private HashMap getProximoMapa() {
        return this.proximoMapa;
    }

    private void setProximoMapa(HashMap proximoMapa) {
        this.proximoMapa = proximoMapa;
    }
}

