/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassLoaderUtil {
    private static Log log = LogFactory.getLog(ClassLoaderUtil.class);
    private static final Class[] parameters = new Class[]{URL.class};
    private static ClassLoader current = null;

    public static void addFile(String s) throws IOException {
        File f = new File(s);
        ClassLoaderUtil.addFile(f);
    }

    public static void addFile(File f) throws IOException {
        ClassLoaderUtil.addURL(f.toURL());
        System.out.println("URL adicionada a classpath: " + f.toURL().toString());
    }

    public static void addFilesFromFolder(String s_folder) {
        try {
            File fdir = new File(s_folder);
            if (fdir.isDirectory()) {
                File[] lista = fdir.listFiles();
                int icnt = 0;
                while (icnt < lista.length) {
                    if (lista[icnt].isFile()) {
                        ClassLoaderUtil.addFile(String.valueOf(s_folder) + "/" + lista[icnt].getName());
                    } else {
                        ClassLoaderUtil.addFilesFromFolder(lista[icnt].getCanonicalPath());
                    }
                    ++icnt;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void ListURLs() {
        URLClassLoader sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] urls = sysLoader.getURLs();
        int i = 0;
        while (i < urls.length) {
            System.out.println(urls[i].toString());
            ++i;
        }
    }

    public static void reload(String s_file) {
        try {
            URL[] urls = new URL[]{new File(s_file).toURL()};
            URLClassLoader uRLClassLoader = new URLClassLoader(urls);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public static void addURL(URL u) throws IOException {
        URLClassLoader sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] urls = sysLoader.getURLs();
        int i = 0;
        while (i < urls.length) {
            if (urls[i].toString().trim().equalsIgnoreCase(u.toString())) {
                if (log.isDebugEnabled()) {
                    log.debug("URL " + u + " j\u00e1 est\u00e1 no CLASSPATH");
                }
                return;
            }
            ++i;
        }
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysLoader, u);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Erro, n\u00e3o pode adicionar a URL ao classloader do Sistema");
        }
    }

    public static void replaceClassLoader() {
        try {
            ClassLoader previous = Thread.currentThread().getContextClassLoader();
            String s_url = "/plugins/cltx.jar";
            URL[] urls = new URL[]{new File(s_url).toURL()};
            current = URLClassLoader.newInstance(urls, previous);
            Thread.currentThread().setContextClassLoader(current);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }
}

