/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util;

import br.com.bb.plugins.gac.util.swing.AbstractLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class FieldLayout
extends AbstractLayout {
    public FieldLayout() {
    }

    public FieldLayout(int hgap, int vgap) {
        super(hgap, vgap);
    }

    public Dimension minimumLayoutSize(Container target) {
        int left = 0;
        int right = 0;
        int height = 0;
        Insets insets = target.getInsets();
        int ncomponents = target.getComponentCount();
        int i = 0;
        while (i < ncomponents) {
            Component label = target.getComponent(i);
            int w1 = label.getMinimumSize().width;
            int h1 = label.getMinimumSize().height;
            if (w1 > left) {
                left = w1;
            }
            if (i + 1 < ncomponents) {
                Component field = target.getComponent(i + 1);
                int w2 = field.getMinimumSize().width;
                int h2 = field.getMinimumSize().height;
                if (w2 > right) {
                    right = w2;
                }
                height += Math.max(h1, h2) + this.hgap;
            } else {
                height += h1;
            }
            i += 2;
        }
        return new Dimension(insets.left + insets.right + left + right + this.vgap, insets.top + insets.bottom + height - this.hgap);
    }

    public Dimension preferredLayoutSize(Container target) {
        int left = 0;
        int right = 0;
        int height = 0;
        Insets insets = target.getInsets();
        int ncomponents = target.getComponentCount();
        int i = 0;
        while (i < ncomponents) {
            Component label = target.getComponent(i);
            int w1 = label.getPreferredSize().width;
            int h1 = label.getPreferredSize().height;
            if (w1 > left) {
                left = w1;
            }
            if (i + 1 < ncomponents) {
                Component field = target.getComponent(i + 1);
                int w2 = field.getPreferredSize().width;
                int h2 = field.getPreferredSize().height;
                if (w2 > right) {
                    right = w2;
                }
                height += Math.max(h1, h2) + this.hgap;
            } else {
                height += h1;
            }
            i += 2;
        }
        return new Dimension(insets.left + insets.right + left + right + this.vgap, insets.top + insets.bottom + height - this.hgap);
    }

    public void layoutContainer(Container target) {
        int left = 0;
        boolean height = false;
        Insets insets = target.getInsets();
        int ncomponents = target.getComponentCount();
        int i = 0;
        while (i < ncomponents) {
            Component label = target.getComponent(i);
            int w = label.getPreferredSize().width;
            if (w > left) {
                left = w;
            }
            i += 2;
        }
        int right = target.getSize().width - left - insets.left - insets.right - this.hgap;
        int vpos = insets.top;
        int i2 = 0;
        while (i2 < ncomponents) {
            Component label = target.getComponent(i2);
            int h1 = label.getPreferredSize().height;
            int h2 = 0;
            Component field = null;
            if (i2 + 1 < ncomponents) {
                field = target.getComponent(i2 + 1);
                h2 = field.getPreferredSize().height;
            }
            int h = Math.max(h1, h2);
            label.setBounds(insets.left, vpos, left, h);
            if (field != null) {
                field.setBounds(insets.left + left + this.hgap, vpos, right, h);
            }
            vpos += h + this.hgap;
            i2 += 2;
        }
    }
}

