/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util;

import br.com.bb.plugins.gac.util.swing.componente.BBJProgressBar;
import br.com.politec.infra.util.UtilLog;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtils {
    public static void copiar(File origem, File destino) throws IOException {
        FileUtils.garantirPath(destino);
        FileInputStream in = new FileInputStream(origem);
        FileOutputStream out = new FileOutputStream(destino);
        FileUtils.copiar(in, out);
        ((OutputStream)out).close();
    }

    public static void garantirPath(File arq) throws IOException {
        String pai = arq.getParent();
        if (pai == null || pai.length() == 0) {
            return;
        }
        new File(pai).mkdirs();
    }

    public static void copiar(InputStream in, OutputStream out) throws IOException {
        int lidos;
        byte[] buffer = new byte[4096];
        while ((lidos = in.read(buffer)) != -1) {
            out.write(buffer, 0, lidos);
        }
        in.close();
    }

    public static void copyFile(String origem, String destino) throws Throwable {
        FileWriter fw = null;
        FileReader fr = null;
        BufferedReader br = null;
        BufferedWriter bw = null;
        File source = null;
        try {
            try {
                fr = new FileReader(origem);
                fw = new FileWriter(destino);
                br = new BufferedReader(fr);
                bw = new BufferedWriter(fw);
                source = new File(origem);
                int fileLength = (int)source.length();
                char[] charBuff = new char[fileLength];
                while (br.read(charBuff, 0, fileLength) != -1) {
                    bw.write(charBuff, 0, fileLength);
                }
            }
            catch (FileNotFoundException fnfe) {
                throw new Exception(String.valueOf(origem) + " nao existe!");
            }
            catch (IOException ioe) {
                throw new Exception("Copia de arquivo - Erro de i/o");
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException ioe) {
                UtilLog.getLog().debug(ioe);
            }
        }
    }

    public static void copyFile(String origem, String destino, final BBJProgressBar barraProgresso) throws Throwable {
        FileWriter fw = new FileWriter(destino);
        FileReader fr = new FileReader(origem);
        final BufferedReader br = new BufferedReader(fr);
        final BufferedWriter bw = new BufferedWriter(fw);
        File source = new File(origem);
        try {
            final int fileLength = (int)source.length();
            Thread td = new Thread(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    char[] charBuff = new char[fileLength];
                    try {
                        while (true) {
                            if (br.read(charBuff, 0, fileLength) == -1) {
                                return;
                            }
                            bw.write(charBuff, 0, fileLength);
                            barraProgresso.setValoratual(barraProgresso.getValoratual() + 1L);
                            barraProgresso.updateUI();
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            td.start();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException ioe) {
                UtilLog.getLog().debug(ioe);
            }
        }
    }

    public static boolean criarDiretorio(String Diretorio) throws Throwable {
        File nomeDir;
        block3: {
            try {
                nomeDir = new File(Diretorio);
                if (!nomeDir.isDirectory()) break block3;
                return true;
            }
            catch (Throwable e) {
                throw new Throwable(e.getMessage());
            }
        }
        return nomeDir.mkdirs();
    }

    public static byte[] byteDeInputStream(InputStream in) {
        byte[] buffy = new byte[2048];
        int off = 512;
        int totalRead = 0;
        int bytesRead = 0;
        try {
            while ((bytesRead = in.read(buffy, off, buffy.length - off)) > -1) {
                totalRead += bytesRead;
                if ((off += bytesRead) != buffy.length) continue;
                byte[] buffy2 = new byte[buffy.length * 2];
                System.arraycopy(buffy, 0, buffy2, 0, buffy.length);
                buffy = buffy2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffy;
    }

    public static byte[] bytesDeFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Tamanho do arquivo muito grande " + file.getName());
        }
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static int contarLinhas(String file) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            byte[] c = new byte[1024];
            int count = 0;
            int readChars = 0;
            boolean empty = true;
            while ((readChars = ((InputStream)is).read(c)) != -1) {
                empty = false;
                int i = 0;
                while (i < readChars) {
                    if (c[i] == 10) {
                        ++count;
                    }
                    ++i;
                }
            }
            int n = count == 0 && !empty ? 1 : count;
            return n;
        }
        finally {
            ((InputStream)is).close();
        }
    }
}

