/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util;

import br.com.bb.plugins.gac.util.CalculaDigitoVerificador;
import br.com.politec.infra.util.UtilLog;
import java.math.BigDecimal;

public class FormatadorNumero {
    private FormatadorNumero() {
    }

    public static String formatarCGC(Number numCGC) {
        if (numCGC == null) {
            return "";
        }
        return FormatadorNumero.formatarCGC(numCGC.toString());
    }

    public static String formatarCGC(String numCGC) {
        if (numCGC == null) {
            return "";
        }
        StringBuffer cgc = new StringBuffer(18);
        try {
            cgc.append(Long.parseLong(numCGC.trim()));
            while (cgc.length() < 14) {
                cgc.insert(0, '0');
            }
            if (cgc.charAt(11) != ' ') {
                cgc.insert(12, '-');
                if (cgc.charAt(7) != ' ') {
                    cgc.insert(8, '/');
                    if (cgc.charAt(4) != ' ') {
                        cgc.insert(5, '.');
                        if (cgc.charAt(1) != ' ') {
                            cgc.insert(2, '.');
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            return numCGC;
        }
        return cgc.toString();
    }

    public static String formatarContaCorrente(Number contaCorrente) {
        String contaFormatada = "";
        if (contaCorrente != null) {
            try {
                contaFormatada = contaCorrente.toString();
                String conta = FormatadorNumero.formatarValor(contaFormatada, 12, 0);
                String digito = CalculaDigitoVerificador.calcularModulo11(contaFormatada);
                contaFormatada = String.valueOf(conta) + "-" + digito;
            }
            catch (Exception e) {
                UtilLog.getLog().debug(e);
            }
        }
        return contaFormatada;
    }

    public static String formatarCPF(Number numCPF) {
        if (numCPF == null) {
            return "";
        }
        return FormatadorNumero.formatarCPF(numCPF.toString());
    }

    public static String formatarCPF(String numCPF) {
        if (numCPF == null) {
            return "";
        }
        StringBuffer cpf = new StringBuffer(14);
        try {
            cpf.append(Long.parseLong(numCPF.toString().trim()));
            while (cpf.length() < 11) {
                cpf.insert(0, '0');
            }
            if (cpf.charAt(8) != ' ') {
                cpf.insert(9, '-');
                if (cpf.charAt(5) != ' ') {
                    cpf.insert(6, '.');
                    if (cpf.charAt(2) != ' ') {
                        cpf.insert(3, '.');
                    }
                }
            }
        }
        catch (Exception e) {
            return numCPF.toString();
        }
        return cpf.toString();
    }

    public static String formatarPrefixoAgencia(Number codPrefixo) {
        if (codPrefixo == null) {
            return "";
        }
        StringBuffer num = new StringBuffer(6);
        try {
            num.append(Long.parseLong(codPrefixo.toString().trim()));
            num.append(CalculaDigitoVerificador.calcularModulo11(num.toString()));
            while (num.length() < 5) {
                num.insert(0, '0');
            }
            num.insert(4, '-');
            num.insert(1, '.');
        }
        catch (Exception e) {
            return codPrefixo.toString();
        }
        return num.toString();
    }

    public static String formatarValor(Number valor) {
        return FormatadorNumero.formatarValor(valor, 0);
    }

    public static String formatarValor(Number valor, int qtdeDecimais) {
        return FormatadorNumero.formatarValor(valor, 0, qtdeDecimais);
    }

    public static String formatarValor(Number valor, int numDigitos, int qtdeDecimais) {
        if (valor == null) {
            return "";
        }
        if (valor instanceof Double) {
            valor = new BigDecimal((Double)valor);
        }
        return FormatadorNumero.formatarValor(valor.toString(), numDigitos, qtdeDecimais);
    }

    public static String formatarValor(String valor, int numDigitos, int qtdeDecimais) {
        if (valor == null) {
            return "";
        }
        return FormatadorNumero.internalFormatartValor(valor, numDigitos, qtdeDecimais);
    }

    private static String internalFormatartValor(String valor, int iiNroDgts, int nDec) {
        String slOrig = valor;
        int iiNroDecs = nDec;
        int ilPosD = -1;
        boolean blNeg = false;
        slOrig = slOrig.replace('.', ',');
        String slTrat = "";
        int ilC = 0;
        while (ilC < slOrig.length()) {
            char clAt = slOrig.charAt(ilC);
            switch (clAt) {
                case '-': {
                    blNeg = true;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    slTrat = String.valueOf(slTrat) + clAt;
                    break;
                }
                case ',': {
                    if (ilPosD >= 0) break;
                    slTrat = String.valueOf(slTrat) + ",";
                    ilPosD = slTrat.length();
                    break;
                }
            }
            ++ilC;
        }
        if (ilPosD < 0) {
            slTrat = String.valueOf(slTrat) + ",";
            ilPosD = slTrat.length();
        }
        if (ilPosD == slTrat.length()) {
            slTrat = String.valueOf(slTrat) + "0";
        }
        while (slTrat.length() - ilPosD < iiNroDecs) {
            slTrat = String.valueOf(slTrat) + "0";
        }
        if (ilPosD == 1) {
            slTrat = "0" + slTrat;
            ++ilPosD;
        }
        if (iiNroDgts > 0 && (ilC = iiNroDgts - iiNroDecs - ilPosD + 1) < 0) {
            slTrat = String.valueOf(slTrat.substring(0, ilPosD + ilC - 1)) + "," + slTrat.substring(ilPosD + ilC - 1, ilPosD - 1) + slTrat.substring(ilPosD);
            ilPosD += ilC;
        }
        ilC = ilPosD - 1;
        while (ilC > 3) {
            slTrat = String.valueOf(slTrat.substring(0, ilC -= 3)) + "." + slTrat.substring(ilC);
            ++ilPosD;
        }
        slTrat = String.valueOf(blNeg ? "-" : "") + slTrat.substring(0, ilPosD - 1) + (iiNroDecs <= 0 ? "" : "," + slTrat.substring(ilPosD, ilPosD + iiNroDecs));
        return slTrat;
    }

    public static String retiraCaracter(String str, char c) {
        String s = "";
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) != c) {
                s = String.valueOf(s) + str.charAt(i);
            }
            ++i;
        }
        return s;
    }
}

