/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util;

import br.com.bb.plugins.gac.util.ExecutaEspera;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;

public class RotinasBackup {
    public static final int BAK_FULL = 0;
    public static final int BAK_INCREMENTAL_1 = 1;
    public static final int BAK_INCREMENTAL_2 = 2;
    public static final int BAK_INCREMENTAL_3 = 3;
    public static final int RES_FULL = 4;
    public static final int RES_INCREMENTAL = 5;
    public static final int BLOQUEIO_L = 0;
    public static final int DESBLEQUEIO_N = 1;
    public static final int DESBLEQUEIO_F = 2;
    private String localbanco = null;
    private String localbackup = null;
    private String nomebanco = null;
    private String localnbackup = null;

    public RotinasBackup() {
        this.localnbackup = "c:\\Program Files\\Firebird\\Firebird_2_0\\bin\\";
        this.localbanco = "c:\\banco\\";
        this.localbackup = "c:\\backup\\";
        this.nomebanco = "banco.fdb";
    }

    public RotinasBackup(String localnbackupF, String localbancoF, String localbackupF, String nomebancoF) {
        this.localnbackup = localnbackupF;
        this.localbanco = localbancoF;
        this.localbackup = localbackupF;
        this.nomebanco = nomebancoF;
    }

    public void BloqueiaDesbloqueiaBanco(int tipobloqdesb) {
        String comando = null;
        switch (tipobloqdesb) {
            case 0: {
                comando = String.valueOf(this.localnbackup) + "nbackup -U SYSDBA -P masterkey -L " + this.localbanco + this.nomebanco;
                break;
            }
            case 1: {
                comando = String.valueOf(this.localnbackup) + "nbackup -U SYSDBA -P masterkey -N " + this.localbanco + this.nomebanco;
                break;
            }
            case 2: {
                comando = String.valueOf(this.localnbackup) + "nbackup -U SYSDBA -P masterkey -F " + this.localbanco + this.nomebanco;
            }
        }
        try {
            ExecutaEspera exw = new ExecutaEspera();
            ExecutaEspera.execWait(comando);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void recuperaGbakFull() {
        try {
            String comando = String.valueOf(this.localnbackup) + "gbak " + " -USER SYSDBA " + " -PASS masterkey " + " -create " + " -REP    " + this.localbackup + "backupGbakFull.bak" + " " + this.localbanco + this.nomebanco;
            ExecutaEspera exw = new ExecutaEspera();
            ExecutaEspera.execWait(comando);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void executaGbakFull() {
        try {
            String comando = String.valueOf(this.localnbackup) + "gbak " + " -USER SYSDBA " + " -PASS masterkey " + " -backup " + " -ignore " + " -garbage " + " -limbo " + this.localbanco + this.nomebanco + " " + this.localbackup + "backupGbakFull.bak";
            ExecutaEspera exw = new ExecutaEspera();
            ExecutaEspera.execWait(comando);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void ExecutaBackupFull() {
        try {
            String comando = String.valueOf(this.localnbackup) + "nbackup -U SYSDBA -P masterkey -B 0 " + this.localbanco + this.nomebanco + " " + this.localbackup + RotinasBackup.NomeiaBackup(0);
            ExecutaEspera exw = new ExecutaEspera();
            ExecutaEspera.execWait(comando);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void restauraBackupFull(String nomebackup) {
        try {
            this.nomebanco = RotinasBackup.NomeiaRestore(4);
            String comando = String.valueOf(this.localnbackup) + "nbackup -U SYSDBA -P masterkey -R " + this.localbanco + this.nomebanco + " " + this.localbackup + nomebackup;
            ExecutaEspera exw = new ExecutaEspera();
            ExecutaEspera.execWait(comando);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void ExecutaBackupIncremental(int tpbackup) {
        try {
            String comando = String.valueOf(this.localnbackup) + "nbackup -U SYSDBA -P masterkey -B " + String.valueOf(tpbackup) + " " + this.localbanco + this.nomebanco + " " + this.localbackup + RotinasBackup.NomeiaBackup(tpbackup);
            ExecutaEspera exw = new ExecutaEspera();
            ExecutaEspera.execWait(comando);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void RestauraBackupIncremental(String nomebackupincremental) {
        try {
            this.nomebanco = RotinasBackup.NomeiaRestore(5);
            String comando = String.valueOf(this.localnbackup) + "nbackup -U SYSDBA -P masterkey -R " + this.localbanco + this.nomebanco + " ";
            StringTokenizer st = new StringTokenizer(nomebackupincremental);
            String cmdtemp = "";
            while (st.hasMoreTokens()) {
                cmdtemp = String.valueOf(cmdtemp) + " " + this.localbackup + st.nextToken();
            }
            comando = String.valueOf(comando) + cmdtemp;
            ExecutaEspera exw = new ExecutaEspera();
            ExecutaEspera.execWait(comando);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static String NomeiaBackup(int tpbackup) throws Exception {
        String datahora = "agora";
        String resultado = null;
        switch (tpbackup) {
            case 0: {
                resultado = "backupFull_" + datahora + ".fdb";
                break;
            }
            case 1: {
                resultado = "backupInc_1_" + datahora + ".fdb";
                break;
            }
            case 2: {
                resultado = "backupInc_2_" + datahora + ".fdb";
                break;
            }
            case 3: {
                resultado = "backupInc_3_" + datahora + ".fdb";
            }
        }
        return resultado;
    }

    public static String PegaDataHora() {
        Locale locale = new Locale("pt", "BR");
        GregorianCalendar calendar = new GregorianCalendar();
        SimpleDateFormat formatador = new SimpleDateFormat("dd' de 'MMMMM' de 'yyyy' - 'HH:mm:ss:SSS", locale);
        String dhtemp = formatador.format(calendar.getTime());
        String datahora = dhtemp.replaceAll(":", "").replaceAll("-", "").replaceAll(":", "").replaceAll(" ", "").trim();
        return datahora;
    }

    public static String NomeiaRestore(int tprestore) throws Exception {
        String datahora = "agora";
        String resultado = null;
        if (tprestore == 0) {
            throw new Exception("Erro ao passar par\u00e2metro");
        }
        switch (tprestore) {
            case 4: {
                resultado = "RestoreFull_" + datahora + ".fdb";
                break;
            }
            case 5: {
                resultado = "RestoreInc_" + datahora + ".fdb";
            }
        }
        return resultado;
    }

    public void PopulaBanco() {
        try {
            Class.forName("org.firebirdsql.jdbc.FBDriver");
            String url = "jdbc:firebirdsql:127.0.0.1/3050:c:\\banco\\BANCO.FDB";
            Connection con = DriverManager.getConnection(url, "SYSDBA", "masterkey");
            Statement st = con.createStatement();
            String sql = " INSERT INTO TB_CLIENTE (NM_CLIENTE) VALUES ('VALOR INSERIDO " + RotinasBackup.PegaDataHora() + "')";
            st.executeUpdate(sql);
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void PopulaBanco1() {
        try {
            Class.forName("org.firebirdsql.jdbc.FBDriver");
            String url = "jdbc:firebirdsql:127.0.0.1/3050:c:\\banco\\BANCO.FDB";
            Connection con = DriverManager.getConnection(url, "SYSDBA", "masterkey");
            Statement st = con.createStatement();
            String sql = " INSERT INTO TB_CLIENTE (NM_CLIENTE, TX_END) VALUES ('VALOR INSERIDO " + RotinasBackup.PegaDataHora() + "', 'teste de endereco')";
            st.executeUpdate(sql);
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void PopulaBanco2(int ntbini, int ntbfin, int nreg) {
        try {
            Class.forName("org.firebirdsql.jdbc.FBDriver");
            String url = "jdbc:firebirdsql:127.0.0.1/3050:c:\\banco\\BANCO.FDB";
            Connection con = DriverManager.getConnection(url, "SYSDBA", "masterkey");
            Statement st = con.createStatement();
            String sql = null;
            con.setAutoCommit(true);
            int i = ntbini;
            while (i < ntbfin) {
                int j = 0;
                while (j < nreg) {
                    sql = "INSERT INTO tb_teste" + i + "(cd_campo1," + " cd_campo2," + " cd_campo3," + " cd_campo4," + " cd_campo5," + " cd_campo6," + " cd_campo7" + ")values(" + " 'tx_campo" + j + "'," + " 'tx_campo" + j + "'," + " 'tx_campo" + j + "'," + " 'tx_campo" + j + "'," + " 'tx_campo" + j + "'," + " 'tx_campo" + j + "'," + " 'tx_campo" + j + "')";
                    st.executeUpdate(sql);
                    ++j;
                }
                ++i;
            }
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void AlteraEstruturaBanco() {
        try {
            Class.forName("org.firebirdsql.jdbc.FBDriver");
            String url = "jdbc:firebirdsql:127.0.0.1/3050:c:\\banco\\BANCO.FDB";
            Connection con = DriverManager.getConnection(url, "SYSDBA", "masterkey");
            Statement st = con.createStatement();
            String sql = "ALTER TABLE TB_CLIENTE ADD  TX_END VARCHAR(30)";
            st.executeUpdate(sql);
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void CriaTabela(int ntbini, int ntbfin) {
        try {
            Class.forName("org.firebirdsql.jdbc.FBDriver");
            String url = "jdbc:firebirdsql:127.0.0.1/3050:c:\\banco\\BANCO.FDB";
            Connection con = DriverManager.getConnection(url, "SYSDBA", "masterkey");
            Statement st = con.createStatement();
            String sql = null;
            con.setAutoCommit(true);
            int i = ntbini;
            while (i < ntbfin) {
                sql = "create table tb_teste" + i + " (" + "cd_campo1   varchar(30)," + "cd_campo2   varchar(30)," + "cd_campo3   varchar(30)," + "cd_campo4   varchar(30)," + "cd_campo5   varchar(30)," + "cd_campo6   varchar(30)," + "cd_campo7   varchar(30));";
                st.executeUpdate(sql);
                ++i;
            }
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void conectaComAlias() {
        String sql = null;
        try {
            Class.forName("org.firebirdsql.jdbc.FBDriver");
            String url = "jdbc:firebirdsql:127.0.0.1/3050:tunico ";
            Connection con = DriverManager.getConnection(url, "SYSDBA", "masterkey");
            Statement st = con.createStatement();
            con.setAutoCommit(true);
            int i = 0;
            while (i < 10) {
                sql = "select 'antonio' as ant from rdb$database";
                st.executeQuery(sql);
                ++i;
            }
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void incluiRegistro() {
        String sql = null;
        try {
            Class.forName("org.firebirdsql.jdbc.FBDriver");
            String url = "jdbc:firebirdsql:127.0.0.1/3050:tunico ";
            Connection con = DriverManager.getConnection(url, "SYSDBA", "masterkey");
            Statement st = con.createStatement();
            con.setAutoCommit(true);
            int i = 0;
            while (i < 1000) {
                sql = "INSERT INTO TB_CLIENTE(NM_CLIENTE)VALUES('ANTONIO " + i + "')";
                st.executeUpdate(sql);
                ++i;
            }
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void excluiRegistro() {
        String sql = null;
        try {
            Class.forName("org.firebirdsql.jdbc.FBDriver");
            String url = "jdbc:firebirdsql:127.0.0.1/3050:tunico ";
            Connection con = DriverManager.getConnection(url, "SYSDBA", "masterkey");
            Statement st = con.createStatement();
            con.setAutoCommit(true);
            sql = "DELETE FROM TB_CLIENTE WHERE NM_CLIENTE = 'ANTONIO'";
            st.executeUpdate(sql);
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean copiaArquivo(String arqEntrada, String arqSaida) {
        FileInputStream is = null;
        OutputStream os = null;
        boolean success = true;
        try {
            try {
                is = new FileInputStream(arqEntrada);
                os = new FileOutputStream(arqSaida);
                byte[] buffer = new byte[((InputStream)is).available()];
                ((InputStream)is).read(buffer);
                os.write(buffer);
            }
            catch (IOException e) {
                success = false;
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (OutOfMemoryError e) {
                success = false;
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
        }
        return success;
    }
}

