/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util;

import java.io.UnsupportedEncodingException;
import java.text.BreakIterator;
import java.util.Arrays;
import java.util.Locale;

public class StringUtil {
    public static final String STRING_VAZIA = "";
    public static final char[] ACENTUADOS = "\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d9\u00da\u00db\u00dc\u00dd\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f9\u00fa\u00fb\u00fc\u00fd\u00ff\u0160\u0161\u0178".toCharArray();
    public static final char[] NAO_ACENTUADOS = "AAAAAACEEEEIIIINOOOOOUUUUYaaaaaaceeeeiiiinooooouuuuyySsY".toCharArray();

    private StringUtil() {
    }

    public static String byteToHex(byte codigo) {
        String textByte = Integer.toHexString(codigo + 128).toUpperCase();
        if (textByte.length() == 1) {
            textByte = String.valueOf('0') + textByte;
        }
        return textByte;
    }

    public static String appendString(String texto, String complemento, int comprimento, boolean posfixado) {
        if (posfixado) {
            return String.valueOf(texto) + StringUtil.stringOf(complemento, comprimento - texto.length());
        }
        return String.valueOf(StringUtil.stringOf(complemento, comprimento - texto.length())) + texto;
    }

    public static String fromByteString(String texto) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < texto.length()) {
            result.append((char)Integer.parseInt(texto.substring(i, i + 3)));
            i += 3;
        }
        return result.toString();
    }

    public static String join(String[] array) {
        switch (array.length) {
            case 0: {
                return STRING_VAZIA;
            }
            case 1: {
                return array[0];
            }
        }
        StringBuffer result = new StringBuffer(array.length * ((array[0].length() + array[1].length()) / 2));
        result.append(array[0]);
        int i = 1;
        while (i < array.length) {
            result.append(array[i]);
            ++i;
        }
        return result.toString();
    }

    public static String join(String[] array, String delim) {
        switch (array.length) {
            case 0: {
                return STRING_VAZIA;
            }
            case 1: {
                return array[0];
            }
        }
        StringBuffer result = new StringBuffer((array.length + delim.length()) * ((array[0].length() + array[1].length()) / 2));
        result.append(array[0]);
        int i = 1;
        while (i < array.length) {
            result.append(delim).append(array[i]);
            ++i;
        }
        return result.toString();
    }

    public static String mask(String text, String appliedMask) {
        String aux = STRING_VAZIA;
        int maskLenght = appliedMask.length();
        if (text == null) {
            text = STRING_VAZIA;
        }
        int textLength = text.length();
        int j = textLength - 1;
        int i = maskLenght - 1;
        while (i >= 0) {
            char maskChar = appliedMask.charAt(i);
            if ((maskChar == '9' || maskChar == '0') && j >= 0) {
                aux = String.valueOf(text.charAt(j)) + aux;
                --j;
            } else if (maskChar != '9') {
                aux = String.valueOf(maskChar) + aux;
            }
            --i;
        }
        return aux;
    }

    public static String removeAccents(String texto) {
        int comprimento = texto.length();
        StringBuffer retorno = new StringBuffer(comprimento);
        int i = 0;
        while (i < comprimento) {
            char atual = texto.charAt(i);
            int indice = Arrays.binarySearch(ACENTUADOS, atual);
            if (indice == -1) {
                retorno.append(atual);
            } else {
                retorno.append(NAO_ACENTUADOS[indice]);
            }
            ++i;
        }
        return retorno.toString();
    }

    public static String removeNotAlphaNumeric(String texto) {
        String aux = StringUtil.removeAccents(texto);
        String result = STRING_VAZIA;
        int i = 0;
        while (i < texto.length()) {
            byte current = (byte)aux.charAt(i);
            if (current >= 48 && current <= 58 || current >= 65 && current <= 90 || current >= 97 && current <= 122) {
                result = String.valueOf(result) + texto.charAt(i);
            }
            ++i;
        }
        return result;
    }

    public static String removeNotNumeric(String texto) {
        StringBuffer retorno = new StringBuffer();
        int len = texto.length();
        int i = 0;
        while (i < len) {
            char atual = texto.charAt(i);
            if (atual >= '0' && atual <= '9') {
                retorno.append(atual);
            }
            ++i;
        }
        return retorno.toString();
    }

    public static String replace(String texto, String substituido, String substituicao) {
        if (texto == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(texto);
        int fromLength = substituido.length();
        int toLength = substituicao.length();
        int difference = toLength - fromLength;
        int i = -1;
        int offset = 0;
        int start = 0;
        int end = 0;
        while ((i = texto.indexOf(substituido, i + 1)) > -1) {
            start = i + offset;
            end = start + fromLength;
            buffer.replace(start, end, substituicao);
            offset += difference;
        }
        return buffer.toString();
    }

    public static String replaceAccents(String texto, char caracter) {
        int comprimento = texto.length();
        StringBuffer retorno = new StringBuffer(comprimento);
        int i = 0;
        while (i < comprimento) {
            char atual = texto.charAt(i);
            int indice = Arrays.binarySearch(ACENTUADOS, atual);
            if (indice == -1) {
                retorno.append(atual);
            } else {
                retorno.append(caracter);
            }
            ++i;
        }
        return retorno.toString();
    }

    public static String replaceLineBreaks(String texto, String substituicao) {
        int comprimento = texto.length();
        StringBuffer result = new StringBuffer((int)((double)comprimento * 1.05));
        char atual = '\u0000';
        char lastBreak = '\u0000';
        int breakIndex = -2;
        char[] buffer = texto.toCharArray();
        int i = 0;
        while (i < comprimento) {
            atual = buffer[i];
            if (atual == '\n' || atual == '\r') {
                if (atual == lastBreak || breakIndex != i - 1) {
                    result.append(substituicao);
                    breakIndex = i;
                    lastBreak = buffer[breakIndex];
                }
            } else {
                result.append(atual);
            }
            ++i;
        }
        return result.toString();
    }

    public static String[] split(String texto, char delim) {
        int tokenCount = 1;
        int length = texto.length();
        char[] buffer = texto.toCharArray();
        int i = 0;
        while (i < length) {
            if (buffer[i] == delim) {
                ++tokenCount;
            }
            ++i;
        }
        String[] result = new String[tokenCount];
        int tokenStart = 0;
        int j = 0;
        int i2 = 0;
        while (i2 < length) {
            if (buffer[i2] == delim) {
                result[j++] = texto.substring(tokenStart, i2);
                tokenStart = i2 + 1;
            }
            ++i2;
        }
        result[j] = texto.substring(tokenStart);
        return result;
    }

    public static String[] split(String texto, String delim) {
        return texto.split(delim);
    }

    public static String stringOf(String text, int count) {
        int incremento = text.length();
        StringBuffer result = new StringBuffer(count * incremento);
        int i = 0;
        while (i < count) {
            result.append(text);
            i += incremento;
        }
        return result.toString();
    }

    public static String toByteString(String texto) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < texto.length()) {
            result.append(StringUtil.byteToHex((byte)texto.charAt(i)));
            ++i;
        }
        return result.toString();
    }

    public static String wrapText(String text, int size) {
        return StringUtil.wrapText(text, size, "...");
    }

    public static String wrapText(String texto, int comprimento, String delim) {
        if (texto == null) {
            return null;
        }
        if (texto.length() > comprimento) {
            texto = texto.substring(0, comprimento - delim.length());
            BreakIterator bi = BreakIterator.getWordInstance(new Locale("pt", "BR"));
            bi.setText(texto);
            int boundary = bi.last();
            boundary = bi.previous();
            if (boundary == 0) {
                return String.valueOf(texto) + delim;
            }
            return String.valueOf(texto.substring(0, boundary)) + delim;
        }
        return texto;
    }

    public static String encode(String str, String encoding) throws UnsupportedEncodingException {
        return encoding != null ? new String(str.getBytes(), encoding) : str;
    }

    public static boolean isVazia(String str) {
        return str == null || str.trim().length() == 0;
    }
}

