/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util;

import br.com.bb.plugins.gac.util.FormatadorNumero;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UtilMascaraFormatador {
    private String mascara;
    private String valor;
    private boolean retornaVazio;

    public static String getValorComMascara(String mascara, String valor, boolean isRetornaVazio) {
        if (isRetornaVazio && (valor == null || valor.trim().equals(""))) {
            return "";
        }
        int i = 0;
        while (i < valor.length()) {
            mascara = mascara.replaceFirst("#", valor.substring(i, i + 1));
            ++i;
        }
        return mascara.replaceAll("#", "");
    }

    public static String retornaValorMascara(String mascara, String valor) {
        Pattern pattern = Pattern.compile("\\D");
        Matcher matcher = pattern.matcher(valor);
        if (matcher.find()) {
            throw new IllegalArgumentException("valor possui letras");
        }
        int tamanhoMasc = mascara.replaceAll("[:,.;\\-/]", "").length();
        if (valor.trim().length() != tamanhoMasc) {
            throw new IllegalArgumentException("Quantidade de digitos da mascara diferente da quantidade de digitos do valor passado");
        }
        String[] charp = mascara.split("[:,.;\\-/]");
        Pattern pattern2 = Pattern.compile("[:,.;\\-/]");
        Matcher matcher2 = pattern2.matcher(mascara);
        StringBuilder regex = new StringBuilder();
        StringBuilder replace = new StringBuilder("$1");
        int indice = 2;
        String[] stringArray = charp;
        int n = charp.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            regex.append("(").append("\\d").append("{").append(string.length()).append("}").append(")");
            if (matcher2.find()) {
                replace.append(matcher2.group()).append("$").append(indice);
                ++indice;
            }
            ++n2;
        }
        return valor.replaceFirst(regex.toString(), replace.toString());
    }

    public static String getValorComMascaraAgEContaOutrosBancos(String valor) {
        String dv = valor.substring(valor.length() - 1);
        valor = valor.substring(0, valor.length() - 1);
        valor = FormatadorNumero.formatarValor(Long.parseLong(valor));
        return String.valueOf(valor) + "-" + dv;
    }

    @Deprecated
    public static String preencheZerosAEsquerda(int sizeMax, String valor) {
        StringBuilder valorRetorno = new StringBuilder();
        if (valor.length() < sizeMax && valor.length() > 0) {
            while (valor.length() < sizeMax) {
                valor = String.valueOf(0) + valor;
                valorRetorno.append("0");
            }
        }
        return valor;
    }

    public static String novoPreencheZerosAEsquerda(int sizeMax, String valor) {
        StringBuilder valorRetorno = new StringBuilder();
        int size = sizeMax - valor.length();
        if (valorRetorno.length() < size && valorRetorno.length() >= 0) {
            while (valorRetorno.length() < size) {
                valorRetorno.append("0");
            }
        }
        valorRetorno.append(valor);
        return valorRetorno.toString();
    }

    public static String getValorComMascara(String mascara, String valor) {
        return UtilMascaraFormatador.getValorComMascara(mascara, valor, true);
    }

    public String getMascara() {
        return this.mascara;
    }

    public void setMascara(String mascara) {
        this.mascara = mascara;
    }

    public String getValorComMascara() {
        return UtilMascaraFormatador.getValorComMascara(this.getMascara(), this.getValue(), this.isRetornaVazio());
    }

    public String getValue() {
        return this.valor;
    }

    public void setValor(String valor) {
        this.valor = valor;
    }

    public boolean isRetornaVazio() {
        return this.retornaVazio;
    }

    public void setRetornaVazio(boolean isRetornaVazio) {
        this.retornaVazio = isRetornaVazio;
    }
}

