/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.util.UtilBBException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private static final int BUFFER = 2048;

    public static byte[] compacta(byte[] b) throws BBException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ZipOutputStream zout = new ZipOutputStream(bos);
            ZipEntry zipentry = new ZipEntry("");
            zipentry.setSize(b.length);
            zipentry.setTime(new Date().getTime());
            zout.putNextEntry(zipentry);
            zout.write(b);
            zout.closeEntry();
            zout.close();
            return bos.toByteArray();
        }
        catch (Exception e) {
            throw UtilBBException.getErroDeSistema(e);
        }
    }

    public static void zip(String dirOrigem, String destino, FilenameFilter filtro) throws BBException {
        try {
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream(destino);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[2048];
            File[] files = filtro != null ? new File(dirOrigem).listFiles(filtro) : new File(dirOrigem).listFiles();
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                int count;
                File file = fileArray[n2];
                FileInputStream fi = new FileInputStream(file);
                origin = new BufferedInputStream(fi, 2048);
                ZipEntry entry = new ZipEntry(file.getPath().substring(dirOrigem.length()));
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
                ++n2;
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BBException("Acesso negado!");
        }
    }

    public static void unzip(String zipFilePath, String destino) {
        try {
            new File(destino).mkdirs();
            if (!destino.endsWith(File.separator)) {
                destino = String.valueOf(destino) + File.separator;
            }
            ZipFile zipFile = new ZipFile(zipFilePath);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String destFile = String.valueOf(destino) + entry.getName();
                if (entry.isDirectory()) {
                    new File(destFile).mkdir();
                    continue;
                }
                new File(destFile).getParentFile().mkdirs();
                ZipUtils.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(destFile)));
            }
            zipFile.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static byte[] descompacta(byte[] b) throws BBException {
        try {
            int n;
            ByteArrayInputStream bis = new ByteArrayInputStream(b);
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(bis));
            ZipEntry zipentry = zis.getNextEntry();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] rgb = new byte[1000];
            while ((n = zis.read(rgb)) > -1) {
                bos.write(rgb, 0, n);
            }
            zis.closeEntry();
            zis.close();
            return bos.toByteArray();
        }
        catch (Exception e) {
            throw UtilBBException.getErroDeSistema(e);
        }
    }

    public static void descompacta(String zipFile, String pathToUnzip) throws BBException {
        try {
            ZipFile zip = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String[] nome = entry.getName().split("/");
                if (nome.length > 1) {
                    File file = new File(String.valueOf(pathToUnzip) + nome[0]);
                    if (!file.exists()) {
                        file.mkdir();
                    }
                    ZipUtils.copyInputStream(zip.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(String.valueOf(pathToUnzip) + nome[1])));
                }
                if (entry.isDirectory()) {
                    new File(String.valueOf(pathToUnzip) + entry.getName()).mkdir();
                    continue;
                }
                ZipUtils.copyInputStream(zip.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(String.valueOf(pathToUnzip) + entry.getName())));
            }
            zip.close();
        }
        catch (IOException ioe) {
            throw UtilBBException.getErroDeSistema(ioe);
        }
    }

    public static void descompacta(String nameZipFile, String nameFileToUnzip, String pathToUnizp) throws BBException {
        try {
            ZipFile zipFile = new ZipFile(nameZipFile);
            ZipEntry entry = zipFile.getEntry(nameFileToUnzip);
            if (entry.isDirectory()) {
                new File(entry.getName()).mkdir();
            }
            ZipUtils.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(String.valueOf(pathToUnizp) + entry.getName())));
            zipFile.close();
        }
        catch (IOException ioe) {
            throw UtilBBException.getErroDeSistema(ioe);
        }
    }

    public static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static byte[] descompacta(byte[] zipBytes, String fileToUnZip) throws BBException {
        ByteArrayOutputStream baos = null;
        try {
            int len;
            ZipEntry zipEntry;
            baos = new ByteArrayOutputStream();
            ByteArrayInputStream bais = new ByteArrayInputStream(zipBytes);
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(bais));
            while ((zipEntry = zis.getNextEntry()) != null && !fileToUnZip.equalsIgnoreCase(zipEntry.getName())) {
            }
            byte[] fileBytes = new byte[2048];
            BufferedOutputStream bos = new BufferedOutputStream(baos, fileBytes.length);
            while ((len = zis.read(fileBytes, 0, fileBytes.length)) != -1) {
                bos.write(fileBytes, 0, len);
            }
            bos.flush();
            bos.close();
            zis.close();
        }
        catch (IOException ioe) {
            throw UtilBBException.getErroDeSistema(ioe);
        }
        return baos.toByteArray();
    }

    public static void descompactaPara(byte[] ajudaDBTZipBytes, String pathAjuda) {
    }

    public static void main(String[] args) {
    }

    public static byte[] descompactaBYTE(String nameZIPFile, String nameFileToUnZIP) throws BBException {
        try {
            ZipFile zipFile = new ZipFile(nameZIPFile);
            ZipEntry zipEntry = zipFile.getEntry(nameFileToUnZIP);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipUtils.copyInputStream(zipFile.getInputStream(zipEntry), new BufferedOutputStream(baos));
            zipFile.close();
            return baos.toByteArray();
        }
        catch (Exception ioe) {
            throw UtilBBException.getErroDeSistema(ioe);
        }
    }
}

