/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.bean;

import br.com.bb.plugins.gac.util.bean.PropertyInvocationException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class BeanUtil {
    private BeanUtil() {
    }

    public static PropertyDescriptor getPropertyDescriptor(PropertyDescriptor[] propertyDescriptors, String propriedade) {
        int i = 0;
        while (i < propertyDescriptors.length) {
            if (propertyDescriptors[i].getName().equals(propriedade)) {
                return propertyDescriptors[i];
            }
            ++i;
        }
        return null;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class classe, String propriedade) throws IntrospectionException {
        BeanInfo beaninfo = Introspector.getBeanInfo(classe);
        PropertyDescriptor[] propertyDescriptors = beaninfo.getPropertyDescriptors();
        PropertyDescriptor descritor = BeanUtil.getPropertyDescriptor(propertyDescriptors, propriedade);
        if (descritor == null) {
            throw new IntrospectionException("N\u00e3o existe a propriedade no java bean.");
        }
        return descritor;
    }

    public static Object handleGetProperty(Object javaBean, String propriedade) throws PropertyInvocationException {
        if (javaBean == null) {
            throw new PropertyInvocationException(null, propriedade, new NullPointerException("N\u00e3o existe a propriedade no java bean."));
        }
        try {
            Method method = BeanUtil.getPropertyDescriptor(javaBean.getClass(), propriedade).getReadMethod();
            return method.invoke(javaBean, null);
        }
        catch (Exception ex) {
            throw new PropertyInvocationException(javaBean, propriedade, ex);
        }
    }

    public static Object getValorAtributos(Object bean, List atributos) throws PropertyInvocationException, IntrospectionException, IllegalAccessException, InstantiationException {
        int atributosSize = atributos.size();
        String primeiroAtributo = (String)atributos.get(0);
        Object valor = BeanUtil.handleGetProperty(bean, primeiroAtributo);
        if (atributosSize == 1 || valor == null) {
            return valor;
        }
        return BeanUtil.getValorAtributos(valor, atributos.subList(1, atributosSize));
    }

    public static Object getValorAtributos(Object bean, String[] atributos) throws IntrospectionException, InstantiationException, PropertyInvocationException, IllegalAccessException {
        return BeanUtil.getValorAtributos(bean, Arrays.asList(atributos));
    }
}

