/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.bean;

import java.lang.reflect.InvocationTargetException;

public class PropertyInvocationException
extends Exception {
    private static final long serialVersionUID = 7678093887125413968L;
    private Throwable rootCause;
    private String className;
    private String propertyName;
    private String message;

    public PropertyInvocationException(Object javaBean, String propertyName, Throwable throwable) {
        if (javaBean != null) {
            this.setClassName(javaBean.getClass().getName());
        }
        this.setPropertyName(propertyName);
        this.setRootCause(throwable);
    }

    public String getClassName() {
        return this.className;
    }

    public String getMessage() {
        if (this.message == null) {
            StringBuffer tmpMsg = new StringBuffer();
            tmpMsg.append("Erro invocando a propriedade \"").append(this.propertyName).append("\"");
            if (this.className != null) {
                tmpMsg.append(" da classe \"").append(this.className).append("\"");
            }
            tmpMsg.append(": ");
            if (this.rootCause instanceof InvocationTargetException) {
                tmpMsg.append(((InvocationTargetException)this.rootCause).getTargetException().getMessage());
            }
            this.message = tmpMsg.toString();
        }
        return this.message;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    private void setClassName(String className) {
        this.className = className;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    private void setRootCause(Throwable rootCause) {
        this.rootCause = rootCause;
    }
}

