/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.importacao;

import br.com.bb.plugins.gac.util.importacao.CampoTabela;
import br.com.bb.plugins.gac.util.importacao.DefinicaoTabela;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MigrarDados {
    private String urlorigem = null;
    private String urldestino = null;
    private String driverorigem = null;
    private String driverdestino = null;
    private Connection connorigem = null;
    private Connection conndestino = null;
    private int sequencial = 0;

    public MigrarDados() {
        this.setUrlorigem("jdbc:odbc:BBGAC");
        this.setDriverorigem("sun.jdbc.odbc.JdbcOdbcDriver");
        this.setUrldestino("jdbc:firebirdsql:BSB024418:BBGAC");
        this.setDriverdestino("org.firebirdsql.jdbc.FBDriver");
    }

    public static void main(String[] args) {
        MigrarDados migrar = new MigrarDados();
    }

    public void executarMigracao(DefinicaoTabela defTipoPessoa) {
        try {
            String s_sql = "SELECT * FROM " + defTipoPessoa.getOrigem();
            Statement stmt = this.getConnorigem().createStatement();
            ResultSet rs = stmt.executeQuery(s_sql);
            while (rs.next()) {
                String s_sqlinsert = defTipoPessoa.getSQLImport();
                PreparedStatement prepStatement = this.getConndestino().prepareStatement(s_sqlinsert);
                int posic = 0;
                for (CampoTabela campo : defTipoPessoa.getCampos()) {
                    this.popularCampoDestino(prepStatement, ++posic, rs, campo);
                }
                System.out.println(s_sql);
                try {
                    prepStatement.executeUpdate();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void popularCampoDestino(PreparedStatement prepStatement, int posic, ResultSet rs, CampoTabela campo) throws SQLException {
        if (campo.getNomeorigem().trim().length() == 0) {
            switch (campo.getTipodestino()) {
                case 2: {
                    prepStatement.setInt(posic, Integer.parseInt(campo.getValordefault()));
                    break;
                }
                case 1: {
                    prepStatement.setString(posic, campo.getValordefault());
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 99: {
                    prepStatement.setInt(posic, this.getSequencial());
                }
            }
            return;
        }
        if (campo.getTipodestino() == campo.getTipoorigem()) {
            switch (campo.getTipodestino()) {
                case 2: {
                    prepStatement.setInt(posic, rs.getInt(campo.getNomeorigem()));
                    break;
                }
                case 1: {
                    prepStatement.setString(posic, rs.getString(campo.getNomeorigem()));
                    break;
                }
                case 3: {
                    prepStatement.setDate(posic, rs.getDate(campo.getNomeorigem()));
                    break;
                }
                case 4: {
                    prepStatement.setDouble(posic, rs.getDouble(campo.getNomeorigem()));
                }
            }
        } else {
            switch (campo.getTipodestino()) {
                case 2: {
                    prepStatement.setInt(posic, rs.getInt(campo.getNomeorigem()));
                    break;
                }
                case 1: {
                    prepStatement.setString(posic, "" + rs.getObject(campo.getNomeorigem()));
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
    }

    public void setSequencial(int sequencial) {
        this.sequencial = sequencial;
    }

    public int getSequencial() {
        return ++this.sequencial;
    }

    public Connection getConndestino() {
        if (this.conndestino == null) {
            try {
                this.conndestino = this.conectarBD(this.getDriverdestino(), this.getUrldestino(), "SYSDBA", "masterkey");
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return this.conndestino;
    }

    public Connection getConnorigem() {
        if (this.connorigem == null) {
            try {
                this.connorigem = this.conectarBD(this.getDriverorigem(), this.getUrlorigem(), "administrador", "persona");
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return this.connorigem;
    }

    public Connection conectarBD(String driver, String url, String usuarioSGBD, String senhaSGBD) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        return DriverManager.getConnection(url, usuarioSGBD, senhaSGBD);
    }

    public String getDriverdestino() {
        return this.driverdestino;
    }

    public void setDriverdestino(String driverdestino) {
        this.driverdestino = driverdestino;
    }

    public String getDriverorigem() {
        return this.driverorigem;
    }

    public void setDriverorigem(String driverorigem) {
        this.driverorigem = driverorigem;
    }

    public String getUrldestino() {
        return this.urldestino;
    }

    public void setUrldestino(String urldestino) {
        this.urldestino = urldestino;
    }

    public String getUrlorigem() {
        return this.urlorigem;
    }

    public void setUrlorigem(String urlorigem) {
        this.urlorigem = urlorigem;
    }
}

