/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.interceptor;

import br.com.bb.plugins.gac.negocio.to.UsuarioTO;
import br.com.bb.plugins.gac.util.controller.servico.SecurityService;
import java.lang.reflect.Method;
import java.util.Calendar;
import org.springframework.aop.AfterReturningAdvice;

public class AuditInterceptor
implements AfterReturningAdvice {
    private SecurityService securityService;

    public AuditInterceptor(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void afterReturning(Object returnValue, Method method, Object[] args, Object target) throws Throwable {
        String nmMetodo = method.getName().toString().toLowerCase();
        if (nmMetodo.startsWith("save") || nmMetodo.startsWith("update") || nmMetodo.startsWith("delete")) {
            UsuarioTO usuario = this.securityService.getUsuarioAtual();
            Calendar horaAtual = Calendar.getInstance();
            horaAtual.setTimeInMillis(System.currentTimeMillis());
            String acao = String.valueOf(usuario.getTextoNomeUsuarioSistema()) + " acessou o Servi\u00e7o " + target.getClass().getName() + "." + method.getName();
            this.securityService.auditarUsuario(usuario, acao);
        }
    }
}

