/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.leitora;

import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.bb.plugins.gac.util.leitora.LeitoraListener;
import br.com.bb.plugins.gac.util.leitora.LeitoraListenerPopulaMetodo;
import br.com.bb.plugins.gac.util.leitora.serial.l50.LeitoraL50;
import java.io.File;
import java.security.AccessControlException;

public class LeitoraL50BBGAC {
    private static final long serialVersionUID = 1L;
    private LeitoraL50 l50 = new LeitoraL50();
    private static LeitoraL50BBGAC leitoraL50BBGAC;

    private LeitoraL50BBGAC() {
    }

    private String defineBiblioteca(String userAgent) {
        String retorno = "rxtxSerial.dll";
        if (userAgent.toLowerCase().indexOf("mac") != -1) {
            retorno = "librxtxSerial.jnilib";
        } else if (userAgent.toLowerCase().indexOf("linux") != -1) {
            retorno = "librxtxSerial32i86.so";
        }
        return retorno;
    }

    public static LeitoraL50BBGAC getInstance() {
        if (leitoraL50BBGAC == null) {
            leitoraL50BBGAC = new LeitoraL50BBGAC();
            leitoraL50BBGAC.carregaBiblioteca(System.getProperty("os.name"));
        }
        return leitoraL50BBGAC;
    }

    public void adicionaLeitoraListener(LeitoraListener leitoraListener) {
        this.configura(leitoraListener);
    }

    private void configura(LeitoraListener leitoraListener) {
        try {
            this.l50.adicionarLeitoraListener(leitoraListener);
            this.l50.setLeituraAtiva(true);
        }
        catch (AccessControlException ace) {
            ace.printStackTrace();
            this.trataErro("N\u00e3o foi poss\u00edvel ativar a leitora(3).");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.trataErro("N\u00e3o foi poss\u00edvel ativar a leitora(4).");
        }
        catch (Error e) {
            e.printStackTrace();
            this.trataErro("N\u00e3o foi poss\u00edvel ativar a leitora(5).");
        }
    }

    private void carregaBiblioteca(String os) {
        String biblioteca = this.defineBiblioteca(os);
        try {
            File fileDestino = new File(String.valueOf(ConfiguracaoProperties.getConfiguracaoProperties().getDirProg()) + "/" + biblioteca);
            if (fileDestino != null) {
                System.load(fileDestino.getAbsolutePath());
            }
        }
        catch (Throwable t) {
            this.trataErro("N\u00e3o foi poss\u00edvel carregar a biblioteca(2).");
        }
    }

    public void desativa() {
        System.out.print("Desativando leitora...");
        this.l50.setLeituraAtiva(false);
        System.out.println("[ok]");
    }

    public void trataErro(String s) {
        try {
            System.out.println(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void criaLeitoraListener(Object objetoQuePossuiOMetodo, String nomeDoMetodoComAssinaturaDoTipoString) {
        LeitoraListenerPopulaMetodo leitoraListener = new LeitoraListenerPopulaMetodo(objetoQuePossuiOMetodo, nomeDoMetodoComAssinaturaDoTipoString);
        this.adicionaLeitoraListener(leitoraListener);
    }
}

