/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.leitora.serial;

import br.com.bb.plugins.gac.util.leitora.LeitoraListener;
import gnu.io.CommPortIdentifier;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Leitora {
    private Vector leitoraListeners = new Vector();
    private boolean leitoraAtiva;

    public final void adicionarLeitoraListener(LeitoraListener leitoraListener) {
        this.leitoraListeners.add(leitoraListener);
    }

    public final boolean isLeitoraAtiva() {
        return this.leitoraAtiva;
    }

    public final void removerLeitoraListener(LeitoraListener leitoraListener) {
        this.leitoraListeners.remove(leitoraListener);
    }

    public final void removerTodosLeitoraListeners() {
        this.leitoraListeners.clear();
    }

    public final void setLeituraAtiva(boolean leituraAtiva) {
        this.leitoraAtiva = leituraAtiva;
        if (leituraAtiva) {
            this.inicializarPortas();
        } else {
            this.finalizarPortas();
        }
    }

    protected abstract void finalizarPorta(CommPortIdentifier var1) throws Exception;

    protected abstract void inicializarPorta(CommPortIdentifier var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notificarLeitoraListeners(String conteudo) {
        if (this.leitoraAtiva) {
            Vector vector = this.leitoraListeners;
            synchronized (vector) {
                int qtdListeners = this.leitoraListeners.size();
                int i = 0;
                while (i < qtdListeners) {
                    ((LeitoraListener)this.leitoraListeners.elementAt(i)).conteudoLido(conteudo);
                    ++i;
                }
            }
        }
    }

    private synchronized void finalizarPortas() {
        Enumeration i = CommPortIdentifier.getPortIdentifiers();
        while (i.hasMoreElements()) {
            CommPortIdentifier identificadorPorta = (CommPortIdentifier)i.nextElement();
            try {
                this.finalizarPorta(identificadorPorta);
            }
            catch (Exception e) {
                System.err.println("Erro ao finalizar porta " + identificadorPorta.getName() + ": " + e);
            }
        }
    }

    private synchronized void inicializarPortas() {
        Enumeration i = CommPortIdentifier.getPortIdentifiers();
        while (i.hasMoreElements()) {
            CommPortIdentifier identificadorPorta = (CommPortIdentifier)i.nextElement();
            try {
                this.inicializarPorta(identificadorPorta);
            }
            catch (Exception e) {
                System.err.println("Erro ao inicializar porta " + identificadorPorta.getName() + ": " + e);
            }
        }
    }
}

