/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.leitora.serial.l50;

import br.com.bb.plugins.gac.util.leitora.serial.LeitoraSerial;
import br.com.bb.plugins.gac.util.leitora.serial.l50.LeitoraL50Exception;
import gnu.io.CommPort;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LeitoraL50
extends LeitoraSerial {
    private static final int ASCII_STX = 2;
    private static final int ASCII_ETX = 3;
    private static final int ASCII_ACK = 6;
    private static final int ASCII_NAK = 21;
    private StringBuffer bufferLeitura = new StringBuffer();
    private int csum = 0;
    private boolean leituraIniciada = false;
    private boolean leituraTerminada = false;
    private SerialPortEventListener l50Listener = new SerialPortEventListener(){

        public void serialEvent(SerialPortEvent eventoPortaSerial) {
            SerialPort portaSerial = (SerialPort)eventoPortaSerial.getSource();
            try {
                LeitoraL50.this.atualizarConteudo(portaSerial);
            }
            catch (Exception e) {
                System.err.println(e);
                LeitoraL50.this.erroLeitura(portaSerial);
            }
        }
    };

    protected final void finalizarPortaSerial(SerialPort portaSerial) throws Exception {
        portaSerial.close();
    }

    protected final void inicializarPortaSerial(SerialPort portaSerial) throws Exception {
        portaSerial.setSerialPortParams(2400, 7, 1, 2);
        portaSerial.addEventListener(this.l50Listener);
        portaSerial.notifyOnDataAvailable(true);
    }

    private void atualizarConteudo(SerialPort portaSerial) throws IOException {
        byte[] bytes = this.lerPorta(portaSerial);
        int i = 0;
        while (i < bytes.length) {
            if (this.leituraTerminada) {
                if ((this.csum & 0x7F) == bytes[i]) {
                    this.sucessoLeitura(portaSerial);
                    break;
                }
                throw new LeitoraL50Exception("Checksum n\u00e3o confere");
            }
            switch (bytes[i]) {
                case 6: {
                    break;
                }
                case 21: {
                    throw new LeitoraL50Exception("Recebido ASCII_NAK");
                }
                case 3: {
                    if (this.leituraIniciada) {
                        this.leituraTerminada = true;
                        this.csum ^= bytes[i];
                        break;
                    }
                    throw new LeitoraL50Exception("Recebido ASCII_ETX sem ter recebido ASCII_STX");
                }
                case 2: {
                    if (!this.leituraIniciada) {
                        this.leituraIniciada = true;
                        break;
                    }
                    throw new LeitoraL50Exception("Recebido ASCII_STX duas vezes sem ter recebido ASCII_ETX");
                }
                default: {
                    if (this.leituraIniciada) {
                        this.bufferLeitura.append((char)bytes[i]);
                        this.csum ^= bytes[i];
                        break;
                    }
                    throw new LeitoraL50Exception("Recebido caractere inv\u00e1lido");
                }
            }
            ++i;
        }
    }

    private void erroLeitura(SerialPort portaSerial) {
        this.limpar();
        try {
            OutputStream os = portaSerial.getOutputStream();
            os.write(21);
            os.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private byte[] lerPorta(CommPort porta) throws IOException {
        InputStream is = porta.getInputStream();
        byte[] bytes = new byte[is.available()];
        is.read(bytes);
        return bytes;
    }

    private void limpar() {
        this.csum = 0;
        this.leituraIniciada = false;
        this.leituraTerminada = false;
        this.bufferLeitura.delete(0, this.bufferLeitura.length());
    }

    private void sucessoLeitura(SerialPort portaSerial) throws IOException {
        OutputStream os = portaSerial.getOutputStream();
        os.write(6);
        os.flush();
        this.notificarLeitoraListeners(this.bufferLeitura.toString());
        this.limpar();
    }
}

